/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.xml.FullCustomerConverter;

@Domain
@XStreamAlias(value="competition")
public class Competition {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private String name = "default";
    private String description = "";
    @XStreamAsAttribute
    private String pomId = "unknown";
    @XStreamAsAttribute
    private int timeslotLength = 60;
    @XStreamAsAttribute
    private int bootstrapTimeslotCount = 336;
    @XStreamAsAttribute
    private int bootstrapDiscardedTimeslots = 24;
    @XStreamOmitField
    private int minimumTimeslotCount = 480;
    @XStreamOmitField
    private int expectedTimeslotCount = 600;
    @XStreamAsAttribute
    private int timeslotsOpen = 24;
    @XStreamAsAttribute
    private int deactivateTimeslotsAhead = 1;
    @XStreamAsAttribute
    private double minimumOrderQuantity = 0.01;
    @XStreamAsAttribute
    private Instant simulationBaseTime = new DateTime(2010, 6, 21, 0, 0, 0, 0, DateTimeZone.UTC).toInstant();
    @XStreamAsAttribute
    private int timezoneOffset = 0;
    @XStreamAsAttribute
    private int latitude = 45;
    @XStreamAsAttribute
    private long simulationRate = 720L;
    @XStreamAsAttribute
    private long simulationModulo = 3600000L;
    @XStreamImplicit(itemFieldName="broker")
    private ArrayList<String> brokers;
    @XStreamImplicit(itemFieldName="customer")
    @XStreamConverter(value=FullCustomerConverter.class)
    private ArrayList<CustomerInfo> customers;
    private static Competition theCompetition;

    public static Competition newInstance(String name) {
        Competition result = new Competition(name);
        return result;
    }

    public static Competition currentCompetition() {
        return theCompetition;
    }

    public static void setCurrent(Competition newCurrent) {
        theCompetition = newCurrent;
    }

    private Competition(String name) {
        this.name = name;
        this.brokers = new ArrayList();
        this.customers = new ArrayList();
        theCompetition = this;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @ConfigurableValue(description="user-readable description of the Competition", valueType="String")
    @StateChange
    public Competition withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPomId() {
        return this.pomId;
    }

    @ConfigurableValue(description="maven version identifier from server", valueType="String")
    @StateChange
    public Competition withPomId(String id) {
        this.pomId = id;
        return this;
    }

    public int getTimeslotLength() {
        return this.timeslotLength;
    }

    public long getTimeslotDuration() {
        return (long)this.timeslotLength * 60000L;
    }

    @ConfigurableValue(name="timeslotLength", description="length of timeslot in minutes sim time", valueType="Integer")
    @StateChange
    public Competition withTimeslotLength(int timeslotLength) {
        this.timeslotLength = timeslotLength;
        return this;
    }

    public int getMinimumTimeslotCount() {
        return this.minimumTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="minimum number of timeslots in simulation run")
    @StateChange
    public Competition withMinimumTimeslotCount(int minimumTimeslotCount) {
        this.minimumTimeslotCount = minimumTimeslotCount;
        return this;
    }

    public int getExpectedTimeslotCount() {
        return this.expectedTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withExpectedTimeslotCount(int expectedTimeslotCount) {
        this.expectedTimeslotCount = expectedTimeslotCount;
        return this;
    }

    public int getTimeslotsOpen() {
        return this.timeslotsOpen;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withTimeslotsOpen(int timeslotsOpen) {
        this.timeslotsOpen = timeslotsOpen;
        return this;
    }

    public int getDeactivateTimeslotsAhead() {
        return this.deactivateTimeslotsAhead;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withDeactivateTimeslotsAhead(int deactivateTimeslotsAhead) {
        this.deactivateTimeslotsAhead = deactivateTimeslotsAhead;
        return this;
    }

    public double getMinimumOrderQuantity() {
        return this.minimumOrderQuantity;
    }

    @ConfigurableValue(valueType="Double", description="Minimum order quantity in MWh")
    @StateChange
    public Competition withMinimumOrderQuantity(double minOrderQty) {
        this.minimumOrderQuantity = minOrderQty;
        return this;
    }

    public Instant getSimulationBaseTime() {
        return this.simulationBaseTime;
    }

    public Competition withSimulationBaseTime(Instant simulationBaseTime) {
        return this.withSimulationBaseTime(simulationBaseTime.getMillis());
    }

    @ConfigurableValue(valueType="String", description="Scenario start time of the bootstrap portion of a simulation")
    public Competition withSimulationBaseTime(String baseTime) {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        return this.withSimulationBaseTime(fmt.parseDateTime(baseTime).toInstant());
    }

    @StateChange
    public Competition withSimulationBaseTime(long baseTime) {
        this.simulationBaseTime = new Instant(baseTime);
        return this;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Timezone offset from UTC for sim locale")
    @StateChange
    public Competition withTimezoneOffset(int offset) {
        this.timezoneOffset = offset;
        return this;
    }

    public int getLatitude() {
        return this.latitude;
    }

    @ConfigurableValue(valueType="Integer", description="Approximate latitude of sim locale")
    @StateChange
    public Competition withLatitude(int latitude) {
        this.latitude = latitude;
        return this;
    }

    public int getBootstrapTimeslotCount() {
        return this.bootstrapTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session during which data is collected")
    @StateChange
    public Competition withBootstrapTimeslotCount(int bootstrapTimeslotCount) {
        this.bootstrapTimeslotCount = bootstrapTimeslotCount;
        return this;
    }

    public int getBootstrapDiscardedTimeslots() {
        return this.bootstrapDiscardedTimeslots;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session that are discardedbefore data collection begins")
    @StateChange
    public Competition withBootstrapDiscardedTimeslots(int count) {
        this.bootstrapDiscardedTimeslots = count;
        return this;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    @StateChange
    public Competition withSimulationRate(long simulationRate) {
        this.simulationRate = simulationRate;
        return this;
    }

    public int getSimulationTimeslotSeconds() {
        return this.timeslotLength * 60 / (int)this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    public Competition withSimulationTimeslotSeconds(int seconds) {
        return this.withSimulationRate(this.timeslotLength * 60 / seconds);
    }

    public long getSimulationModulo() {
        return this.simulationModulo;
    }

    @ConfigurableValue(valueType="Long", description="Size, in milliseconds, of a simulation clock tick.Normally, this is the same as a timeslot.")
    @StateChange
    public Competition withSimulationModulo(long simulationModulo) {
        this.simulationModulo = simulationModulo;
        return this;
    }

    public Map<String, Long> getClockParameters() {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        result.put("base", this.getSimulationBaseTime().getMillis());
        result.put("rate", this.getSimulationRate());
        result.put("modulo", this.getSimulationModulo());
        return result;
    }

    public List<String> getBrokers() {
        return this.brokers;
    }

    @StateChange
    public Competition addBroker(String brokerUsername) {
        this.brokers.add(brokerUsername);
        return this;
    }

    public List<CustomerInfo> getCustomers() {
        return this.customers;
    }

    @StateChange
    public Competition addCustomer(CustomerInfo customer) {
        this.customers.add(customer);
        return this;
    }

    public void update(Competition template) {
        this.withBootstrapTimeslotCount(template.getBootstrapTimeslotCount());
        this.withDeactivateTimeslotsAhead(template.getDeactivateTimeslotsAhead());
        this.withSimulationBaseTime(template.getSimulationBaseTime());
        this.withBootstrapDiscardedTimeslots(template.getBootstrapDiscardedTimeslots());
        this.withSimulationModulo(template.getSimulationModulo());
        this.withTimeslotLength(template.getTimeslotLength());
        this.withTimeslotsOpen(template.getTimeslotsOpen());
    }

    public String toString() {
        return this.name;
    }
}

