/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.OrderbookOrder;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain
@XStreamAlias(value="orderbook")
public class Orderbook {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    private Instant dateExecuted;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private Double clearingPrice;
    @XStreamImplicit(itemFieldName="bid")
    private SortedSet<OrderbookOrder> bids = new TreeSet<OrderbookOrder>();
    @XStreamImplicit(itemFieldName="ask")
    private SortedSet<OrderbookOrder> asks = new TreeSet<OrderbookOrder>();
    private static TimeslotRepo timeslotRepo;

    public Orderbook(int timeslot, Double clearingPrice, Instant dateExecuted) {
        this.timeslot = timeslot;
        this.clearingPrice = clearingPrice;
        this.dateExecuted = dateExecuted;
    }

    @ChainedConstructor
    public Orderbook(Timeslot timeslot, Double clearingPrice, Instant dateExecuted) {
        this(timeslot.getSerialNumber(), clearingPrice, dateExecuted);
    }

    public long getId() {
        return this.id;
    }

    public Double getClearingPrice() {
        return this.clearingPrice;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return Orderbook.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public SortedSet<OrderbookOrder> getBids() {
        if (null == this.bids) {
            this.bids = new TreeSet<OrderbookOrder>();
        }
        return this.bids;
    }

    @StateChange
    public Orderbook addBid(OrderbookOrder bid) {
        this.bids.add(bid);
        return this;
    }

    public SortedSet<OrderbookOrder> getAsks() {
        if (null == this.asks) {
            this.asks = new TreeSet<OrderbookOrder>();
        }
        return this.asks;
    }

    @StateChange
    public Orderbook addAsk(OrderbookOrder ask) {
        this.asks.add(ask);
        return this;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

