/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.powertac.common.HourlyCharge;
import org.powertac.common.IdGenerator;
import org.powertac.common.RateCore;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TimeService;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain(fields={"tariffId", "weeklyBegin", "weeklyEnd", "dailyBegin", "dailyEnd", "tierThreshold", "fixed", "minValue", "maxValue", "noticeInterval", "expectedMean", "maxCurtailment"})
@XStreamAlias(value="rate")
public class Rate
extends RateCore {
    private static Logger log = LogManager.getLogger((String)Rate.class.getName());
    @XStreamAsAttribute
    private int weeklyBegin = -1;
    @XStreamAsAttribute
    private int weeklyEnd = -1;
    @XStreamAsAttribute
    private int dailyBegin = -1;
    @XStreamAsAttribute
    private int dailyEnd = -1;
    @XStreamAsAttribute
    private double tierThreshold = 0.0;
    @XStreamAsAttribute
    private boolean fixed = true;
    @XStreamAsAttribute
    private double minValue = 0.0;
    @XStreamAsAttribute
    private double maxValue = 0.0;
    @XStreamAsAttribute
    private long noticeInterval = 0L;
    @XStreamAsAttribute
    private double expectedMean = 0.0;
    @XStreamAsAttribute
    private double maxCurtailment = 0.0;
    private TreeSet<HourlyCharge> rateHistory = new TreeSet();
    @XStreamOmitField
    private ProbeCharge probe = new ProbeCharge(new Instant(0L), 0.0);
    @XStreamOmitField
    private TimeService timeService = null;

    public Rate withWeeklyBegin(AbstractDateTime begin) {
        if (begin != null) {
            return this.withWeeklyBegin(begin.getDayOfWeek());
        }
        return this;
    }

    public Rate withWeeklyBegin(ReadablePartial begin) {
        if (begin != null) {
            return this.withWeeklyBegin(begin.get(DateTimeFieldType.dayOfWeek()));
        }
        return this;
    }

    @StateChange
    public Rate withWeeklyBegin(int begin) {
        this.weeklyBegin = begin;
        return this;
    }

    public int getWeeklyBegin() {
        return this.weeklyBegin;
    }

    public Rate withWeeklyEnd(AbstractDateTime end) {
        if (end != null) {
            return this.withWeeklyEnd(end.getDayOfWeek());
        }
        return this;
    }

    public Rate withWeeklyEnd(ReadablePartial end) {
        if (end != null) {
            return this.withWeeklyEnd(end.get(DateTimeFieldType.dayOfWeek()));
        }
        return this;
    }

    @StateChange
    public Rate withWeeklyEnd(int end) {
        this.weeklyEnd = end;
        return this;
    }

    public int getWeeklyEnd() {
        return this.weeklyEnd;
    }

    public Rate withDailyBegin(AbstractDateTime begin) {
        if (begin != null) {
            return this.withDailyBegin(begin.getHourOfDay());
        }
        return this;
    }

    public Rate withDailyBegin(ReadablePartial begin) {
        if (begin != null) {
            return this.withDailyBegin(begin.get(DateTimeFieldType.hourOfDay()));
        }
        return this;
    }

    @StateChange
    public Rate withDailyBegin(int begin) {
        this.dailyBegin = begin;
        return this;
    }

    public int getDailyBegin() {
        return this.dailyBegin;
    }

    public Rate withDailyEnd(AbstractDateTime end) {
        if (end != null) {
            return this.withDailyEnd(end.getHourOfDay());
        }
        return this;
    }

    public Rate withDailyEnd(ReadablePartial end) {
        if (end != null) {
            return this.withDailyEnd(end.get(DateTimeFieldType.hourOfDay()));
        }
        return this;
    }

    @StateChange
    public Rate withDailyEnd(int end) {
        this.dailyEnd = end;
        return this;
    }

    public int getDailyEnd() {
        return this.dailyEnd;
    }

    public Rate withNoticeInterval(Duration interval) {
        return this.withNoticeInterval(interval.getMillis() / 3600000L);
    }

    @StateChange
    public Rate withNoticeInterval(long hours) {
        this.noticeInterval = hours;
        return this;
    }

    public long getNoticeInterval() {
        return this.noticeInterval;
    }

    public boolean addHourlyCharge(HourlyCharge newCharge) {
        return this.addHourlyCharge(newCharge, false);
    }

    @StateChange
    public boolean addHourlyCharge(HourlyCharge newCharge, boolean publish) {
        boolean result = false;
        if (this.fixed) {
            log.error("Cannot change Rate " + this.toString());
        } else {
            Instant now = this.getCurrentTime();
            double sgn = Math.signum(this.maxValue);
            long warning = newCharge.getAtTime().getMillis() - now.getMillis();
            if (warning < this.noticeInterval * 3600000L && !publish) {
                log.warn("Too late (" + now.toString() + ") to change rate for " + newCharge.getAtTime().toString());
            } else if (sgn * newCharge.getValue() > sgn * this.maxValue) {
                log.warn("Excess charge: " + newCharge.getValue() + " > " + this.maxValue);
            } else if (sgn * newCharge.getValue() < sgn * this.minValue) {
                log.warn("Charge too low: " + newCharge.getValue() + " < " + this.minValue);
            } else {
                HourlyCharge item;
                if (this.probe == null) {
                    this.probe = new ProbeCharge(new Instant(0L), 0.0);
                }
                this.probe.setAtTime(newCharge.getAtTime().plus(1000L));
                SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
                if (head != null && head.size() > 0 && (item = head.last()).getAtTime() == newCharge.getAtTime()) {
                    log.debug("remove " + item.toString());
                    this.rateHistory.remove(item);
                }
                newCharge.setRateId(this.getId());
                this.rateHistory.add(newCharge);
                log.info("Adding HourlyCharge " + newCharge.getId() + " at " + newCharge.getAtTime() + " to " + this.toString());
                result = true;
            }
        }
        return result;
    }

    public double getTierThreshold() {
        return this.tierThreshold;
    }

    @StateChange
    public Rate withTierThreshold(double tierThreshold) {
        this.tierThreshold = tierThreshold;
        return this;
    }

    public double getMinValue() {
        return this.minValue;
    }

    @StateChange
    public Rate withMinValue(double minValue) {
        this.minValue = minValue;
        return this;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @StateChange
    public Rate withMaxValue(double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public double getMaxCurtailment() {
        return this.maxCurtailment;
    }

    @StateChange
    public Rate withMaxCurtailment(double value) {
        this.maxCurtailment = Math.min(1.0, Math.max(0.0, value));
        return this;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    @StateChange
    public Rate withFixed(boolean fixed) {
        this.fixed = fixed;
        return this;
    }

    public boolean isTimeOfUse() {
        return this.dailyBegin >= 0 || this.weeklyBegin >= 0;
    }

    public double getExpectedMean() {
        return this.expectedMean;
    }

    @StateChange
    public Rate withExpectedMean(double value) {
        this.expectedMean = value;
        return this;
    }

    public TreeSet<HourlyCharge> getRateHistory() {
        return this.rateHistory;
    }

    public boolean applies() {
        return this.applies((AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(AbstractInstant when) {
        boolean appliesWeekly = false;
        boolean appliesDaily = false;
        DateTime time = new DateTime((Object)when, DateTimeZone.UTC);
        int day = time.getDayOfWeek();
        appliesWeekly = this.weeklyBegin == -1 ? true : (this.weeklyEnd == -1 ? day == this.weeklyBegin : (this.weeklyEnd >= this.weeklyBegin ? day >= this.weeklyBegin && day <= this.weeklyEnd : day >= this.weeklyBegin || day <= this.weeklyEnd));
        int hour = time.getHourOfDay();
        appliesDaily = this.dailyBegin == -1 || this.dailyEnd == -1 ? true : (this.dailyEnd > this.dailyBegin ? hour >= this.dailyBegin && hour < this.dailyEnd : hour >= this.dailyBegin || hour < this.dailyEnd);
        return appliesWeekly && appliesDaily;
    }

    public boolean applies(double usage) {
        return this.applies(usage, (AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(double usage, AbstractInstant when) {
        if (usage >= this.tierThreshold) {
            return this.applies(when);
        }
        return false;
    }

    @StateChange
    public Rate withValue(double value) {
        this.minValue = value;
        return this;
    }

    public double getValue() {
        return this.getValue((AbstractInstant)this.getCurrentTime(), null);
    }

    public double getValue(AbstractInstant when) {
        return this.getValue(when, null);
    }

    public double getValue(AbstractInstant when, TariffEvaluationHelper helper) {
        if (this.fixed) {
            return this.minValue;
        }
        if (null != helper) {
            return helper.getWeightedValue(this);
        }
        if (this.rateHistory.size() == 0) {
            log.debug("no rate history, return default");
            return this.expectedMean;
        }
        if (this.probe == null) {
            this.probe = new ProbeCharge(new Instant(0L), 0.0);
        }
        Instant inst = new Instant((Object)when);
        this.probe.setAtTime(inst.plus(1000L));
        SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
        if (head == null || head.size() == 0) {
            log.debug("No hourly charge found for " + when.getMillis() + ", returning default");
            return this.expectedMean;
        }
        HourlyCharge candidate = head.last();
        if (candidate.getAtTime().getMillis() == inst.getMillis()) {
            return candidate.getValue();
        }
        return this.expectedMean;
    }

    public boolean isValid(TariffSpecification spec) {
        double sgn;
        if (Double.isNaN(this.minValue) || Double.isNaN(this.maxValue) || Double.isNaN(this.expectedMean)) {
            log.warn("numeric insanity: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")");
            return false;
        }
        if (Double.isInfinite(this.minValue) || Double.isInfinite(this.maxValue) || Double.isInfinite(this.expectedMean)) {
            log.warn("Infinite value: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")");
            return false;
        }
        if (Double.isNaN(this.maxCurtailment) || this.maxCurtailment < 0.0 || this.maxCurtailment > 1.0) {
            log.warn("Curtailment ratio " + this.maxCurtailment + " out of range");
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || spec.getPowerType().isConsumption() && this.tierThreshold < 0.0) {
            log.warn("Negative tier threshold for consumption rate");
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || spec.getPowerType().isProduction() && this.tierThreshold > 0.0) {
            log.warn("Positive tier threshold for production rate");
            return false;
        }
        if (this.isFixed()) {
            return true;
        }
        double d = sgn = spec.getPowerType().isConsumption() ? -1.0 : 1.0;
        if (sgn * this.maxValue < sgn * this.minValue) {
            log.warn("maxValue " + this.maxValue + " out of range");
            return false;
        }
        if (sgn * this.expectedMean < sgn * this.minValue || sgn * this.expectedMean > sgn * this.maxValue) {
            log.warn("expectedMean " + this.expectedMean + " out of range");
            return false;
        }
        if (this.noticeInterval < 0L) {
            log.warn("negative notice interval " + this.noticeInterval);
            return false;
        }
        return true;
    }

    public String toString() {
        String result = "Rate." + IdGenerator.getString(this.getId()) + ":";
        result = this.fixed ? result + " Fixed " + this.getMinValue() : result + " Variable";
        if (this.weeklyBegin >= 0) {
            result = result + ", " + (this.weeklyEnd >= 0 ? "starts " : "") + "day" + this.weeklyBegin;
            if (this.weeklyEnd >= 0) {
                result = result + " ends day " + this.weeklyEnd;
            }
        }
        if (this.dailyBegin >= 0) {
            result = result + ", " + this.dailyBegin + ":00 -- " + this.dailyEnd + ":00";
        }
        if (this.tierThreshold > 0.0) {
            result = result + ", usage > " + this.tierThreshold;
        }
        return result;
    }

    private Instant getCurrentTime() {
        if (this.timeService == null) {
            this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        }
        return this.timeService.getCurrentTime();
    }

    void setTimeService(TimeService service) {
        this.timeService = service;
    }

    class ProbeCharge
    extends HourlyCharge {
        public ProbeCharge(Instant when, double charge) {
            super(when, charge);
        }

        void setAtTime(Instant when) {
            this.atTime = when;
        }
    }
}

