/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;

@Domain
@XStreamAlias(value="weather-report")
public class WeatherReport {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private int currentTimeslot;
    @XStreamAsAttribute
    private double temperature;
    @XStreamAsAttribute
    private double windSpeed;
    @XStreamAsAttribute
    private double windDirection;
    @XStreamAsAttribute
    private double cloudCover;
    private static TimeslotRepo timeslotRepo;

    public WeatherReport(int timeslot, double temperature, double windSpeed, double windDirection, double cloudCover) {
        this.currentTimeslot = timeslot;
        this.temperature = temperature;
        this.windSpeed = windSpeed;
        this.windDirection = windDirection;
        this.cloudCover = cloudCover;
    }

    @Deprecated
    @ChainedConstructor
    public WeatherReport(Timeslot timeslot, double temperature, double windSpeed, double windDirection, double cloudCover) {
        this(timeslot.getSerialNumber(), temperature, windSpeed, windDirection, cloudCover);
    }

    public long getId() {
        return this.id;
    }

    public int getTimeslotIndex() {
        return this.currentTimeslot;
    }

    @Deprecated
    public Timeslot getCurrentTimeslot() {
        return WeatherReport.getTimeslotRepo().findBySerialNumber(this.currentTimeslot);
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getWindSpeed() {
        return this.windSpeed;
    }

    public double getWindDirection() {
        return this.windDirection;
    }

    public double getCloudCover() {
        return this.cloudCover;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

