/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.TariffMessage;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain
@XStreamAlias(value="tariff-status")
public class TariffStatus
extends TariffMessage {
    @XStreamAsAttribute
    private long tariffId;
    @XStreamAsAttribute
    private long updateId;
    private String message;
    @XStreamAsAttribute
    private Status status = Status.success;

    public TariffStatus(Broker broker, long tariffId, long updateId, Status status) {
        super(broker);
        this.tariffId = tariffId;
        this.updateId = updateId;
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    @StateChange
    public TariffStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    public long getTariffId() {
        return this.tariffId;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        success,
        noSuchTariff,
        noSuchUpdate,
        illegalOperation,
        invalidTariff,
        invalidUpdate,
        duplicateId;

    }
}

