/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.HashMap;
import org.powertac.common.IdGenerator;
import org.powertac.common.MarketPosition;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain
public class Broker {
    private long id = IdGenerator.createId();
    private String username;
    private String password;
    private String key;
    private String queueName = null;
    private boolean enabled;
    private boolean local = false;
    private int idPrefix = 0;
    private boolean wholesale = false;
    private double cash = 0.0;
    private HashMap<Integer, MarketPosition> mktPositions;

    public Broker(String username) {
        this.username = username;
        this.mktPositions = new HashMap();
    }

    public Broker(String username, boolean local, boolean wholesale) {
        this.username = username;
        this.mktPositions = new HashMap();
        this.local = local;
        this.wholesale = wholesale;
    }

    public long getId() {
        return this.id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setIdPrefix(int prefix) {
        this.idPrefix = prefix;
    }

    public int getIdPrefix() {
        return this.idPrefix;
    }

    public void updateCash(double depositAmount) {
        this.cash += depositAmount;
    }

    public double getCashBalance() {
        return this.cash;
    }

    @StateChange
    public Broker addMarketPosition(MarketPosition posn, int slot) {
        this.mktPositions.put(slot, posn);
        return this;
    }

    @Deprecated
    public Broker addMarketPosition(MarketPosition posn, Timeslot slot) {
        return this.addMarketPosition(posn, slot.getSerialNumber());
    }

    public MarketPosition findMarketPositionByTimeslot(int slot) {
        MarketPosition posn = this.mktPositions.get(slot);
        if (null == posn) {
            posn = new MarketPosition(this, slot, 0.0);
            this.mktPositions.put(slot, posn);
        }
        return posn;
    }

    @Deprecated
    public MarketPosition findMarketPositionByTimeslot(Timeslot slot) {
        return this.findMarketPositionByTimeslot(slot.getSerialNumber());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public boolean isEnabled() {
        return this.enabled || this.isLocal() && this.isWholesale();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocal() {
        return this.local;
    }

    @StateChange
    public void setLocal(boolean value) {
        this.local = value;
    }

    public boolean isWholesale() {
        return this.wholesale;
    }

    @StateChange
    public void setWholesale(boolean value) {
        this.wholesale = value;
    }

    public String toString() {
        return this.username;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String toQueueName() {
        if (null != this.queueName) {
            return this.queueName;
        }
        return this.getUsername();
    }

    public void receiveMessage(Object object) {
    }
}

