/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;

@Domain
@XStreamAlias(value="trade")
public class ClearedTrade {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private double executionPrice;
    @XStreamAsAttribute
    private double executionMWh;
    @XStreamAsAttribute
    private Instant dateExecuted;
    private static TimeslotRepo timeslotRepo;

    public ClearedTrade(int timeslot, double executionMWh, double executionPrice, Instant dateExecuted) {
        this.timeslot = timeslot;
        this.executionPrice = executionPrice;
        this.executionMWh = executionMWh;
        this.dateExecuted = dateExecuted;
    }

    @ChainedConstructor
    public ClearedTrade(Timeslot timeslot, double executionMWh, double executionPrice, Instant dateExecuted) {
        this(timeslot.getSerialNumber(), executionMWh, executionPrice, dateExecuted);
    }

    public long getId() {
        return this.id;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return ClearedTrade.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public double getExecutionPrice() {
        return this.executionPrice;
    }

    public double getExecutionMWh() {
        return this.executionMWh;
    }

    public Instant getDateExecuted() {
        return this.dateExecuted;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }

    public String toString() {
        return "ClearedTrade " + this.executionMWh + "@" + this.executionPrice;
    }
}

