/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.IdGenerator;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain
@XStreamAlias(value="cust-info")
public class CustomerInfo {
    private static Logger log = LogManager.getLogger((String)CustomerInfo.class.getName());
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private int population;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private CustomerClass customerClass = CustomerClass.SMALL;
    @XStreamAsAttribute
    private double controllableKW = 0.0;
    @XStreamAsAttribute
    private double upRegulationKW = 0.0;
    @XStreamAsAttribute
    private double downRegulationKW = 0.0;
    @XStreamAsAttribute
    private double storageCapacity = 0.0;
    @XStreamAsAttribute
    private boolean multiContracting = false;
    @XStreamAsAttribute
    private boolean canNegotiate = false;

    public CustomerInfo(String name, int population) {
        this.powerType = PowerType.CONSUMPTION;
        this.name = name;
        this.population = population;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPopulation() {
        return this.population;
    }

    @StateChange
    public void setPopulation(Integer population) {
        this.population = population;
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    @StateChange
    public CustomerInfo withPowerType(PowerType type) {
        this.powerType = type;
        return this;
    }

    public CustomerClass getCustomerClass() {
        return this.customerClass;
    }

    public CustomerInfo withCustomerClass(CustomerClass cClass) {
        this.customerClass = cClass;
        return this;
    }

    public boolean isMultiContracting() {
        return this.multiContracting;
    }

    @StateChange
    public CustomerInfo withMultiContracting(boolean value) {
        this.multiContracting = value;
        return this;
    }

    public boolean isCanNegotiate() {
        return this.canNegotiate;
    }

    @StateChange
    public CustomerInfo withCanNegotiate(boolean value) {
        this.canNegotiate = value;
        return this;
    }

    public double getControllableKW() {
        return this.controllableKW;
    }

    @Deprecated
    public double getControllableKWh() {
        return this.controllableKW;
    }

    @StateChange
    public CustomerInfo withControllableKW(double value) {
        if (value > 0.0) {
            log.error(this.getName() + ": controllableKW " + value + " must be non-positive");
        } else {
            this.controllableKW = value;
        }
        return this;
    }

    public double getUpRegulationKW() {
        return this.upRegulationKW;
    }

    @StateChange
    public CustomerInfo withUpRegulationKW(double value) {
        if (value > 0.0) {
            log.error(this.getName() + ": upRegulationKW " + value + " must be non-positive");
        } else {
            this.upRegulationKW = value;
        }
        return this;
    }

    public double getDownRegulationKW() {
        return this.downRegulationKW;
    }

    @StateChange
    public CustomerInfo withDownRegulationKW(double value) {
        if (value < 0.0) {
            log.error(this.getName() + ": downRegulationKW " + value + " must be non-negative");
        } else {
            this.downRegulationKW = value;
        }
        return this;
    }

    public double getStorageCapacity() {
        return this.storageCapacity;
    }

    @StateChange
    public CustomerInfo withStorageCapacity(double value) {
        if (value < 0.0) {
            log.error(this.getName() + ": storageCapacity " + value + " must be non-negative");
        } else {
            this.storageCapacity = value;
        }
        return this;
    }

    public String toString() {
        return "CustomerInfo(" + this.name + ")";
    }

    public static enum CustomerClass {
        SMALL,
        LARGE;

    }
}

