/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;

@Domain(fields={"postedTimeslot", "NSmall", "NLarge", "KWh", "charge"})
@XStreamAlias(value="distribution-tx")
public class DistributionTransaction
extends BrokerTransaction {
    @XStreamAsAttribute
    private double kWh = 0.0;
    @XStreamAsAttribute
    private int nSmall = 0;
    @XStreamAsAttribute
    private int nLarge = 0;
    @XStreamAsAttribute
    private double charge = 0.0;

    @ChainedConstructor
    public DistributionTransaction(Broker broker, int when, double kwh, double charge) {
        this(broker, when, 0, 0, kwh, charge);
    }

    public DistributionTransaction(Broker broker, int when, int nSmall, int nLarge, double kwh, double charge) {
        super(when, broker);
        this.nSmall = nSmall;
        this.nLarge = nLarge;
        this.kWh = kwh;
        this.charge = charge;
    }

    @Deprecated
    public double getQuantity() {
        return this.kWh;
    }

    public double getKWh() {
        return this.kWh;
    }

    public int getNSmall() {
        return this.nSmall;
    }

    public int getNLarge() {
        return this.nLarge;
    }

    public double getCharge() {
        return this.charge;
    }

    public String toString() {
        return String.format("Distribution tx %d-%s-%d-%d-%.3f-%.3f", this.postedTimeslot, this.broker.getUsername(), this.nSmall, this.nLarge, this.kWh, this.charge);
    }
}

