/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.powertac.common.Broker;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.xml.BrokerConverter;

@Domain
@XStreamAlias(value="market-posn")
public class MarketPosition {
    @XStreamAsAttribute
    protected long id = IdGenerator.createId();
    @XStreamConverter(value=BrokerConverter.class)
    private Broker broker;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAlias(value="bal")
    @XStreamAsAttribute
    double overallBalance = 0.0;
    private static TimeslotRepo timeslotRepo;

    public MarketPosition(Broker broker, int timeslot, double balance) {
        this.broker = broker;
        this.timeslot = timeslot;
        this.overallBalance = balance;
    }

    @ChainedConstructor
    public MarketPosition(Broker broker, Timeslot timeslot, double balance) {
        this(broker, timeslot.getSerialNumber(), balance);
    }

    public long getId() {
        return this.id;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return MarketPosition.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public double getOverallBalance() {
        return this.overallBalance;
    }

    public String toString() {
        return "MktPosn-" + this.broker.getId() + "-" + this.timeslot + "-" + this.overallBalance;
    }

    @StateChange
    public double updateBalance(double mWh) {
        this.overallBalance += mWh;
        return this.overallBalance;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

