/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;

@Domain(fields={"postedTimeslot", "timeslot", "MWh", "price"})
@XStreamAlias(value="market-tx")
public class MarketTransaction
extends BrokerTransaction {
    @XStreamAsAttribute
    private double price;
    @XStreamAsAttribute
    private double mWh;
    @XStreamAsAttribute
    private int timeslot;
    private static TimeslotRepo timeslotRepo;

    public MarketTransaction(Broker broker, int when, int timeslot, double mWh, double price) {
        super(when, broker);
        this.timeslot = timeslot;
        this.price = price;
        this.mWh = mWh;
    }

    @ChainedConstructor
    public MarketTransaction(Broker broker, int when, Timeslot timeslot, double mWh, double price) {
        this(broker, when, timeslot.getSerialNumber(), mWh, price);
    }

    public double getPrice() {
        return this.price;
    }

    public double getMWh() {
        return this.mWh;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return MarketTransaction.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public String toString() {
        return "MktTx: time " + this.timeslot + ", " + this.mWh + "@" + this.price;
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

