/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.XStreamStateLoggable;
import org.powertac.common.xml.BrokerConverter;

@Domain(fields={"broker", "timeslot", "MWh", "limitPrice"})
@XStreamAlias(value="order")
public class Order
extends XStreamStateLoggable {
    private static Logger log = LogManager.getLogger(Order.class);
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamConverter(value=BrokerConverter.class)
    private Broker broker;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private double mWh;
    @XStreamAsAttribute
    private Double limitPrice = null;
    private static TimeslotRepo timeslotRepo;

    public Order(Broker broker, int timeslot, double mWh, Double limitPrice) {
        this.broker = broker;
        this.timeslot = timeslot;
        this.mWh = mWh;
        this.limitPrice = limitPrice;
        double min = Competition.currentCompetition().getMinimumOrderQuantity();
        if (Math.abs(mWh) < min) {
            log.warn("Order quantity " + mWh + " < minimum order quantity " + min);
        }
    }

    @Deprecated
    @ChainedConstructor
    public Order(Broker broker, Timeslot timeslot, double mWh, Double limitPrice) {
        this(broker, timeslot.getSerialNumber(), mWh, limitPrice);
    }

    public long getId() {
        return this.id;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return Order.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public Double getMWh() {
        return this.mWh;
    }

    public Double getLimitPrice() {
        return this.limitPrice;
    }

    public String toString() {
        return "Order " + this.id + " from " + this.broker.getUsername() + " for " + this.mWh + " mwh at " + this.limitPrice + " in ts " + this.timeslot;
    }

    protected Order() {
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (null == timeslotRepo) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

