/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;

@Domain
@XStreamAlias(value="orderbook-bid")
public class OrderbookOrder
implements Comparable<Object> {
    @XStreamOmitField
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private Double limitPrice;
    @XStreamAsAttribute
    private double mWh;

    public OrderbookOrder(double mWh, Double limitPrice) {
        this.limitPrice = limitPrice;
        this.mWh = mWh;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof OrderbookOrder)) {
            return 1;
        }
        OrderbookOrder other = (OrderbookOrder)o;
        if (this.limitPrice == null) {
            if (other.limitPrice == null) {
                return 0;
            }
            return -1;
        }
        if (other.limitPrice == null) {
            return 1;
        }
        return this.limitPrice == other.limitPrice ? 0 : (this.limitPrice < other.limitPrice ? -1 : 1);
    }

    public Double getLimitPrice() {
        return this.limitPrice;
    }

    public double getMWh() {
        return this.mWh;
    }

    public String toString() {
        return "OrderbookOrder: " + this.mWh + "@" + this.limitPrice;
    }
}

