/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Rate;
import org.powertac.common.RateCore;
import org.powertac.common.RegulationRate;
import org.powertac.common.TariffMessage;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;

@Domain(fields={"broker", "powerType", "minDuration", "signupPayment", "earlyWithdrawPayment", "periodicPayment", "supersedes"})
@XStreamAlias(value="tariff-spec")
public class TariffSpecification
extends TariffMessage {
    private static Logger log = LogManager.getLogger(TariffSpecification.class);
    private Instant expiration = null;
    @XStreamAsAttribute
    private long minDuration = 0L;
    @XStreamAsAttribute
    private PowerType powerType = PowerType.CONSUMPTION;
    @XStreamAsAttribute
    private double signupPayment = 0.0;
    @XStreamAsAttribute
    private double earlyWithdrawPayment = 0.0;
    @XStreamAsAttribute
    private double periodicPayment = 0.0;
    private List<RateCore> rates;
    private List<Long> supersedes;

    public TariffSpecification(Broker broker, PowerType powerType) {
        super(broker);
        this.broker = broker;
        this.powerType = powerType;
        this.rates = new ArrayList<RateCore>();
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    @StateChange
    public TariffSpecification withExpiration(Instant expiration) {
        this.expiration = expiration;
        return this;
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    @StateChange
    public TariffSpecification withMinDuration(long minDuration) {
        this.minDuration = minDuration;
        return this;
    }

    public double getSignupPayment() {
        return this.signupPayment;
    }

    @StateChange
    public TariffSpecification withSignupPayment(double signupPayment) {
        this.signupPayment = signupPayment;
        return this;
    }

    public double getEarlyWithdrawPayment() {
        return this.earlyWithdrawPayment;
    }

    @StateChange
    public TariffSpecification withEarlyWithdrawPayment(double earlyWithdrawPayment) {
        this.earlyWithdrawPayment = earlyWithdrawPayment;
        return this;
    }

    public double getPeriodicPayment() {
        return this.periodicPayment;
    }

    @StateChange
    public TariffSpecification withPeriodicPayment(double periodicPayment) {
        this.periodicPayment = periodicPayment;
        return this;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Broker getBroker() {
        return this.broker;
    }

    public List<Rate> getRates() {
        ArrayList<Rate> result = new ArrayList<Rate>();
        for (RateCore rate : this.rates) {
            if (!(rate instanceof Rate)) continue;
            result.add((Rate)rate);
        }
        return result;
    }

    public List<RegulationRate> getRegulationRates() {
        ArrayList<RegulationRate> result = new ArrayList<RegulationRate>();
        for (RateCore rate : this.rates) {
            if (!(rate instanceof RegulationRate)) continue;
            result.add((RegulationRate)rate);
        }
        return result;
    }

    public boolean hasRegulationRate() {
        for (RateCore rate : this.rates) {
            if (!(rate instanceof RegulationRate)) continue;
            return true;
        }
        return false;
    }

    @StateChange
    public TariffSpecification addRate(RateCore rate) {
        if (null == this.rates) {
            this.rates = new ArrayList<RateCore>();
        }
        this.rates.add(rate);
        rate.setTariffId(this.id);
        return this;
    }

    public List<Long> getSupersedes() {
        return this.supersedes;
    }

    @StateChange
    public TariffSpecification addSupersedes(long specId) {
        if (this.supersedes == null) {
            this.supersedes = new ArrayList<Long>();
        }
        this.supersedes.add(specId);
        return this;
    }

    @Override
    public boolean isValid() {
        if (this.getRates().size() == 0) {
            log.warn("invalid: no rates");
            return false;
        }
        for (Rate rate : this.getRates()) {
            if (rate.isValid(this)) continue;
            log.warn("invalid rate");
            return false;
        }
        if (this.minDuration < 0L) {
            log.warn("invalid: negative minDuration");
            return false;
        }
        return true;
    }

    public String toString() {
        return "TariffSpecification " + this.getId() + " " + this.getBroker().getUsername() + "." + this.getPowerType();
    }

    protected TariffSpecification() {
    }
}

