/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.powertac.common.Broker;
import org.powertac.common.BrokerTransaction;
import org.powertac.common.CustomerInfo;
import org.powertac.common.TariffSpecification;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.xml.CustomerConverter;
import org.powertac.common.xml.TariffSpecificationConverter;

@Domain(fields={"postedTimeslot", "txType", "customerInfo", "customerCount", "KWh", "charge", "regulation"})
@XStreamAlias(value="tariff-tx")
public class TariffTransaction
extends BrokerTransaction {
    @XStreamAsAttribute
    private Type txType = Type.CONSUME;
    @XStreamConverter(value=CustomerConverter.class)
    private CustomerInfo customerInfo;
    @XStreamAsAttribute
    private int customerCount = 0;
    @XStreamAsAttribute
    private double kWh = 0.0;
    @XStreamAsAttribute
    private double charge = 0.0;
    @XStreamAsAttribute
    private boolean regulation = false;
    @XStreamConverter(value=TariffSpecificationConverter.class)
    private TariffSpecification tariffSpec;

    @ChainedConstructor
    @Deprecated
    public TariffTransaction(Broker broker, int when, Type txType, TariffSpecification spec, CustomerInfo customer, int customerCount, double kWh, double charge) {
        this(broker, when, txType, spec, customer, customerCount, kWh, charge, false);
    }

    public TariffTransaction(Broker broker, int when, Type txType, TariffSpecification spec, CustomerInfo customer, int customerCount, double kWh, double charge, boolean regulation) {
        super(when, broker);
        this.txType = txType;
        this.tariffSpec = spec;
        this.customerInfo = customer;
        this.customerCount = customerCount;
        this.kWh = kWh;
        this.charge = charge;
        this.regulation = regulation;
    }

    public Type getTxType() {
        return this.txType;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    public int getCustomerCount() {
        return this.customerCount;
    }

    public double getKWh() {
        return this.kWh;
    }

    public double getCharge() {
        return this.charge;
    }

    public boolean isRegulation() {
        return this.regulation;
    }

    public TariffSpecification getTariffSpec() {
        return this.tariffSpec;
    }

    public String toString() {
        String customer = "?";
        if (this.customerInfo != null) {
            customer = this.customerInfo.getName();
        }
        return "TariffTx: customer" + customer + " at " + this.postedTimeslot + ", " + (Object)((Object)this.txType) + ": " + this.kWh + "@" + this.charge;
    }

    public static enum Type {
        PUBLISH,
        PRODUCE,
        CONSUME,
        PERIODIC,
        SIGNUP,
        WITHDRAW,
        REVOKE,
        REFUND;

    }
}

