/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.TariffSpecification;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.state.Domain;

@Domain(fields={"exerciseRatio", "price", "tariffId", "broker"})
@XStreamAlias(value="balancing-order")
public class BalancingOrder
extends TariffUpdate {
    @XStreamAsAttribute
    private double exerciseRatio = 0.0;
    @XStreamAsAttribute
    private double price = 0.0;

    public BalancingOrder(Broker broker, TariffSpecification tariff, double exerciseRatio, double price) {
        super(broker, tariff);
        this.exerciseRatio = exerciseRatio;
        this.price = price;
    }

    public double getExerciseRatio() {
        return this.exerciseRatio;
    }

    public double getPrice() {
        return this.price;
    }

    @Override
    public boolean isValid() {
        return !(this.exerciseRatio < -1.0) && !(this.exerciseRatio > 2.0);
    }

    protected BalancingOrder() {
    }
}

