/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.TariffSpecification;
import org.powertac.common.msg.ControlEvent;
import org.powertac.common.state.Domain;

@Domain(fields={"tariffId", "curtailmentRatio", "timeslotIndex"})
@XStreamAlias(value="economic-control")
public class EconomicControlEvent
extends ControlEvent {
    private static Logger log = LogManager.getLogger((String)EconomicControlEvent.class.getName());
    @XStreamAsAttribute
    private double curtailmentRatio = 0.0;

    public EconomicControlEvent(TariffSpecification tariff, double curtailmentRatio, int timeslotIndex) {
        super(tariff.getBroker(), tariff, timeslotIndex);
        if (tariff.hasRegulationRate()) {
            if (-1.0 > curtailmentRatio || 2.0 < curtailmentRatio) {
                log.error("Illegal curtailmentRatio: " + curtailmentRatio);
                curtailmentRatio = 0.0;
            }
        } else if (0.0 > curtailmentRatio || 1.0 < curtailmentRatio) {
            log.error("Illegal curtailmentRatio: " + curtailmentRatio);
            curtailmentRatio = 0.0;
        }
        this.curtailmentRatio = curtailmentRatio;
    }

    public double getCurtailmentRatio() {
        return this.curtailmentRatio;
    }

    protected EconomicControlEvent() {
    }
}

