/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.joda.time.Instant;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;

@Domain
@XStreamAlias(value="timeslot-update")
public class TimeslotUpdate {
    @XStreamAsAttribute
    private long id = IdGenerator.createId();
    @XStreamAsAttribute
    private int firstEnabled;
    @XStreamAsAttribute
    private int lastEnabled;
    @XStreamAsAttribute
    private Instant postedTime;

    public TimeslotUpdate(Instant postedTime, int firstEnabled, int lastEnabled) {
        this.postedTime = postedTime;
        this.firstEnabled = firstEnabled;
        this.lastEnabled = lastEnabled;
    }

    public long getId() {
        return this.id;
    }

    public Instant getPostedTime() {
        return this.postedTime;
    }

    public int getFirstEnabled() {
        return this.firstEnabled;
    }

    public int getLastEnabled() {
        return this.lastEnabled;
    }

    public int size() {
        return this.lastEnabled - this.firstEnabled + 1;
    }
}

