/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.powertac.common.Broker;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.msg.TariffUpdate;
import org.powertac.common.state.Domain;

@Domain(fields={"broker", "tariffId", "payload", "rateId"})
@XStreamAlias(value="tariff-vru")
public class VariableRateUpdate
extends TariffUpdate {
    private HourlyCharge payload;
    @XStreamAsAttribute
    private long rateId;

    public VariableRateUpdate(Broker broker, Rate rate, HourlyCharge hourlyCharge) {
        super(broker, rate.getTariffId());
        this.rateId = rate.getId();
        this.payload = hourlyCharge;
    }

    public HourlyCharge getHourlyCharge() {
        return this.payload;
    }

    public HourlyCharge getPayload() {
        return this.payload;
    }

    public long getHourlyChargeId() {
        return this.payload.getId();
    }

    public long getRateId() {
        return this.rateId;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public boolean isValid(Rate rate) {
        if (rate.getId() != this.rateId) {
            return false;
        }
        if (rate.isFixed()) {
            return false;
        }
        double value = this.payload.getValue();
        if (0.0 == rate.getMinValue() && 0.0 == rate.getMaxValue()) {
            return 0.0 == value;
        }
        double sgn = 1.0;
        if (rate.getMaxValue() < 0.0) {
            sgn = -1.0;
        }
        return !(sgn * value < sgn * rate.getMinValue()) && !(sgn * value > sgn * rate.getMaxValue());
    }

    protected VariableRateUpdate() {
    }
}

