/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;

public class DoubleArrayConverter
implements SingleValueConverter {
    public boolean canConvert(Class type) {
        return double[].class.isAssignableFrom(type);
    }

    public Object fromString(String xml) {
        String[] values = xml.split(",");
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Double.parseDouble(values[i]);
        }
        return result;
    }

    public String toString(Object input) {
        StringBuffer buf = new StringBuffer();
        double[] values = (double[])input;
        String delim = "";
        for (double datum : values) {
            buf.append(delim).append(datum);
            delim = ",";
        }
        return buf.toString();
    }
}

