/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.XStreamStateLoggable;
import org.powertac.common.xml.BrokerConverter;

public abstract class BrokerTransaction
extends XStreamStateLoggable {
    @XStreamAsAttribute
    protected long id = IdGenerator.createId();
    @XStreamConverter(value=BrokerConverter.class)
    protected Broker broker;
    @XStreamAsAttribute
    protected int postedTimeslot;
    private static TimeslotRepo timeslotRepo = null;

    public BrokerTransaction(int timeslotIndex, Broker broker) {
        this.broker = broker;
        this.postedTimeslot = timeslotIndex;
    }

    public long getId() {
        return this.id;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public Instant getPostedTime() {
        return BrokerTransaction.getTimeslotRepo().getTimeForIndex(this.postedTimeslot);
    }

    public int getPostedTimeslotIndex() {
        return this.postedTimeslot;
    }

    public Timeslot getPostedTimeslot() {
        return BrokerTransaction.getTimeslotRepo().findBySerialNumber(this.postedTimeslot);
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (timeslotRepo == null) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }
}

