/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.FullCustomerConverter;

@Domain
@XStreamAlias(value="competition")
public class Competition {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    private String description;
    @XStreamAsAttribute
    private String pomId;
    @XStreamAsAttribute
    private int timeslotLength;
    @XStreamAsAttribute
    private int bootstrapTimeslotCount;
    @XStreamAsAttribute
    private int bootstrapDiscardedTimeslots;
    @XStreamOmitField
    private int minimumTimeslotCount;
    @XStreamOmitField
    private int expectedTimeslotCount;
    @XStreamAsAttribute
    private int timeslotsOpen;
    @XStreamAsAttribute
    private int deactivateTimeslotsAhead;
    @XStreamAsAttribute
    private double minimumOrderQuantity;
    @XStreamAsAttribute
    private Instant simulationBaseTime;
    @XStreamAsAttribute
    private int timezoneOffset;
    @XStreamAsAttribute
    private int latitude;
    @XStreamAsAttribute
    private long simulationRate;
    @XStreamAsAttribute
    private long simulationModulo;
    @XStreamImplicit(itemFieldName="broker")
    private ArrayList<String> brokers;
    @XStreamImplicit(itemFieldName="customer")
    @XStreamConverter(value=FullCustomerConverter.class)
    private ArrayList<CustomerInfo> customers;
    private static Competition theCompetition;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    public static Competition newInstance(String name) {
        Competition result = new Competition(name);
        return result;
    }

    public static Competition currentCompetition() {
        return theCompetition;
    }

    public static void setCurrent(Competition newCurrent) {
        theCompetition = newCurrent;
    }

    private Competition(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        this.id = IdGenerator.createId();
        this.name = "default";
        this.description = "";
        this.pomId = "unknown";
        this.timeslotLength = 60;
        this.bootstrapTimeslotCount = 336;
        this.bootstrapDiscardedTimeslots = 24;
        this.minimumTimeslotCount = 480;
        this.expectedTimeslotCount = 600;
        this.timeslotsOpen = 24;
        this.deactivateTimeslotsAhead = 1;
        this.minimumOrderQuantity = 0.01;
        this.simulationBaseTime = new DateTime(2010, 6, 21, 0, 0, 0, 0, DateTimeZone.UTC).toInstant();
        this.timezoneOffset = 0;
        this.latitude = 45;
        this.simulationRate = 720L;
        this.simulationModulo = 3600000L;
        this.name = name;
        this.brokers = new ArrayList();
        this.customers = new ArrayList();
        theCompetition = this;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @ConfigurableValue(description="user-readable description of the Competition", valueType="String")
    @StateChange
    public Competition withDescription(String description) {
        String string = description;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        this.description = description;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public String getPomId() {
        return this.pomId;
    }

    @ConfigurableValue(description="maven version identifier from server", valueType="String")
    @StateChange
    public Competition withPomId(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        this.pomId = id;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotLength() {
        return this.timeslotLength;
    }

    public long getTimeslotDuration() {
        return (long)this.timeslotLength * 60000L;
    }

    @ConfigurableValue(name="timeslotLength", description="length of timeslot in minutes sim time", valueType="Integer")
    @StateChange
    public Competition withTimeslotLength(int timeslotLength) {
        int n = timeslotLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timeslotLength = timeslotLength;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getMinimumTimeslotCount() {
        return this.minimumTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="minimum number of timeslots in simulation run")
    @StateChange
    public Competition withMinimumTimeslotCount(int minimumTimeslotCount) {
        int n = minimumTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.minimumTimeslotCount = minimumTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getExpectedTimeslotCount() {
        return this.expectedTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withExpectedTimeslotCount(int expectedTimeslotCount) {
        int n = expectedTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.expectedTimeslotCount = expectedTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotsOpen() {
        return this.timeslotsOpen;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withTimeslotsOpen(int timeslotsOpen) {
        int n = timeslotsOpen;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timeslotsOpen = timeslotsOpen;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getDeactivateTimeslotsAhead() {
        return this.deactivateTimeslotsAhead;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withDeactivateTimeslotsAhead(int deactivateTimeslotsAhead) {
        int n = deactivateTimeslotsAhead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.deactivateTimeslotsAhead = deactivateTimeslotsAhead;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public double getMinimumOrderQuantity() {
        return this.minimumOrderQuantity;
    }

    @ConfigurableValue(valueType="Double", description="Minimum order quantity in MWh")
    @StateChange
    public Competition withMinimumOrderQuantity(double minOrderQty) {
        double d = minOrderQty;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.minimumOrderQuantity = minOrderQty;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Instant getSimulationBaseTime() {
        return this.simulationBaseTime;
    }

    public Competition withSimulationBaseTime(Instant simulationBaseTime) {
        return this.withSimulationBaseTime(simulationBaseTime.getMillis());
    }

    @ConfigurableValue(valueType="String", description="Scenario start time of the bootstrap portion of a simulation")
    public Competition withSimulationBaseTime(String baseTime) {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        return this.withSimulationBaseTime(fmt.parseDateTime(baseTime).toInstant());
    }

    @StateChange
    public Competition withSimulationBaseTime(long baseTime) {
        long l = baseTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationBaseTime = new Instant(baseTime);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Timezone offset from UTC for sim locale")
    @StateChange
    public Competition withTimezoneOffset(int offset) {
        int n = offset;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timezoneOffset = offset;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getLatitude() {
        return this.latitude;
    }

    @ConfigurableValue(valueType="Integer", description="Approximate latitude of sim locale")
    @StateChange
    public Competition withLatitude(int latitude) {
        int n = latitude;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.latitude = latitude;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getBootstrapTimeslotCount() {
        return this.bootstrapTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session during which data is collected")
    @StateChange
    public Competition withBootstrapTimeslotCount(int bootstrapTimeslotCount) {
        int n = bootstrapTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.bootstrapTimeslotCount = bootstrapTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getBootstrapDiscardedTimeslots() {
        return this.bootstrapDiscardedTimeslots;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session that are discardedbefore data collection begins")
    @StateChange
    public Competition withBootstrapDiscardedTimeslots(int count) {
        int n = count;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.bootstrapDiscardedTimeslots = count;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    @StateChange
    public Competition withSimulationRate(long simulationRate) {
        long l = simulationRate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationRate = simulationRate;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getSimulationTimeslotSeconds() {
        return this.timeslotLength * 60 / (int)this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    public Competition withSimulationTimeslotSeconds(int seconds) {
        return this.withSimulationRate(this.timeslotLength * 60 / seconds);
    }

    public long getSimulationModulo() {
        return this.simulationModulo;
    }

    @ConfigurableValue(valueType="Long", description="Size, in milliseconds, of a simulation clock tick.Normally, this is the same as a timeslot.")
    @StateChange
    public Competition withSimulationModulo(long simulationModulo) {
        long l = simulationModulo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationModulo = simulationModulo;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Map<String, Long> getClockParameters() {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        result.put("base", this.getSimulationBaseTime().getMillis());
        result.put("rate", this.getSimulationRate());
        result.put("modulo", this.getSimulationModulo());
        return result;
    }

    public List<String> getBrokers() {
        return this.brokers;
    }

    @StateChange
    public Competition addBroker(String brokerUsername) {
        String string = brokerUsername;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        this.brokers.add(brokerUsername);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public List<CustomerInfo> getCustomers() {
        return this.customers;
    }

    @StateChange
    public Competition addCustomer(CustomerInfo customer) {
        CustomerInfo customerInfo = customer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)customerInfo);
        this.customers.add(customer);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public void update(Competition template) {
        this.withBootstrapTimeslotCount(template.getBootstrapTimeslotCount());
        this.withDeactivateTimeslotsAhead(template.getDeactivateTimeslotsAhead());
        this.withSimulationBaseTime(template.getSimulationBaseTime());
        this.withBootstrapDiscardedTimeslots(template.getBootstrapDiscardedTimeslots());
        this.withSimulationModulo(template.getSimulationModulo());
        this.withTimeslotLength(template.getTimeslotLength());
        this.withTimeslotsOpen(template.getTimeslotsOpen());
    }

    public String toString() {
        return this.name;
    }

    static {
        Competition.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Competition.java", Competition.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "org.powertac.common.Competition", "java.lang.String", "name", ""), 166);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDescription", "org.powertac.common.Competition", "java.lang.String", "description", "", "org.powertac.common.Competition"), 199);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimezoneOffset", "org.powertac.common.Competition", "int", "offset", "", "org.powertac.common.Competition"), 419);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withLatitude", "org.powertac.common.Competition", "int", "latitude", "", "org.powertac.common.Competition"), 439);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withBootstrapTimeslotCount", "org.powertac.common.Competition", "int", "bootstrapTimeslotCount", "", "org.powertac.common.Competition"), 460);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withBootstrapDiscardedTimeslots", "org.powertac.common.Competition", "int", "count", "", "org.powertac.common.Competition"), 482);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationRate", "org.powertac.common.Competition", "long", "simulationRate", "", "org.powertac.common.Competition"), 503);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationModulo", "org.powertac.common.Competition", "long", "simulationModulo", "", "org.powertac.common.Competition"), 550);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBroker", "org.powertac.common.Competition", "java.lang.String", "brokerUsername", "", "org.powertac.common.Competition"), 590);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCustomer", "org.powertac.common.Competition", "org.powertac.common.CustomerInfo", "customer", "", "org.powertac.common.Competition"), 610);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPomId", "org.powertac.common.Competition", "java.lang.String", "id", "", "org.powertac.common.Competition"), 220);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotLength", "org.powertac.common.Competition", "int", "timeslotLength", "", "org.powertac.common.Competition"), 249);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinimumTimeslotCount", "org.powertac.common.Competition", "int", "minimumTimeslotCount", "", "org.powertac.common.Competition"), 270);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpectedTimeslotCount", "org.powertac.common.Competition", "int", "expectedTimeslotCount", "", "org.powertac.common.Competition"), 290);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotsOpen", "org.powertac.common.Competition", "int", "timeslotsOpen", "", "org.powertac.common.Competition"), 310);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDeactivateTimeslotsAhead", "org.powertac.common.Competition", "int", "deactivateTimeslotsAhead", "", "org.powertac.common.Competition"), 332);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinimumOrderQuantity", "org.powertac.common.Competition", "double", "minOrderQty", "", "org.powertac.common.Competition"), 352);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationBaseTime", "org.powertac.common.Competition", "long", "baseTime", "", "org.powertac.common.Competition"), 399);
    }
}

