/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Rate;
import org.powertac.common.Tariff;
import org.powertac.common.TimeService;
import org.powertac.common.spring.SpringApplicationContext;

public class TariffEvaluationHelper {
    private static Logger log = LogManager.getLogger((String)TariffEvaluationHelper.class.getName());
    private double wtExpected = 0.6;
    private double wtMax = 0.4;
    private double wtRealized = 0.8;
    private double soldThreshold = 10000.0;
    private double expCurtail = 0.0;
    private double expDischarge = 0.0;
    private double expDown = 0.0;
    private double normWtExpected = 0.0;
    private double normWtMax = 0.0;
    private double alpha = 0.0;
    private Tariff tariff = null;
    private TimeService timeService;

    public void init(double wtExpected, double wtMax, double wtRealized, double soldThreshold) {
        this.setWtExpected(wtExpected);
        this.setWtMax(wtMax);
        this.setWtRealized(wtRealized);
        this.soldThreshold = soldThreshold;
        this.init();
    }

    public void init() {
        this.alpha = 0.0;
        this.tariff = null;
        this.normalizeWeights();
        if (this.timeService == null) {
            try {
                this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
            }
            catch (IllegalStateException illegalStateException) {
                log.warn("SpringApplicationContext is closed");
            }
        }
        if (this.timeService == null) {
            this.timeService = TimeService.getInstance();
        }
    }

    public void initializeCostFactors(double wtExpected, double wtMax, double wtRealized, double soldThreshold) {
        this.init(wtExpected, wtMax, wtRealized, soldThreshold);
    }

    public void initializeRegulationFactors(double expectedCurtailment, double expectedDischarge, double expectedDownReg) {
        this.expCurtail = expectedCurtailment;
        this.expDischarge = expectedDischarge;
        this.expDown = expectedDownReg;
    }

    public double estimateCost(Tariff tariff, double[] usage, Instant start, boolean includePeriodicCharge) {
        this.init();
        this.tariff = tariff;
        this.computeAlpha(tariff);
        double dailyUsage = 0.0;
        double result = 0.0;
        Instant time = start;
        if (time == null) {
            log.error("Time is null!");
        }
        int index = 0;
        while (index < usage.length) {
            time = time.plus(3600000L);
            result += tariff.getUsageCharge(time, usage[index], dailyUsage, this);
            if (includePeriodicCharge) {
                result += tariff.getPeriodicPayment() / 24.0;
            }
            dailyUsage = time.toDateTime().getHourOfDay() == 0 ? 0.0 : (dailyUsage += usage[index]);
            ++index;
        }
        double adj = 0.0;
        if (tariff.hasRegulationRate()) {
            adj -= tariff.getRegulationCharge(this.expCurtail + this.expDischarge, 0.0, false);
            adj += tariff.getRegulationCharge(this.expDown, 0.0, false);
        }
        return result + adj * (double)usage.length;
    }

    public double estimateCost(Tariff tariff, double[] usage, boolean includePeriodicCharge) {
        return this.estimateCost(tariff, usage, this.timeService.getCurrentTime(), includePeriodicCharge);
    }

    public double estimateCost(Tariff tariff, double[] usage, Instant start) {
        return this.estimateCost(tariff, usage, start, true);
    }

    public double estimateCost(Tariff tariff, double[] usage) {
        return this.estimateCost(tariff, usage, true);
    }

    private void computeAlpha(Tariff tariff) {
        this.alpha = 1.0 - this.getWtRealized() * (1.0 - 1.0 / (1.0 + tariff.getTotalUsage() / this.getSoldThreshold()));
    }

    public double[] estimateCostArray(Tariff tariff, double[] usage, boolean includePeriodicCharge) {
        this.init();
        this.tariff = tariff;
        this.computeAlpha(tariff);
        double dailyUsage = 0.0;
        double[] result = new double[usage.length];
        Instant time = this.timeService.getCurrentTime();
        int index = 0;
        while (index < usage.length) {
            time = time.plus(3600000L);
            result[index] = tariff.getUsageCharge(time, usage[index], dailyUsage, this);
            if (includePeriodicCharge) {
                int n = index;
                result[n] = result[n] + tariff.getPeriodicPayment() / 24.0;
            }
            dailyUsage = this.timeService.getHourOfDay() == 0 ? 0.0 : (dailyUsage += usage[index]);
            ++index;
        }
        return result;
    }

    public double[] estimateCostArray(Tariff tariff, double[] usage) {
        return this.estimateCostArray(tariff, usage, true);
    }

    double getWeightedValue(Rate rate) {
        return this.alpha * (this.getNormWtExpected() * rate.getExpectedMean() + this.getNormWtMax() * rate.getMaxValue()) + (1.0 - this.alpha) * this.tariff.getRealizedPrice();
    }

    public double getWtExpected() {
        return this.wtExpected;
    }

    public double getNormWtExpected() {
        return this.normWtExpected;
    }

    public void setWtExpected(double wt) {
        this.wtExpected = wt;
        this.normalizeWeights();
    }

    public double getWtMax() {
        return this.wtMax;
    }

    public double getNormWtMax() {
        return this.normWtMax;
    }

    public void setWtMax(double wt) {
        this.wtMax = wt;
        this.normalizeWeights();
    }

    public double getWtRealized() {
        return this.wtRealized;
    }

    public void setWtRealized(double wt) {
        if (wt < 0.0 || wt > 1.0) {
            log.error("realizedPrice weight " + wt + " out of range");
            wt = Math.min(Math.max(wt, 0.0), 1.0);
        }
        this.wtRealized = wt;
    }

    public double getSoldThreshold() {
        return this.soldThreshold;
    }

    public void setSoldThreshold(double st) {
        this.soldThreshold = st;
    }

    public double getExpectedCurtailment() {
        return this.expCurtail;
    }

    public double getExpectedDischarge() {
        return this.expDischarge;
    }

    public double getExpectedDownRegulation() {
        return this.expDown;
    }

    private void normalizeWeights() {
        double sum = this.wtExpected + this.wtMax;
        this.normWtExpected = this.wtExpected / sum;
        this.normWtMax = this.wtMax / sum;
    }
}

