/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageDispatcher {
    public static Object dispatch(Object target, String methodName, Object ... args) {
        Logger log = LogManager.getLogger((String)target.getClass().getName());
        Object result = null;
        try {
            Class[] classes = new Class[args.length];
            int index = 0;
            while (index < args.length) {
                classes[index] = args[index].getClass();
                ++index;
            }
            Method method = target.getClass().getMethod(methodName, classes);
            log.debug("found method " + method);
            result = method.invoke(target, args);
        }
        catch (NoSuchMethodException nsm) {
            log.debug("Could not find exact match: " + nsm.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable thr = ite.getTargetException();
            log.error("Cannot call " + methodName + ": " + thr + "\n  ..at " + thr.getStackTrace()[0] + "\n  ..at " + thr.getStackTrace()[1] + "\n  ..at " + thr.getStackTrace()[2] + "\n  ..at " + thr.getStackTrace()[3] + "\n  ..at ");
        }
        catch (Exception ex) {
            log.error("Exception calling message processor: " + ex.toString());
        }
        return result;
    }
}

