/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.HourlyCharge;
import org.powertac.common.Rate;
import org.powertac.common.RegulationRate;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TimeService;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
public class Tariff {
    private static Logger log;
    private TimeService timeService;
    private TariffRepo tariffRepo;
    private long specId;
    private TariffSpecification tariffSpec;
    private Broker broker;
    private State state;
    private Tariff isSupersededBy;
    double totalCost;
    double totalUsage;
    private Instant offerDate;
    private Instant expiration;
    private double meanConsumptionPrice;
    private double productionMargin;
    private boolean isWeekly;
    private boolean analyzed;
    private HashMap<Long, Rate> rateIdMap;
    private TreeSet<Double> tiers;
    private int tierSign;
    private Rate[][] rateMap;
    private RegulationRate regulationRate;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Tariff.ajc$preClinit();
        log = LogManager.getLogger((String)Tariff.class.getName());
    }

    public Tariff(TariffSpecification spec) {
        TariffSpecification tariffSpecification = spec;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tariffSpecification);
        this.state = State.PENDING;
        this.totalCost = 0.0;
        this.totalUsage = 0.0;
        this.meanConsumptionPrice = 0.0;
        this.productionMargin = -1.5;
        this.isWeekly = false;
        this.analyzed = false;
        this.tierSign = 1;
        this.tariffSpec = spec;
        this.specId = spec.getId();
        this.broker = spec.getBroker();
        this.expiration = spec.getExpiration();
        this.rateIdMap = new HashMap();
        for (Rate rate : spec.getRates()) {
            this.rateIdMap.put(rate.getId(), rate);
        }
        for (RegulationRate regulationRate : spec.getRegulationRates()) {
            if (this.regulationRate != null) {
                log.warn("Multiple regulation rates on tariff " + this.getId());
                continue;
            }
            this.regulationRate = regulationRate;
        }
        this.tiers = new TreeSet();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public boolean init() {
        if (this.timeService == null) {
            this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        }
        if (this.tariffRepo == null) {
            this.tariffRepo = (TariffRepo)SpringApplicationContext.getBean("tariffRepo");
        }
        this.offerDate = this.timeService.getCurrentTime();
        for (Rate r : this.tariffSpec.getRates()) {
            if (r.isValid(this.tariffSpec.getPowerType())) continue;
            return false;
        }
        this.analyze();
        if (!this.isCovered()) {
            return false;
        }
        this.meanConsumptionPrice = this.computeMeanConsumptionPrice(this.rateMap);
        this.tariffRepo.addTariff(this);
        if (this.tariffSpec.getSupersedes() != null) {
            for (long supId : this.tariffSpec.getSupersedes()) {
                Tariff supersededTariff = this.tariffRepo.findTariffById(supId);
                if (supersededTariff == null) {
                    log.error("Superseded tariff " + supId + " not found");
                    continue;
                }
                if (supersededTariff.getPowerType() != this.getPowerType() && !supersededTariff.getPowerType().canUse(this.getPowerType())) {
                    log.error("Tariff " + supId + ", powerType=" + supersededTariff.getPowerType() + " cannot be superseded by tariff " + this.getId() + ", powerType=" + this.getPowerType());
                    continue;
                }
                supersededTariff.isSupersededBy = this;
            }
        }
        return true;
    }

    public TariffSpecification getTariffSpecification() {
        return this.tariffSpec;
    }

    public long getSpecId() {
        return this.specId;
    }

    public long getId() {
        return this.specId;
    }

    void setId(long id) {
        this.specId = id;
    }

    @StateChange
    public boolean addHourlyCharge(HourlyCharge newCharge, long rateId) {
        boolean bl;
        HourlyCharge hourlyCharge = newCharge;
        long l = rateId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)hourlyCharge, (Object)Conversions.longObject((long)l));
        Rate theRate = this.rateIdMap.get(rateId);
        if (theRate == null) {
            log.error("addHourlyCharge - no rate " + rateId);
            bl = false;
        } else {
            bl = theRate.addHourlyCharge(newCharge);
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return bl;
    }

    public double getRealizedPrice() {
        if (this.totalUsage == 0.0) {
            return 0.0;
        }
        double sign = this.tariffSpec.getPowerType().isProduction() ? -1.0 : 1.0;
        return sign * this.totalCost / this.totalUsage;
    }

    public long getMinDuration() {
        return this.tariffSpec.getMinDuration();
    }

    public PowerType getPowerType() {
        return this.tariffSpec.getPowerType();
    }

    public double getSignupPayment() {
        return this.tariffSpec.getSignupPayment();
    }

    public double getEarlyWithdrawPayment() {
        return this.tariffSpec.getEarlyWithdrawPayment();
    }

    public double getPeriodicPayment() {
        return this.tariffSpec.getPeriodicPayment();
    }

    public double getMaxUpRegulation(double kwh, double cumulativeUsage) {
        if (!this.tariffSpec.getPowerType().isInterruptible()) {
            return 0.0;
        }
        int di = this.getTimeIndex(this.timeService.getCurrentTime());
        if (this.tiers.size() == 1) {
            Rate rate = this.rateMap[0][di];
            return kwh * rate.getMaxCurtailment();
        }
        double result = 0.0;
        List<RateKwh> rkList = this.getRateKwhList(di, kwh, cumulativeUsage);
        for (RateKwh rk : rkList) {
            result += rk.kwh * rk.rate.getMaxCurtailment();
        }
        return result;
    }

    public double getUsageCharge(double kwh, double cumulativeUsage, boolean recordUsage) {
        double amt = this.getUsageCharge(this.timeService.getCurrentTime(), kwh, cumulativeUsage);
        if (recordUsage) {
            this.totalUsage += kwh;
            this.totalCost += amt;
        }
        return amt;
    }

    public double getRegulationCharge(double kwh, double cumulativeUsage, boolean recordUsage) {
        if (this.regulationRate == null) {
            return this.getUsageCharge(-kwh, cumulativeUsage, recordUsage);
        }
        if (kwh < 0.0) {
            return -kwh * this.regulationRate.getUpRegulationPayment();
        }
        if (kwh > 0.0) {
            return kwh * this.regulationRate.getDownRegulationPayment();
        }
        return 0.0;
    }

    public double overpricedUpRegulationRatio() {
        if (!this.hasRegulationRate()) {
            return 1.0;
        }
        double excess = this.regulationRate.getUpRegulationPayment() - this.getMeanConsumptionPrice() * Competition.currentCompetition().getMaxUpRegulationPaymentRatio();
        if (excess > 0.0) {
            return Math.pow(Competition.currentCompetition().getUpRegulationDiscount(), excess);
        }
        return 1.0;
    }

    public double overpricedDownRegulationRatio() {
        if (!this.hasRegulationRate()) {
            return 1.0;
        }
        double excess = -this.regulationRate.getDownRegulationPayment() + this.getMeanConsumptionPrice() * Competition.currentCompetition().getMaxDownRegulationPaymentRatio();
        if (excess > 0.0) {
            return Math.pow(Competition.currentCompetition().getDownRegulationDiscount(), excess);
        }
        return 1.0;
    }

    public double getUsageCharge(Instant when, double kwh, double cumulativeUsage) {
        return this.getUsageCharge(when, kwh, cumulativeUsage, null);
    }

    public double getUsageCharge(Instant when, double kwh, double cumulativeUsage, TariffEvaluationHelper helper) {
        double sign;
        double result = 0.0;
        int di = this.getTimeIndex(when);
        double d = sign = this.tariffSpec.getPowerType().isProduction() ? -1.0 : 1.0;
        if (this.tiers == null || this.tiers.size() < 1) {
            log.error("uninitialized tariff " + this.getId());
            return 0.0;
        }
        if (this.tiers.size() == 1) {
            Rate rate = this.findRate(0, di);
            double perKWh = rate.getValue((AbstractInstant)when, helper);
            result = this.regulatedKWh(kwh, helper) * perKWh;
        } else {
            List<RateKwh> rkList = this.getRateKwhList(di, this.regulatedKWh(kwh, helper), cumulativeUsage);
            for (RateKwh rk : rkList) {
                double perKWh = rk.rate.getValue((AbstractInstant)when, helper);
                result += rk.kwh * perKWh;
            }
        }
        return sign * result;
    }

    private double regulatedKWh(double kwh, TariffEvaluationHelper helper) {
        if (helper != null && kwh > 0.0) {
            return Math.max(0.0, kwh + helper.getExpectedRegulation());
        }
        return kwh;
    }

    private int getTimeIndex(Instant when) {
        DateTime dt = new DateTime((Object)when, DateTimeZone.UTC);
        int di = dt.getHourOfDay();
        if (this.isWeekly) {
            di += 24 * (dt.getDayOfWeek() - 1);
        }
        return di;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired() {
        if (this.getExpiration() == null) {
            return false;
        }
        return !this.timeService.getCurrentTime().isBefore((ReadableInstant)this.getExpiration());
    }

    @StateChange
    public void setExpiration(Instant newDate) {
        Instant instant = newDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)instant);
        this.expiration = newDate;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public Instant getOfferDate() {
        return this.offerDate;
    }

    public boolean isCovered() {
        int tier = 0;
        while (tier < this.tiers.size()) {
            int hour = 0;
            while (hour < (this.isWeekly ? 168 : 24)) {
                if (this.rateMap[tier][hour] == null) {
                    return false;
                }
                ++hour;
            }
            ++tier;
        }
        return true;
    }

    public TariffSpecification getTariffSpec() {
        return this.tariffSpec;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public State getState() {
        return this.state;
    }

    @StateChange
    public void setState(State newState) {
        State state = newState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)state));
        this.state = newState;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public boolean isActive() {
        return State.OFFERED == this.state || State.ACTIVE == this.state;
    }

    public Tariff getIsSupersededBy() {
        return this.isSupersededBy;
    }

    public double getTotalCost() {
        return this.totalCost;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    public double getMeanConsumptionPrice() {
        return this.meanConsumptionPrice;
    }

    public boolean isWeekly() {
        return this.isWeekly;
    }

    public boolean isRevoked() {
        return this.state == State.KILLED;
    }

    public boolean isSubscribable() {
        return this.isActive() && !this.isExpired() && !this.isRevoked();
    }

    public boolean isTimeOfUse() {
        for (Rate rate : this.getTariffSpec().getRates()) {
            if (!rate.isTimeOfUse()) continue;
            return true;
        }
        return false;
    }

    public boolean isTiered() {
        for (Rate rate : this.getTariffSpec().getRates()) {
            if (rate.getTierThreshold() == 0.0) continue;
            return true;
        }
        return false;
    }

    public boolean isVariableRate() {
        for (Rate rate : this.getTariffSpec().getRates()) {
            if (rate.isFixed()) continue;
            return true;
        }
        return false;
    }

    public boolean isInterruptible() {
        if (this.getPowerType().isInterruptible()) {
            for (Rate rate : this.getTariffSpec().getRates()) {
                if (rate.getMaxCurtailment() == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRegulationRate() {
        return this.getTariffSpec().hasRegulationRate();
    }

    private void analyze() {
        HashMap<Double, Integer> tierIndexMap = new HashMap<Double, Integer>();
        if (this.tariffSpec.getPowerType().isProduction()) {
            this.tierSign = -1;
        }
        this.tiers.add(0.0 * (double)this.tierSign);
        int weekMultiplier = 1;
        for (Rate rate : this.tariffSpec.getRates()) {
            rate.setTimeService(this.timeService);
            if (rate.getWeeklyBegin() >= 0) {
                this.isWeekly = true;
                weekMultiplier = 7;
            }
            if (!(rate.getTierThreshold() * (double)this.tierSign > 0.0)) continue;
            this.tiers.add(rate.getTierThreshold() * (double)this.tierSign);
        }
        log.info("tariff " + this.specId + ", tiers: " + this.tiers);
        int tidx = 0;
        Iterator<Object> iterator = this.tiers.iterator();
        while (iterator.hasNext()) {
            double threshold = iterator.next();
            tierIndexMap.put(threshold, tidx++);
        }
        TreeMap<Integer, Rate> annotatedRates = new TreeMap<Integer, Rate>();
        for (Rate rate : this.tariffSpec.getRates()) {
            int value = 0;
            if (rate.getDailyBegin() >= 0) {
                value = rate.getDailyBegin();
            }
            if (rate.getWeeklyBegin() >= 0) {
                value += rate.getWeeklyBegin() * 24;
            }
            if (rate.getTierThreshold() * (double)this.tierSign > 0.0) {
                value += (Integer)tierIndexMap.get(rate.getTierThreshold() * (double)this.tierSign) * 24 * weekMultiplier;
            }
            log.debug("inserting " + value + ", " + rate.getId());
            annotatedRates.put(value, rate);
        }
        this.rateMap = new Rate[tierIndexMap.size()][weekMultiplier * 24];
        for (Map.Entry entry : annotatedRates.entrySet()) {
            int hour;
            Rate rate = (Rate)((Object)entry.getValue());
            int ti = (Integer)tierIndexMap.get(rate.getTierThreshold() * (double)this.tierSign);
            int day1 = 0;
            int dayn = 0;
            if (this.isWeekly) {
                if (rate.getWeeklyBegin() >= 0) {
                    day1 = rate.getWeeklyBegin() - 1;
                    dayn = rate.getWeeklyBegin() - 1;
                } else {
                    dayn = 6;
                }
                if (rate.getWeeklyEnd() >= 0) {
                    dayn = rate.getWeeklyEnd() - 1;
                }
            }
            int hr1 = 0;
            int hrn = 23;
            if (rate.getDailyBegin() >= 0) {
                hr1 = rate.getDailyBegin();
                hrn = rate.getDailyEnd();
            }
            log.debug("day1=" + day1 + ", dayn=" + dayn + ", hr1=" + hr1 + ", hrn=" + hrn);
            int day = dayn < day1 ? 0 : day1;
            while (day <= dayn) {
                hour = hrn < hr1 ? 0 : hr1;
                while (hour <= hrn) {
                    this.rateMap[ti][hour + day * 24] = rate;
                    ++hour;
                }
                if (hrn < hr1) {
                    hour = hr1;
                    while (hour <= 23) {
                        this.rateMap[ti][hour + day * 24] = rate;
                        ++hour;
                    }
                }
                ++day;
            }
            if (dayn >= day1) continue;
            day = day1;
            while (day <= 6) {
                hour = hrn < hr1 ? 0 : hr1;
                while (hour <= hrn) {
                    this.rateMap[ti][hour + day * 24] = rate;
                    ++hour;
                }
                if (hrn < hr1) {
                    hour = hr1;
                    while (hour <= 23) {
                        this.rateMap[ti][hour + day * 24] = rate;
                        ++hour;
                    }
                }
                ++day;
            }
        }
        this.analyzed = true;
    }

    private List<RateKwh> getRateKwhList(int timeIndex, double kwh, double cumulativeUsage) {
        ArrayList<RateKwh> result = new ArrayList<RateKwh>();
        double remainingAmount = kwh * (double)this.tierSign;
        double accumulatedAmount = cumulativeUsage * (double)this.tierSign;
        ArrayList<Double> tierList = new ArrayList<Double>(this.tiers);
        int ti = 0;
        while (remainingAmount > 0.0) {
            if (tierList.size() > ti + 1) {
                if (accumulatedAmount >= tierList.get(ti + 1)) {
                    log.debug("accumulatedAmount " + accumulatedAmount + " above threshold " + (ti + 1) + ":" + tierList.get(ti + 1));
                    ++ti;
                    continue;
                }
                if (remainingAmount + accumulatedAmount > tierList.get(ti + 1)) {
                    double amt = tierList.get(ti + 1) - accumulatedAmount;
                    log.debug("split off " + amt + " below " + tierList.get(ti + 1));
                    result.add(new RateKwh(this.rateMap[ti++][timeIndex], amt * (double)this.tierSign));
                    remainingAmount -= amt;
                    accumulatedAmount += amt;
                    continue;
                }
                log.debug("amount " + remainingAmount + " fits in tier " + ti);
                result.add(new RateKwh(this.rateMap[ti][timeIndex], remainingAmount * (double)this.tierSign));
                remainingAmount = 0.0;
                continue;
            }
            log.debug("remainder " + remainingAmount + " fits in top tier");
            result.add(new RateKwh(this.rateMap[ti][timeIndex], remainingAmount * (double)this.tierSign));
            remainingAmount = 0.0;
        }
        return result;
    }

    private Rate findRate(int tierIndex, int timeIndex) {
        Rate rate = this.rateMap[tierIndex][timeIndex];
        if (rate == null) {
            log.error("could not find rate for tier " + tierIndex + ", ti " + timeIndex);
        }
        return rate;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    double computeMeanConsumptionPrice(Rate[][] map) {
        if (!this.analyzed) {
            log.error("Tariff not analyzed, cannot compute mean consumption price");
            return 0.0;
        }
        double mult = 1.0;
        if (this.tariffSpec.getPowerType().isProduction()) {
            mult = this.productionMargin;
        }
        double sum = 0.0;
        int count = 0;
        int i = 0;
        while (i < map[0].length) {
            ++count;
            Rate rate = map[0][i];
            sum = rate.isFixed() ? (sum += rate.getMinValue()) : (sum += rate.getExpectedMean());
            ++i;
        }
        return mult * sum / (double)count;
    }

    void setTimeService(TimeService ts) {
        this.timeService = ts;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Tariff.java", Tariff.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Tariff", "org.powertac.common.TariffSpecification", "spec", ""), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHourlyCharge", "org.powertac.common.Tariff", "org.powertac.common.HourlyCharge:long", "newCharge:rateId", "", "boolean"), 219);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpiration", "org.powertac.common.Tariff", "org.joda.time.Instant", "newDate", "", "void"), 515);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setState", "org.powertac.common.Tariff", "org.powertac.common.Tariff$State", "newState", "", "void"), 566);
    }

    class RateKwh {
        Rate rate;
        double kwh;

        RateKwh(Rate rate, double kwh) {
            this.rate = rate;
            this.kwh = kwh;
        }
    }

    public static enum State {
        PENDING,
        OFFERED,
        ACTIVE,
        WITHDRAWN,
        KILLED;

    }
}

