/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.config;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.BasePathLocationStrategy;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.config.ConfigurationRecorder;
import org.powertac.util.Predicate;

public class Configurator {
    private static Logger log = LogManager.getLogger(Configurator.class);
    private Configuration config;
    private HashMap<Class<?>, HashMap<String, ConfigurableProperty>> annotationMap = new HashMap();
    private HashSet<String> metadataSet = new HashSet();
    private ConfigurationRecorder configDump = null;
    private HashMap<Class<?>, Set<String>> createdInstances = new HashMap();
    private HashMap<Class<?>, Set<String>> configuredProps = new HashMap();
    private static final FileLocationStrategy fileLocationStrategy;
    private static final ListDelimiterHandler listDelimiterHandler;

    static {
        LinkedList<Object> strategies = new LinkedList<Object>();
        strategies.add(new ClasspathLocationStrategy());
        strategies.add(new BasePathLocationStrategy());
        fileLocationStrategy = new CombinedLocationStrategy(strategies);
        listDelimiterHandler = new DefaultListDelimiterHandler(',');
    }

    public static final XMLConfiguration readXML(String path) throws ConfigurationException {
        return (XMLConfiguration)new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)new Parameters().xml().setBasePath(".")).setFileName(path)).setLocationStrategy(fileLocationStrategy)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public static final XMLConfiguration readXML(File file) throws ConfigurationException {
        return (XMLConfiguration)new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)new Parameters().xml().setFile(file)).setLocationStrategy(fileLocationStrategy)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public static final XMLConfiguration readXML(URL url) throws ConfigurationException {
        return (XMLConfiguration)new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)new Parameters().xml().setURL(url)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public static final PropertiesConfiguration readProperties(String path) throws ConfigurationException {
        return (PropertiesConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setBasePath(".")).setFileName(path)).setLocationStrategy(fileLocationStrategy)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public static final PropertiesConfiguration readProperties(URL url) throws ConfigurationException {
        return (PropertiesConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setURL(url)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public static final PropertiesConfiguration readProperties(File file) throws ConfigurationException {
        return (PropertiesConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setFile(file)).setLocationStrategy(fileLocationStrategy)).setListDelimiterHandler(listDelimiterHandler)}).getConfiguration();
    }

    public void setConfiguration(AbstractConfiguration config) {
        if (config.getListDelimiterHandler() instanceof DisabledListDelimiterHandler) {
            config.setListDelimiterHandler(listDelimiterHandler);
        }
        this.config = config;
    }

    public void setConfigOutput(ConfigurationRecorder configOutput) {
        this.configDump = configOutput;
    }

    public void configureSingleton(Object thing) {
        if (this.config == null) {
            log.error("Cannot configure - no Configuration set");
            return;
        }
        String[] classnamePath = this.extractClassnamePath(thing);
        if (classnamePath == null) {
            return;
        }
        Configuration subset = this.extractConfigForClass(classnamePath);
        if (this.isSingletonConfig(subset)) {
            this.configureInstance(thing, subset, null);
        } else {
            log.error("Attempt to configure Singleton with multi-instance config data");
        }
    }

    private String[] extractClassnamePath(Object thing) {
        String classname = thing.getClass().getName();
        log.debug("configuring object of type " + classname);
        String[] classnamePath = classname.split("\\.");
        return classnamePath;
    }

    public Collection<?> configureInstances(Class<?> type) {
        if (this.config == null) {
            log.error("Cannot configure - no Configuration set");
            return new ArrayList();
        }
        String classname = type.getName();
        log.debug("configuring instances for type " + classname);
        Configuration subset = this.extractSubsetForClassname(classname);
        if (this.createdInstances.get(type) == null) {
            this.createdInstances.put(type, new HashSet());
        }
        Set<String> existingNames = this.createdInstances.get(type);
        List rawNames = subset.getList("instances");
        List<String> names = rawNames.stream().map(n -> n.toString()).filter(n -> !n.isEmpty()).collect(Collectors.toList());
        if (names.size() == 0) {
            log.warn("No instance names specified for class " + classname);
            return names;
        }
        this.dumpInstanceListMaybe(type, existingNames, names);
        LinkedHashMap itemMap = new LinkedHashMap();
        for (String name : names) {
            existingNames.add(name);
            try {
                Constructor<?> constructor = type.getConstructor(String.class);
                Object item = constructor.newInstance(name);
                itemMap.put(name, item);
            }
            catch (Exception e) {
                log.error("Unable to create instance " + name + " of class " + type + ": " + e.toString());
            }
        }
        for (String name : itemMap.keySet()) {
            this.configureInstance(itemMap.get(name), subset.subset(name), name);
        }
        return itemMap.values();
    }

    private void dumpInstanceListMaybe(Class<?> type, Set<String> existingNames, List<String> names) {
        List<String> dumpNames = names.stream().filter(n -> !existingNames.contains(n)).collect(Collectors.toList());
        if (dumpNames.size() > 0) {
            this.dumpInstanceListMaybe(type, dumpNames);
        }
    }

    public Collection<?> configureNamedInstances(List<?> instances) {
        if (this.config == null) {
            log.error("Cannot configure - no Configuration set");
            return null;
        }
        if (instances == null || instances.size() == 0) {
            log.error("Cannot configure empty instance list");
            return null;
        }
        String classname = instances.get(0).getClass().getName();
        log.debug("configuring instances for type " + classname);
        Configuration subset = this.extractSubsetForClassname(classname);
        try {
            Method getNameMethod = instances.get(0).getClass().getMethod("getName", new Class[0]);
            for (Object item : instances) {
                Object result = getNameMethod.invoke(item, new Object[0]);
                String name = (String)result;
                this.configureInstance(item, subset.subset(name), name);
            }
        }
        catch (Exception exception) {
            log.error("Could not get name of item");
            return null;
        }
        return instances;
    }

    private Configuration extractSubsetForClassname(String classname) {
        String[] classnamePath = classname.split("\\.");
        Configuration subset = this.extractConfigForClass(classnamePath);
        return subset;
    }

    public void gatherPublishedConfiguration(Object thing, ConfigurationRecorder recorder) {
        this.gatherConfiguration(thing, null, recorder, prop -> prop.cv.publish());
    }

    public void gatherBootstrapState(Object thing, ConfigurationRecorder recorder) {
        if (thing instanceof List) {
            this.gatherBootstrapList((List)thing, recorder);
        } else {
            this.gatherConfiguration(thing, null, recorder, prop -> prop.cv.bootstrapState());
        }
    }

    public void gatherBootstrapList(List<Object> things, ConfigurationRecorder recorder) {
        for (Object thing : things) {
            Class<?> thingClass = thing.getClass();
            try {
                Method getNameMethod = thingClass.getMethod("getName", new Class[0]);
                Object name = getNameMethod.invoke(thing, new Object[0]);
                if (name == null) {
                    log.error("Null name for " + thing.toString());
                    continue;
                }
                this.gatherConfiguration(thing, (String)name, recorder, prop -> prop.cv.bootstrapState());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.error("Cannot extract bootstrap state from " + thing.toString() + ": no getName() method");
            }
            catch (SecurityException securityException) {
                log.error("Cannot extract bootstrap state from " + thing.toString() + ": security exception");
            }
            catch (Exception e) {
                log.error(String.valueOf(e.toString()) + " calling thing.getName()");
            }
        }
    }

    private void gatherConfiguration(Object thing, String name, ConfigurationRecorder recorder, Predicate<ConfigurableProperty> p) {
        String prefix = this.extractClassnamePrefix(this.extractClassnamePath(thing));
        Map<String, ConfigurableProperty> analysis = this.getAnalysis(thing.getClass());
        for (Map.Entry<String, ConfigurableProperty> prop : analysis.entrySet()) {
            ConfigurableProperty cp = prop.getValue();
            if (!p.apply(cp)) continue;
            String key = prefix;
            if (name != null) {
                key = String.valueOf(key) + "." + name;
            }
            key = String.valueOf(key) + "." + prop.getKey();
            log.debug("Recording property " + key);
            Object value = null;
            try {
                if (cp.field != null) {
                    cp.field.setAccessible(true);
                    value = cp.field.get(thing);
                } else if (cp.getter != null) {
                    value = cp.getter.invoke(thing, new Object[0]);
                } else {
                    throw new Exception("field and getter both null");
                }
                recorder.recordItem(key, value);
                recorder.recordMetadata(key, cp.cv.description(), cp.cv.valueType(), cp.cv.publish(), cp.cv.bootstrapState());
            }
            catch (IllegalArgumentException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (IllegalAccessException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (InvocationTargetException e) {
                log.error("cannot read published value: " + e.toString());
            }
            catch (Exception e) {
                log.error("cannot read published value: " + e.toString());
            }
        }
    }

    private Configuration extractConfigForClass(String[] classnamePath) {
        String prefix = this.extractClassnamePrefix(classnamePath);
        log.debug("config prefix " + prefix);
        Configuration subset = this.config.subset(prefix);
        log.debug("config subset empty: " + subset.isEmpty());
        return subset;
    }

    private String extractClassnamePrefix(String[] classnamePath) {
        StringBuilder sb = new StringBuilder();
        int startIndex = 2;
        if (!classnamePath[0].equals("org") || !classnamePath[1].equals("powertac")) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < classnamePath.length - 1) {
            sb.append(classnamePath[i]).append(".");
            ++i;
        }
        sb.append(this.decapitalize(classnamePath[classnamePath.length - 1]));
        String prefix = sb.toString();
        return prefix;
    }

    private boolean isSingletonConfig(Configuration conf) {
        boolean result = true;
        Iterator keys = conf.getKeys();
        while (keys.hasNext() && result) {
            String key = (String)keys.next();
            if (!key.contains("instances")) continue;
            result = false;
        }
        return result;
    }

    private void configureInstance(Object thing, Configuration conf, String name) {
        Map<String, ConfigurableProperty> analysis = this.getAnalysis(thing.getClass());
        Iterator keys = conf.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            log.debug("Configuring property " + key);
            ConfigurableProperty cp = analysis.get(key);
            if (cp == null) {
                log.error("no configurable property named " + key + " on class " + thing.getClass().getName());
                continue;
            }
            this.configureValue(thing, conf, key, cp);
        }
        this.dumpConfigMaybe(thing, analysis, name);
    }

    private void configureValue(Object thing, Configuration conf, String key, ConfigurableProperty cp) {
        ConfigurableValue cv = cp.cv;
        String type = cv.valueType();
        try {
            Object defaultValue = null;
            if (cp.field != null) {
                cp.field.setAccessible(true);
                defaultValue = cp.field.get(thing);
                Object configValue = this.extractConfigValue(conf, key, type, defaultValue);
                cp.field.set(thing, configValue);
            } else if (cp.setter != null) {
                if (cp.getter != null) {
                    defaultValue = cp.getter.invoke(thing, new Object[0]);
                }
                Object configValue = this.extractConfigValue(conf, key, type, defaultValue);
                cp.setter.invoke(thing, configValue);
            } else {
                log.error("No field, no method to set cv " + key);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error("Class " + type + " not found");
        }
        catch (IllegalArgumentException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        catch (IllegalAccessException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        catch (InvocationTargetException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        catch (NoSuchMethodException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
    }

    private Object extractValue(Object thing, ConfigurableProperty cp) {
        ConfigurableValue cfr_ignored_0 = cp.cv;
        Object result = null;
        String key = cp.cv.name();
        try {
            if (cp.field != null) {
                cp.field.setAccessible(true);
                result = cp.field.get(thing);
            } else if (cp.getter != null) {
                result = cp.getter.invoke(thing, new Object[0]);
            } else {
                log.error("No field, no method to extract cv {}", (Object)key);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("cannot extract {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        catch (IllegalAccessException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        catch (InvocationTargetException e) {
            log.error("cannot configure {}: {}", (Object)key, (Object)this.getExceptionDetails(e));
        }
        return result;
    }

    private void dumpConfigMaybe(Object thing, Map<String, ConfigurableProperty> analysis, String name) {
        if (this.configDump != null) {
            Class<?> clazz = thing.getClass();
            for (String key : analysis.keySet()) {
                if (name == null) {
                    name = "";
                }
                String nameKey = String.valueOf(name) + "." + key;
                Set<String> seen = this.configuredProps.get(clazz);
                if (seen == null) {
                    seen = new HashSet<String>();
                    this.configuredProps.put(clazz, seen);
                } else if (seen.contains(nameKey)) continue;
                seen.add(nameKey);
                ConfigurableProperty cp = analysis.get(key);
                String mkey = this.composeKey(clazz.getName(), key, "");
                ConfigurableValue cv = cp.cv;
                if (!cv.dump()) continue;
                if (!this.metadataSet.contains(mkey)) {
                    this.configDump.recordMetadata(mkey, cv.description(), cv.valueType(), cv.publish(), cv.bootstrapState());
                    this.metadataSet.add(mkey);
                }
                this.configDump.recordItem(this.composeKey(clazz.getName(), key, name), this.extractValue(thing, cp));
            }
        }
    }

    private void dumpInstanceListMaybe(Class<?> clazz, List<String> names) {
    }

    String composeKey(String classname, String key, String name) {
        if (name == null || name.equals("")) {
            return String.valueOf(this.classname2Key(classname)) + "." + key;
        }
        return String.valueOf(this.classname2Key(classname)) + "." + name + "." + key;
    }

    private String getExceptionDetails(Exception e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.toString()).append("\n");
        int i = 0;
        while (i < 5) {
            sb.append("...").append(e.getStackTrace()[i].toString()).append("\n");
            ++i;
        }
        return sb.toString();
    }

    private Object extractConfigValue(Configuration conf, String key, String type, Object defaultValue) throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (type.equals("List")) {
            ArrayList<String> def = new ArrayList<String>();
            if (defaultValue != null) {
                for (Object thing : (List)defaultValue) {
                    def.add((String)thing);
                }
            }
            return conf.getList(key, def);
        }
        Class<?> clazz = this.findNamedClass(type);
        String extractorName = "get" + type;
        Method extractor = conf.getClass().getMethod(extractorName, String.class, clazz);
        return extractor.invoke((Object)conf, key, defaultValue);
    }

    private Class<?> findNamedClass(String type) throws ClassNotFoundException {
        Class<?> clazz = type.equals("List") ? Class.forName("java.util.List") : Class.forName("java.lang." + type);
        return clazz;
    }

    private Map<String, ConfigurableProperty> getAnalysis(Class<? extends Object> clazz) {
        HashMap<String, ConfigurableProperty> result = this.annotationMap.get(clazz);
        if (result == null) {
            Field[] fields;
            result = new HashMap();
            this.annotationMap.put(clazz, result);
            log.debug("Analyzing class " + clazz.getName());
            Field[] fieldArray = fields = clazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                ConfigurableValue cv = field.getAnnotation(ConfigurableValue.class);
                if (cv != null) {
                    log.debug("ConfigurableValue field " + field.getName());
                    String propertyName = cv.name();
                    if ("".equals(propertyName)) {
                        propertyName = field.getName();
                    }
                    result.put(propertyName, new ConfigurableProperty(field, cv));
                }
                ++n2;
            }
            Method[] methods = clazz.getMethods();
            Method getter = null;
            Method[] methodArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                ConfigurableValue cv = method.getAnnotation(ConfigurableValue.class);
                if (cv != null) {
                    String getterName;
                    log.debug("ConfigurableValue method found on " + method.getName());
                    String propertyName = cv.name();
                    if ("".equals(propertyName)) {
                        propertyName = this.extractPropertyName(method);
                    }
                    if ("".equals(getterName = cv.getter())) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("get").append(this.capitalize(propertyName));
                        getterName = sb.toString();
                        log.debug("getter name " + getterName);
                        try {
                            getter = clazz.getMethod(getterName, new Class[0]);
                            if (getter != null) {
                                Class<?> valueClass = this.findNamedClass(cv.valueType());
                                if (!getter.getReturnType().isPrimitive() && !valueClass.isAssignableFrom(getter.getReturnType())) {
                                    log.warn("Type mismatch: cannot use default value (" + getter.getReturnType().getName() + ") for " + cv.name() + " (" + valueClass.getName() + ")");
                                    getter = null;
                                }
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            log.error("No getter method " + getterName + " for " + clazz.getName());
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Could not find value class: " + e.toString());
                        }
                    }
                    result.put(propertyName, new ConfigurableProperty(method, getter, cv));
                }
                ++n4;
            }
        }
        return result;
    }

    private String extractPropertyName(Method method) {
        String name = method.getName();
        if (name.startsWith("set")) {
            log.debug("removing 'set' from " + name);
            name = name.substring(3);
        } else if (name.startsWith("with")) {
            log.debug("removing 'with' from " + name);
            name = name.substring(4);
        }
        return this.decapitalize(name);
    }

    private String decapitalize(String name) {
        char first = name.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(first)).append(name.substring(1));
        return sb.toString();
    }

    private String classname2Key(String classname) {
        String cn = classname.replaceFirst("org.powertac.", "");
        int cnpos = cn.lastIndexOf(46);
        return String.valueOf(cn.substring(0, cnpos)) + "." + this.decapitalize(cn.substring(cnpos + 1));
    }

    private String capitalize(String name) {
        char first = name.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(first)).append(name.substring(1));
        return sb.toString();
    }

    class ConfigurableProperty {
        Method setter;
        Method getter;
        Field field;
        ConfigurableValue cv;

        ConfigurableProperty(Method setter, Method getter, ConfigurableValue cv) {
            this.setter = setter;
            this.getter = getter;
            this.field = null;
            this.cv = cv;
        }

        ConfigurableProperty(Field field, ConfigurableValue cv) {
            this.setter = null;
            this.getter = null;
            this.field = field;
            this.cv = cv;
        }
    }
}

