/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.WeatherForecast;
import org.powertac.common.exceptions.PowerTacException;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherForecastRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger((String)WeatherForecastRepo.class.getName());
    private Map<Integer, WeatherForecast> indexedWeatherForecasts = new ConcurrentHashMap<Integer, WeatherForecast>(2000, 0.9f, 1);
    private boolean hasRunOnce = false;
    @Autowired
    private TimeslotRepo timeslotRepo;

    public void add(WeatherForecast weather) {
        this.runOnce();
        this.indexedWeatherForecasts.put(weather.getTimeslotIndex(), weather);
    }

    public WeatherForecast currentWeatherForecast() throws PowerTacException {
        if (!this.hasRunOnce) {
            log.error("Weather Service has yet to run, cannot retrieve report");
            throw new PowerTacException("Attempt to retrieve forecast before data available");
        }
        return this.indexedWeatherForecasts.get(this.timeslotRepo.currentSerialNumber());
    }

    public List<WeatherForecast> allWeatherForecasts() {
        int current = this.timeslotRepo.currentSerialNumber();
        ArrayList<WeatherForecast> issuedReports = new ArrayList<WeatherForecast>();
        for (WeatherForecast w : this.indexedWeatherForecasts.values()) {
            if (w.getTimeslotIndex() >= current) continue;
            issuedReports.add(w);
        }
        issuedReports.add(this.currentWeatherForecast());
        return issuedReports;
    }

    public int count() {
        return this.indexedWeatherForecasts.size();
    }

    public void runOnce() {
        this.hasRunOnce = true;
    }

    @Override
    public void recycle() {
        this.hasRunOnce = false;
        this.indexedWeatherForecasts.clear();
    }
}

