/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.powertac.common.CustomerInfo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.spring.SpringApplicationContext;

public class CustomerConverter
implements SingleValueConverter {
    CustomerRepo customerRepo;

    public boolean canConvert(Class type) {
        return CustomerInfo.class.isAssignableFrom(type);
    }

    public Object fromString(String id) {
        this.ensureCustomerRepo();
        return this.customerRepo.findById(Long.parseLong(id));
    }

    public String toString(Object customer) {
        this.ensureCustomerRepo();
        return Long.toString(((CustomerInfo)customer).getId());
    }

    private void ensureCustomerRepo() {
        if (this.customerRepo == null) {
            this.customerRepo = (CustomerRepo)SpringApplicationContext.getBean("customerRepo");
        }
    }
}

