/*
 * Copyright (c) 2012 by the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * Message type that is guaranteed to be sent to brokers as the last
 * outgoing message in a timeslot. It carries the timeslot index, so brokers
 * can use it to check whether they are in sync. Note that this is not a
 * "standard" domain type, since it does not have an ID and is not logged
 * in the state log. It is just a message.
 * @author John Collins
 */
@XStreamAlias("ts-done")
public class TimeslotComplete
{
  @XStreamAsAttribute
  private int timeslotIndex = 0;

  public TimeslotComplete (int timeslotIndex)
  {
    super();
    this.timeslotIndex = timeslotIndex;
  }

  public int getTimeslotIndex ()
  {
    return timeslotIndex;
  }
  
  @Override
  public String toString ()
  {
    return ("TimeslotComplete#" + timeslotIndex);
  }
}
