/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.powertac.common.CustomerInfo;
import org.powertac.common.IdGenerator;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.FullCustomerConverter;

@Domain
@XStreamAlias(value="competition")
public class Competition {
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    private String description;
    @XStreamAsAttribute
    private String pomId;
    @XStreamAsAttribute
    private int timeslotLength;
    @XStreamAsAttribute
    private int bootstrapTimeslotCount;
    @XStreamAsAttribute
    private int bootstrapDiscardedTimeslots;
    @XStreamOmitField
    private int minimumTimeslotCount;
    @XStreamOmitField
    private int expectedTimeslotCount;
    @XStreamOmitField
    private Integer fixedTimeslotCount;
    @XStreamAsAttribute
    private int timeslotsOpen;
    @XStreamAsAttribute
    private int deactivateTimeslotsAhead;
    @XStreamAsAttribute
    private double minimumOrderQuantity;
    @XStreamAsAttribute
    private double maxUpRegulationPaymentRatio;
    @XStreamAsAttribute
    private double upRegulationDiscount;
    @XStreamAsAttribute
    private double maxDownRegulationPaymentRatio;
    @XStreamAsAttribute
    private double downRegulationDiscount;
    @XStreamAsAttribute
    private double estimatedConsumptionPremium;
    @XStreamAsAttribute
    private Instant simulationBaseTime;
    @XStreamAsAttribute
    private int timezoneOffset;
    @XStreamAsAttribute
    private int latitude;
    @XStreamAsAttribute
    private long simulationRate;
    @XStreamAsAttribute
    private long simulationModulo;
    @XStreamImplicit(itemFieldName="broker")
    private ArrayList<String> brokers;
    @XStreamImplicit(itemFieldName="customer")
    @XStreamConverter(value=FullCustomerConverter.class)
    private ArrayList<CustomerInfo> customers;
    private static Competition theCompetition;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;

    public static Competition newInstance(String name) {
        Competition result = new Competition(name);
        return result;
    }

    public static Competition currentCompetition() {
        return theCompetition;
    }

    public static void setCurrent(Competition newCurrent) {
        theCompetition = newCurrent;
    }

    private Competition(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        this.id = IdGenerator.createId();
        this.name = "default";
        this.description = "";
        this.pomId = "unknown";
        this.timeslotLength = 60;
        this.bootstrapTimeslotCount = 336;
        this.bootstrapDiscardedTimeslots = 24;
        this.minimumTimeslotCount = 480;
        this.expectedTimeslotCount = 600;
        this.fixedTimeslotCount = null;
        this.timeslotsOpen = 24;
        this.deactivateTimeslotsAhead = 1;
        this.minimumOrderQuantity = 0.01;
        this.maxUpRegulationPaymentRatio = -4.0;
        this.upRegulationDiscount = 0.5;
        this.maxDownRegulationPaymentRatio = 1.5;
        this.downRegulationDiscount = 0.4;
        this.estimatedConsumptionPremium = 2.0;
        this.simulationBaseTime = new DateTime(2010, 6, 21, 0, 0, 0, 0, DateTimeZone.UTC).toInstant();
        this.timezoneOffset = 0;
        this.latitude = 45;
        this.simulationRate = 720L;
        this.simulationModulo = 3600000L;
        this.name = name;
        this.brokers = new ArrayList();
        this.customers = new ArrayList();
        theCompetition = this;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @ConfigurableValue(description="user-readable description of the Competition", valueType="String")
    @StateChange
    public Competition withDescription(String description) {
        String string = description;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        this.description = description;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public String getPomId() {
        return this.pomId;
    }

    @ConfigurableValue(description="maven version identifier from server", valueType="String")
    @StateChange
    public Competition withPomId(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        this.pomId = id;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotLength() {
        return this.timeslotLength;
    }

    public long getTimeslotDuration() {
        return (long)this.timeslotLength * 60000L;
    }

    @ConfigurableValue(name="timeslotLength", description="length of timeslot in minutes sim time", valueType="Integer")
    @StateChange
    public Competition withTimeslotLength(int timeslotLength) {
        int n = timeslotLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timeslotLength = timeslotLength;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getMinimumTimeslotCount() {
        return this.minimumTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="minimum number of timeslots in simulation run")
    @StateChange
    public Competition withMinimumTimeslotCount(int minimumTimeslotCount) {
        int n = minimumTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.minimumTimeslotCount = minimumTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getExpectedTimeslotCount() {
        return this.expectedTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withExpectedTimeslotCount(int expectedTimeslotCount) {
        int n = expectedTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.expectedTimeslotCount = expectedTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Integer getFixedTimeslotCount() {
        return this.fixedTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="If given, overrides min and expected timeslot count values")
    @StateChange
    public Competition withFixedTimeslotCount(Integer fixedTimeslotCount) {
        Integer n = fixedTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)n);
        this.fixedTimeslotCount = fixedTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimeslotsOpen() {
        return this.timeslotsOpen;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withTimeslotsOpen(int timeslotsOpen) {
        int n = timeslotsOpen;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timeslotsOpen = timeslotsOpen;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getDeactivateTimeslotsAhead() {
        return this.deactivateTimeslotsAhead;
    }

    @ConfigurableValue(valueType="Integer", description="expected number of timeslots in simulation run")
    @StateChange
    public Competition withDeactivateTimeslotsAhead(int deactivateTimeslotsAhead) {
        int n = deactivateTimeslotsAhead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.deactivateTimeslotsAhead = deactivateTimeslotsAhead;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public double getMinimumOrderQuantity() {
        return this.minimumOrderQuantity;
    }

    public double getMaxUpRegulationPaymentRatio() {
        return this.maxUpRegulationPaymentRatio;
    }

    @ConfigurableValue(valueType="Double", description="Limit on up-regulation payment ratio")
    public Competition withMaxUpRegulationPaymentRatio(double value) {
        this.maxUpRegulationPaymentRatio = value;
        return this;
    }

    public double getUpRegulationDiscount() {
        return this.upRegulationDiscount;
    }

    @ConfigurableValue(valueType="Double", description="Discount rate on overpriced up-regulation")
    public Competition withUpRegulationDiscount(double value) {
        this.upRegulationDiscount = value;
        return this;
    }

    public double getMaxDownRegulationPaymentRatio() {
        return this.maxDownRegulationPaymentRatio;
    }

    @ConfigurableValue(valueType="Double", description="Limit on down-regulation payment")
    public Competition withMaxDownRegulationPaymentRatio(double value) {
        this.maxDownRegulationPaymentRatio = value;
        return this;
    }

    public double getDownRegulationDiscount() {
        return this.downRegulationDiscount;
    }

    @ConfigurableValue(valueType="Double", description="Discount rate on overpriced down-regulation")
    public Competition withDownRegulationDiscount(double value) {
        this.downRegulationDiscount = value;
        return this;
    }

    public double getEstimatedConsumptionPremium() {
        return this.estimatedConsumptionPremium;
    }

    @ConfigurableValue(valueType="Double", description="Estimated ratio of consumption prices over production prices")
    public Competition withEstimatedConsumptionPremium(double value) {
        this.estimatedConsumptionPremium = value;
        return this;
    }

    @ConfigurableValue(valueType="Double", description="Minimum order quantity in MWh")
    @StateChange
    public Competition withMinimumOrderQuantity(double minOrderQty) {
        double d = minOrderQty;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.minimumOrderQuantity = minOrderQty;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Instant getSimulationBaseTime() {
        return this.simulationBaseTime;
    }

    @ConfigurableValue(valueType="String", description="Scenario start time of the bootstrap portion of a simulation")
    public Competition withSimulationBaseTime(String baseTime) {
        Instant instant;
        try {
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            instant = fmt.parseDateTime(baseTime).toInstant();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            instant = new Instant(Long.parseLong(baseTime));
        }
        return this.withSimulationBaseTime(instant);
    }

    public Competition withSimulationBaseTime(Instant simulationBaseTime) {
        return this.withSimulationBaseTime(simulationBaseTime.getMillis());
    }

    @StateChange
    public Competition withSimulationBaseTime(long baseTime) {
        long l = baseTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationBaseTime = new Instant(baseTime);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @ConfigurableValue(valueType="Integer", description="Timezone offset from UTC for sim locale")
    @StateChange
    public Competition withTimezoneOffset(int offset) {
        int n = offset;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.timezoneOffset = offset;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getLatitude() {
        return this.latitude;
    }

    @ConfigurableValue(valueType="Integer", description="Approximate latitude of sim locale")
    @StateChange
    public Competition withLatitude(int latitude) {
        int n = latitude;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.latitude = latitude;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getBootstrapTimeslotCount() {
        return this.bootstrapTimeslotCount;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session during which data is collected")
    @StateChange
    public Competition withBootstrapTimeslotCount(int bootstrapTimeslotCount) {
        int n = bootstrapTimeslotCount;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.bootstrapTimeslotCount = bootstrapTimeslotCount;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getBootstrapDiscardedTimeslots() {
        return this.bootstrapDiscardedTimeslots;
    }

    @ConfigurableValue(valueType="Integer", description="Number of timeslots in bootstrap session that are discardedbefore data collection begins")
    @StateChange
    public Competition withBootstrapDiscardedTimeslots(int count) {
        int n = count;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.bootstrapDiscardedTimeslots = count;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public long getSimulationRate() {
        return this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    @StateChange
    public Competition withSimulationRate(long simulationRate) {
        long l = simulationRate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationRate = simulationRate;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public int getSimulationTimeslotSeconds() {
        return this.timeslotLength * 60 / (int)this.simulationRate;
    }

    @ConfigurableValue(valueType="Integer", description="Time compression ratio for simulation clock")
    public Competition withSimulationTimeslotSeconds(int seconds) {
        return this.withSimulationRate(this.timeslotLength * 60 / seconds);
    }

    public long getSimulationModulo() {
        return this.simulationModulo;
    }

    @ConfigurableValue(valueType="Long", description="Size, in milliseconds, of a simulation clock tick.Normally, this is the same as a timeslot.")
    @StateChange
    public Competition withSimulationModulo(long simulationModulo) {
        long l = simulationModulo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.simulationModulo = simulationModulo;
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public Map<String, Long> getClockParameters() {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        result.put("base", this.getSimulationBaseTime().getMillis());
        result.put("rate", this.getSimulationRate());
        result.put("modulo", this.getSimulationModulo());
        return result;
    }

    public List<String> getBrokers() {
        return this.brokers;
    }

    @StateChange
    public Competition addBroker(String brokerUsername) {
        String string = brokerUsername;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string);
        this.brokers.add(brokerUsername);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public List<CustomerInfo> getCustomers() {
        return this.customers;
    }

    @StateChange
    public Competition addCustomer(CustomerInfo customer) {
        CustomerInfo customerInfo = customer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)customerInfo);
        this.customers.add(customer);
        Competition competition = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return competition;
    }

    public void update(Competition template) {
        this.withBootstrapTimeslotCount(template.getBootstrapTimeslotCount());
        this.withDeactivateTimeslotsAhead(template.getDeactivateTimeslotsAhead());
        this.withSimulationBaseTime(template.getSimulationBaseTime());
        this.withBootstrapDiscardedTimeslots(template.getBootstrapDiscardedTimeslots());
        this.withSimulationModulo(template.getSimulationModulo());
        this.withTimeslotLength(template.getTimeslotLength());
        this.withTimeslotsOpen(template.getTimeslotsOpen());
    }

    public String toString() {
        return this.name;
    }

    static {
        Competition.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Competition.java", Competition.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("2", "org.powertac.common.Competition", "java.lang.String", "name", ""), 191);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDescription", "org.powertac.common.Competition", "java.lang.String", "description", "", "org.powertac.common.Competition"), 224);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationBaseTime", "org.powertac.common.Competition", "long", "baseTime", "", "org.powertac.common.Competition"), 555);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimezoneOffset", "org.powertac.common.Competition", "int", "offset", "", "org.powertac.common.Competition"), 575);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withLatitude", "org.powertac.common.Competition", "int", "latitude", "", "org.powertac.common.Competition"), 595);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withBootstrapTimeslotCount", "org.powertac.common.Competition", "int", "bootstrapTimeslotCount", "", "org.powertac.common.Competition"), 616);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withBootstrapDiscardedTimeslots", "org.powertac.common.Competition", "int", "count", "", "org.powertac.common.Competition"), 638);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationRate", "org.powertac.common.Competition", "long", "simulationRate", "", "org.powertac.common.Competition"), 659);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSimulationModulo", "org.powertac.common.Competition", "long", "simulationModulo", "", "org.powertac.common.Competition"), 706);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBroker", "org.powertac.common.Competition", "java.lang.String", "brokerUsername", "", "org.powertac.common.Competition"), 746);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addCustomer", "org.powertac.common.Competition", "org.powertac.common.CustomerInfo", "customer", "", "org.powertac.common.Competition"), 766);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPomId", "org.powertac.common.Competition", "java.lang.String", "id", "", "org.powertac.common.Competition"), 245);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotLength", "org.powertac.common.Competition", "int", "timeslotLength", "", "org.powertac.common.Competition"), 274);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinimumTimeslotCount", "org.powertac.common.Competition", "int", "minimumTimeslotCount", "", "org.powertac.common.Competition"), 295);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpectedTimeslotCount", "org.powertac.common.Competition", "int", "expectedTimeslotCount", "", "org.powertac.common.Competition"), 315);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withFixedTimeslotCount", "org.powertac.common.Competition", "java.lang.Integer", "fixedTimeslotCount", "", "org.powertac.common.Competition"), 336);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimeslotsOpen", "org.powertac.common.Competition", "int", "timeslotsOpen", "", "org.powertac.common.Competition"), 356);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDeactivateTimeslotsAhead", "org.powertac.common.Competition", "int", "deactivateTimeslotsAhead", "", "org.powertac.common.Competition"), 378);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinimumOrderQuantity", "org.powertac.common.Competition", "double", "minOrderQty", "", "org.powertac.common.Competition"), 500);
    }
}

