/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.MarketPosition;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
public class Broker {
    private long id;
    private String username;
    private String password;
    private String key;
    private String queueName;
    private boolean enabled;
    private boolean local;
    private int idPrefix;
    private boolean wholesale;
    private double cash;
    private HashMap<Integer, MarketPosition> mktPositions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public Broker(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        this.id = IdGenerator.createId();
        this.queueName = null;
        this.local = false;
        this.idPrefix = 0;
        this.wholesale = false;
        this.cash = 0.0;
        this.username = username;
        this.mktPositions = new HashMap();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Broker(String username, boolean local, boolean wholesale) {
        String string = username;
        boolean bl = local;
        boolean bl2 = wholesale;
        Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.queueName = null;
        this.local = false;
        this.idPrefix = 0;
        this.wholesale = false;
        this.cash = 0.0;
        this.username = username;
        this.mktPositions = new HashMap();
        this.local = local;
        this.wholesale = wholesale;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setIdPrefix(int prefix) {
        this.idPrefix = prefix;
    }

    public int getIdPrefix() {
        return this.idPrefix;
    }

    public void updateCash(double depositAmount) {
        this.cash += depositAmount;
    }

    public double getCashBalance() {
        return this.cash;
    }

    @StateChange
    public Broker addMarketPosition(MarketPosition posn, int slot) {
        MarketPosition marketPosition = posn;
        int n = slot;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)marketPosition, (Object)Conversions.intObject((int)n));
        this.mktPositions.put(slot, posn);
        Broker broker = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return broker;
    }

    @Deprecated
    public Broker addMarketPosition(MarketPosition posn, Timeslot slot) {
        return this.addMarketPosition(posn, slot.getSerialNumber());
    }

    public MarketPosition findMarketPositionByTimeslot(int slot) {
        MarketPosition posn = this.mktPositions.get(slot);
        if (posn == null) {
            posn = new MarketPosition(this, slot, 0.0);
            this.mktPositions.put(slot, posn);
        }
        return posn;
    }

    @Deprecated
    public MarketPosition findMarketPositionByTimeslot(Timeslot slot) {
        return this.findMarketPositionByTimeslot(slot.getSerialNumber());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public boolean isEnabled() {
        return this.enabled || this.isLocal() && this.isWholesale();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocal() {
        return this.local;
    }

    @StateChange
    public void setLocal(boolean value) {
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.local = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public boolean isWholesale() {
        return this.wholesale;
    }

    @StateChange
    public void setWholesale(boolean value) {
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.wholesale = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public String toString() {
        return this.username;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String toQueueName() {
        if (this.queueName != null) {
            return this.queueName;
        }
        return this.getUsername();
    }

    public void receiveMessage(Object object) {
    }

    static {
        Broker.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Broker.java", Broker.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Broker", "java.lang.String", "username", ""), 78);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Broker", "java.lang.String:boolean:boolean", "username:local:wholesale", ""), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addMarketPosition", "org.powertac.common.Broker", "org.powertac.common.MarketPosition:int", "posn:slot", "", "org.powertac.common.Broker"), 161);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLocal", "org.powertac.common.Broker", "boolean", "value", "", "void"), 247);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWholesale", "org.powertac.common.Broker", "boolean", "value", "", "void"), 262);
    }
}

