/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Rate;
import org.powertac.common.RateCore;
import org.powertac.common.RegulationRate;
import org.powertac.common.TariffMessage;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain(fields={"broker", "powerType", "expiration", "minDuration", "signupPayment", "earlyWithdrawPayment", "periodicPayment", "supersedes"})
@XStreamAlias(value="tariff-spec")
public class TariffSpecification
extends TariffMessage {
    private static Logger log;
    @XStreamAsAttribute
    private long expiration;
    @XStreamAsAttribute
    private long minDuration;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private double signupPayment;
    @XStreamAsAttribute
    private double earlyWithdrawPayment;
    @XStreamAsAttribute
    private double periodicPayment;
    private List<RateCore> rates;
    private List<Long> supersedes;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        TariffSpecification.ajc$preClinit();
        log = LogManager.getLogger(TariffSpecification.class);
    }

    public TariffSpecification(Broker broker, PowerType powerType) {
        super(broker);
        Broker broker2 = broker;
        PowerType powerType2 = powerType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)broker2, (Object)powerType2);
        this.expiration = 0L;
        this.minDuration = 0L;
        this.powerType = PowerType.CONSUMPTION;
        this.signupPayment = 0.0;
        this.earlyWithdrawPayment = 0.0;
        this.periodicPayment = 0.0;
        this.broker = broker;
        this.powerType = powerType;
        this.rates = new ArrayList<RateCore>();
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    public Instant getExpiration() {
        if (this.expiration > 0L) {
            return new Instant(this.expiration);
        }
        return null;
    }

    @StateChange
    public TariffSpecification withExpiration(long expiration) {
        long l = expiration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.expiration = expiration;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public TariffSpecification withExpiration(Instant expiration) {
        return this.withExpiration(expiration.getMillis());
    }

    public long getMinDuration() {
        return this.minDuration;
    }

    @StateChange
    public TariffSpecification withMinDuration(long minDuration) {
        long l = minDuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        this.minDuration = minDuration;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getSignupPayment() {
        return this.signupPayment;
    }

    @StateChange
    public TariffSpecification withSignupPayment(double signupPayment) {
        double d = signupPayment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.signupPayment = signupPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getEarlyWithdrawPayment() {
        return this.earlyWithdrawPayment;
    }

    @StateChange
    public TariffSpecification withEarlyWithdrawPayment(double earlyWithdrawPayment) {
        double d = earlyWithdrawPayment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.earlyWithdrawPayment = earlyWithdrawPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public double getPeriodicPayment() {
        return this.periodicPayment;
    }

    @StateChange
    public TariffSpecification withPeriodicPayment(double periodicPayment) {
        double d = periodicPayment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        this.periodicPayment = periodicPayment;
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Broker getBroker() {
        return this.broker;
    }

    public List<Rate> getRates() {
        ArrayList<Rate> result = new ArrayList<Rate>();
        if (this.rates == null) {
            log.error("Null rates tariff {}", (Object)this.getId());
            return result;
        }
        for (RateCore rate : this.rates) {
            if (!(rate instanceof Rate)) continue;
            result.add((Rate)rate);
        }
        return result;
    }

    public List<RegulationRate> getRegulationRates() {
        ArrayList<RegulationRate> result = new ArrayList<RegulationRate>();
        for (RateCore rate : this.rates) {
            if (!(rate instanceof RegulationRate)) continue;
            result.add((RegulationRate)rate);
        }
        return result;
    }

    public boolean hasRegulationRate() {
        for (RateCore rate : this.rates) {
            if (!(rate instanceof RegulationRate)) continue;
            return true;
        }
        return false;
    }

    @StateChange
    public TariffSpecification addRate(RateCore rate) {
        RateCore rateCore = rate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)((Object)rateCore));
        if (this.rates == null) {
            this.rates = new ArrayList<RateCore>();
        }
        this.rates.add(rate);
        rate.setTariffId(this.id);
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    public List<Long> getSupersedes() {
        return this.supersedes;
    }

    @StateChange
    public TariffSpecification addSupersedes(long specId) {
        long l = specId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        if (this.supersedes == null) {
            this.supersedes = new ArrayList<Long>();
        }
        this.supersedes.add(specId);
        TariffSpecification tariffSpecification = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return tariffSpecification;
    }

    @Override
    public boolean isValid() {
        if (this.getRates().size() == 0) {
            log.warn("invalid: no rates");
            return false;
        }
        for (Rate rate : this.getRates()) {
            if (rate.isValid(this)) continue;
            log.warn("invalid rate");
            return false;
        }
        if (this.minDuration < 0L) {
            log.warn("invalid: negative minDuration");
            return false;
        }
        return true;
    }

    public String toString() {
        return "TariffSpecification " + this.getId() + " " + this.getBroker().getUsername() + "." + this.getPowerType();
    }

    protected TariffSpecification() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        this.expiration = 0L;
        this.minDuration = 0L;
        this.powerType = PowerType.CONSUMPTION;
        this.signupPayment = 0.0;
        this.earlyWithdrawPayment = 0.0;
        this.periodicPayment = 0.0;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TariffSpecification.java", TariffSpecification.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.TariffSpecification", "org.powertac.common.Broker:org.powertac.common.enumerations.PowerType", "broker:powerType", ""), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpiration", "org.powertac.common.TariffSpecification", "long", "expiration", "", "org.powertac.common.TariffSpecification"), 125);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinDuration", "org.powertac.common.TariffSpecification", "long", "minDuration", "", "org.powertac.common.TariffSpecification"), 151);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withSignupPayment", "org.powertac.common.TariffSpecification", "double", "signupPayment", "", "org.powertac.common.TariffSpecification"), 167);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withEarlyWithdrawPayment", "org.powertac.common.TariffSpecification", "double", "earlyWithdrawPayment", "", "org.powertac.common.TariffSpecification"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPeriodicPayment", "org.powertac.common.TariffSpecification", "double", "periodicPayment", "", "org.powertac.common.TariffSpecification"), 200);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addRate", "org.powertac.common.TariffSpecification", "org.powertac.common.RateCore", "rate", "", "org.powertac.common.TariffSpecification"), 268);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addSupersedes", "org.powertac.common.TariffSpecification", "long", "specId", "", "org.powertac.common.TariffSpecification"), 290);
        ajc$tjp_8 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("4", "org.powertac.common.TariffSpecification", "", "", ""), 336);
    }
}

