/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import org.joda.time.Instant;
import org.powertac.common.RepeatingTimedAction;
import org.powertac.common.TimeService;
import org.powertac.common.TimedAction;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ManagedRepo
implements DomainRepo {
    @Autowired
    protected TimeService timeService;
    private boolean setupComplete = false;
    protected long interval = 43200000L;
    protected long offset = 10800000L;

    protected void setup() {
        Instant now = this.timeService.getCurrentTime();
        if (now == null) {
            this.setupComplete = false;
        } else if (!this.setupComplete) {
            RepeatingTimedAction rta = new RepeatingTimedAction(new TimedAction(){

                @Override
                public void perform(Instant time) {
                    ManagedRepo.this.doCleanup();
                }
            }, this.interval);
            this.timeService.addAction(this.timeService.getCurrentTime().plus(this.offset), rta);
            this.setupComplete = true;
        }
    }

    @Override
    public void recycle() {
        this.setupComplete = false;
    }

    protected abstract void doCleanup();
}

