/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.spring.SpringApplicationContext;

public class BrokerConverter
implements SingleValueConverter {
    private static Logger log = LogManager.getLogger((String)BrokerConverter.class.getName());
    private BrokerRepo brokerRepo;

    public boolean canConvert(Class type) {
        if (Broker.class.isAssignableFrom(type)) {
            return true;
        }
        log.info("BrokerConverter cannot convert " + type.getName());
        return false;
    }

    public Object fromString(String username) {
        if (this.brokerRepo == null) {
            this.brokerRepo = (BrokerRepo)SpringApplicationContext.getBean("brokerRepo");
        }
        if (this.brokerRepo == null) {
            log.warn("no autowire BrokerRepo - using singleton");
            this.brokerRepo = BrokerRepo.getInstance();
        }
        return this.brokerRepo.findOrCreateByUsername(username);
    }

    public String toString(Object broker) {
        return ((Broker)broker).getUsername();
    }
}

