/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyAuthenticator
extends Authenticator {
    private String username;
    private String password;

    public ProxyAuthenticator(boolean useSocks) {
        String proxyPort;
        String proxyHost;
        if (useSocks) {
            proxyHost = System.getProperty("socksProxyHost", "");
            proxyPort = System.getProperty("socksProxyPort", "");
            this.username = System.getProperty("java.net.socks.username", "");
            this.password = System.getProperty("java.net.socks.password", "");
        } else {
            proxyHost = System.getProperty("http.proxyHost", "");
            proxyPort = System.getProperty("http.proxyPort", "");
            this.username = System.getProperty("http.proxyUser", "");
            this.password = System.getProperty("http.proxyPassword", "");
        }
        if (!proxyHost.isEmpty()) {
            System.out.printf("\nConnecting via proxy %s:%s\n", proxyHost, proxyPort);
        }
        if (!this.username.isEmpty()) {
            System.out.printf("Username : %s\n\n", this.username);
            Authenticator.setDefault(this);
        }
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.username, this.password.toCharArray());
    }
}

