/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.IdGenerator;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.ChainedConstructor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;
import org.powertac.common.state.XStreamStateLoggable;
import org.powertac.common.xml.BrokerConverter;

@Domain(fields={"broker", "timeslot", "MWh", "limitPrice"})
@XStreamAlias(value="order")
public class Order
extends XStreamStateLoggable {
    private static Logger log;
    @XStreamAsAttribute
    private long id;
    @XStreamConverter(value=BrokerConverter.class)
    private Broker broker;
    @XStreamAsAttribute
    private int timeslot;
    @XStreamAsAttribute
    private double mWh;
    @XStreamAsAttribute
    private Double limitPrice;
    private static TimeslotRepo timeslotRepo;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Order.ajc$preClinit();
        log = LogManager.getLogger(Order.class);
    }

    public Order(Broker broker, int timeslot, double mWh, Double limitPrice) {
        Broker broker2 = broker;
        int n = timeslot;
        double d = mWh;
        Double d2 = limitPrice;
        Object[] objectArray = new Object[]{broker2, Conversions.intObject((int)n), Conversions.doubleObject((double)d), d2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        this.id = IdGenerator.createId();
        this.limitPrice = null;
        this.broker = broker;
        this.timeslot = timeslot;
        this.mWh = mWh;
        if (limitPrice != null && limitPrice.isNaN()) {
            log.error("Limit price is NaN");
            limitPrice = null;
        }
        this.limitPrice = limitPrice;
        double min = Competition.currentCompetition().getMinimumOrderQuantity();
        if (Math.abs(mWh) < min) {
            log.warn("Order quantity " + mWh + " < minimum order quantity " + min);
        }
        StateLogging.aspectOf().newstate(joinPoint);
    }

    @Deprecated
    @ChainedConstructor
    public Order(Broker broker, Timeslot timeslot, double mWh, Double limitPrice) {
        this(broker, timeslot.getSerialNumber(), mWh, limitPrice);
    }

    public long getId() {
        return this.id;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public int getTimeslotIndex() {
        return this.timeslot;
    }

    public Timeslot getTimeslot() {
        return Order.getTimeslotRepo().findBySerialNumber(this.timeslot);
    }

    public Double getMWh() {
        return this.mWh;
    }

    public Double getLimitPrice() {
        if (this.limitPrice == null || this.limitPrice.isNaN()) {
            return null;
        }
        return this.limitPrice;
    }

    public String toString() {
        return "Order " + this.id + " from " + this.broker.getUsername() + " for " + this.mWh + " mwh at " + this.limitPrice + " in ts " + this.timeslot;
    }

    protected Order() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        this.id = IdGenerator.createId();
        this.limitPrice = null;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    private static TimeslotRepo getTimeslotRepo() {
        if (timeslotRepo == null) {
            timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean("timeslotRepo");
        }
        return timeslotRepo;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Order.java", Order.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Order", "org.powertac.common.Broker:int:double:java.lang.Double", "broker:timeslot:mWh:limitPrice", ""), 98);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("4", "org.powertac.common.Order", "", "", ""), 181);
    }
}

