/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.powertac.common.HourlyCharge;
import org.powertac.common.IdGenerator;
import org.powertac.common.RateCore;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TimeService;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain(fields={"tariffId", "weeklyBegin", "weeklyEnd", "dailyBegin", "dailyEnd", "tierThreshold", "fixed", "minValue", "maxValue", "noticeInterval", "expectedMean", "maxCurtailment"})
@XStreamAlias(value="rate")
public class Rate
extends RateCore {
    private static Logger log;
    @XStreamOmitField
    final Level BFAULT;
    public static final int NO_TIME = -1;
    @XStreamAsAttribute
    private int weeklyBegin;
    @XStreamAsAttribute
    private int weeklyEnd;
    @XStreamAsAttribute
    private int dailyBegin;
    @XStreamAsAttribute
    private int dailyEnd;
    @XStreamAsAttribute
    private double tierThreshold;
    @XStreamAsAttribute
    private boolean fixed;
    @XStreamAsAttribute
    private double minValue;
    @XStreamAsAttribute
    private double maxValue;
    @XStreamAsAttribute
    private long noticeInterval;
    @XStreamAsAttribute
    private double expectedMean;
    @XStreamAsAttribute
    private double maxCurtailment;
    private TreeSet<HourlyCharge> rateHistory;
    @XStreamOmitField
    private ProbeCharge probe;
    @XStreamOmitField
    private TimeService timeService;
    static final int MIN_DAY = 1;
    static final int MAX_DAY = 7;
    static final int MIN_HOUR = 0;
    static final int MAX_HOUR = 23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        Rate.ajc$preClinit();
        log = LogManager.getLogger((String)Rate.class.getName());
    }

    public Rate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.BFAULT = Level.forName((String)"BFAULT", (int)250);
        this.weeklyBegin = -1;
        this.weeklyEnd = -1;
        this.dailyBegin = -1;
        this.dailyEnd = -1;
        this.tierThreshold = 0.0;
        this.fixed = true;
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.noticeInterval = 0L;
        this.expectedMean = 0.0;
        this.maxCurtailment = 0.0;
        this.timeService = null;
        this.rateHistory = new TreeSet();
        this.probe = new ProbeCharge(new Instant(0L), 0.0);
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Rate withWeeklyBegin(AbstractDateTime begin) {
        if (begin == null) {
            log.error("Null value for weeklyBegin");
            this.weeklyBegin = -1;
            return null;
        }
        return this.withWeeklyBegin(begin.getDayOfWeek());
    }

    public Rate withWeeklyBegin(ReadablePartial begin) {
        if (begin == null) {
            log.error("Null value for weeklyBegin");
            this.weeklyBegin = -1;
            return null;
        }
        return this.withWeeklyBegin(begin.get(DateTimeFieldType.dayOfWeek()));
    }

    @StateChange
    public Rate withWeeklyBegin(int begin) {
        Rate rate;
        int n = begin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (begin < 1 || begin > 7) {
            log.error("Invalid value {} for weeklyBegin", (Object)begin);
            this.weeklyBegin = -1;
            rate = null;
        } else {
            this.weeklyBegin = begin;
            rate = this;
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getWeeklyBegin() {
        return this.weeklyBegin;
    }

    public Rate withWeeklyEnd(AbstractDateTime end) {
        if (end == null) {
            log.error("Null value for weeklyEnd");
            this.weeklyEnd = -1;
        }
        return this.withWeeklyEnd(end.getDayOfWeek());
    }

    public Rate withWeeklyEnd(ReadablePartial end) {
        if (end != null) {
            return this.withWeeklyEnd(end.get(DateTimeFieldType.dayOfWeek()));
        }
        return this;
    }

    @StateChange
    public Rate withWeeklyEnd(int end) {
        Rate rate;
        int n = end;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (end < 1 || end > 7) {
            log.error("Invalid value {} for weeklyEnd", (Object)end);
            this.weeklyEnd = -1;
            rate = null;
        } else {
            this.weeklyEnd = end;
            rate = this;
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getWeeklyEnd() {
        return this.weeklyEnd;
    }

    public Rate withDailyBegin(AbstractDateTime begin) {
        if (begin == null) {
            log.error("Null value for dailyBegin");
            this.dailyBegin = -1;
            return null;
        }
        return this.withDailyBegin(begin.getHourOfDay());
    }

    public Rate withDailyBegin(ReadablePartial begin) {
        if (begin == null) {
            log.error("Null value for dailyBegin");
            this.dailyBegin = -1;
            return null;
        }
        return this.withDailyBegin(begin.get(DateTimeFieldType.hourOfDay()));
    }

    @StateChange
    public Rate withDailyBegin(int begin) {
        Rate rate;
        int n = begin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (begin < 0 || begin > 23) {
            log.error("invalid value {} for dailyBegin", (Object)begin);
            this.dailyBegin = -1;
            rate = null;
        } else {
            this.dailyBegin = begin;
            rate = this;
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getDailyBegin() {
        return this.dailyBegin;
    }

    public Rate withDailyEnd(AbstractDateTime end) {
        if (end == null) {
            log.error("Null value for dailyEnd");
            this.dailyEnd = -1;
            return null;
        }
        return this.withDailyEnd(end.getHourOfDay());
    }

    public Rate withDailyEnd(ReadablePartial end) {
        if (end == null) {
            log.error("Null value for dailyEnd");
            this.dailyEnd = -1;
            return null;
        }
        return this.withDailyEnd(end.get(DateTimeFieldType.hourOfDay()));
    }

    @StateChange
    public Rate withDailyEnd(int end) {
        Rate rate;
        int n = end;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        if (end < 0 | end > 23) {
            log.error("invalid value {} for dailyEnd", (Object)end);
            this.dailyEnd = -1;
            rate = null;
        } else {
            this.dailyEnd = end;
            rate = this;
        }
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public int getDailyEnd() {
        return this.dailyEnd;
    }

    public Rate withNoticeInterval(Duration interval) {
        return this.withNoticeInterval(interval.getMillis() / 3600000L);
    }

    @StateChange
    public Rate withNoticeInterval(long hours) {
        long l = hours;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        this.noticeInterval = hours;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public long getNoticeInterval() {
        return this.noticeInterval;
    }

    public boolean addHourlyCharge(HourlyCharge newCharge) {
        return this.addHourlyCharge(newCharge, false);
    }

    @StateChange
    public boolean addHourlyCharge(HourlyCharge newCharge, boolean publish) {
        HourlyCharge hourlyCharge = newCharge;
        boolean bl = publish;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)hourlyCharge, (Object)Conversions.booleanObject((boolean)bl));
        boolean result = false;
        if (this.fixed) {
            log.log(this.BFAULT, "Cannot change Rate " + this.toString());
        } else {
            Instant now = this.getCurrentTime();
            double sgn = Math.signum(this.maxValue);
            long warning = newCharge.getAtTime().getMillis() - now.getMillis();
            if (warning < this.noticeInterval * 3600000L && !publish) {
                log.warn("Too late (" + now.toString() + ") to change rate for " + newCharge.getAtTime().toString());
            } else if (sgn * newCharge.getValue() > sgn * this.maxValue) {
                log.warn("Excess charge: " + newCharge.getValue() + " > " + this.maxValue);
            } else if (sgn * newCharge.getValue() < sgn * this.minValue) {
                log.warn("Charge too low: " + newCharge.getValue() + " < " + this.minValue);
            } else {
                HourlyCharge item;
                if (this.probe == null) {
                    this.probe = new ProbeCharge(new Instant(0L), 0.0);
                }
                this.probe.setAtTime(newCharge.getAtTime().plus(1000L));
                SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
                if (head != null && head.size() > 0 && (item = head.last()).getAtTime() == newCharge.getAtTime()) {
                    log.debug("remove " + item.toString());
                    this.rateHistory.remove(item);
                }
                newCharge.setRateId(this.getId());
                this.rateHistory.add(newCharge);
                log.info("Adding HourlyCharge " + newCharge.getId() + " at " + newCharge.getAtTime() + " to " + this.toString());
                result = true;
            }
        }
        boolean bl2 = result;
        StateLogging.aspectOf().setstate(joinPoint);
        return bl2;
    }

    public double getTierThreshold() {
        return this.tierThreshold;
    }

    @StateChange
    public Rate withTierThreshold(double tierThreshold) {
        double d = tierThreshold;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.tierThreshold = tierThreshold;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMinValue() {
        return this.minValue;
    }

    @StateChange
    public Rate withMinValue(double minValue) {
        double d = minValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.minValue = minValue;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @StateChange
    public Rate withMaxValue(double maxValue) {
        double d = maxValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.maxValue = maxValue;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getMaxCurtailment() {
        return this.maxCurtailment;
    }

    @StateChange
    public Rate withMaxCurtailment(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.maxCurtailment = Math.min(1.0, Math.max(0.0, value));
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    @StateChange
    public Rate withFixed(boolean fixed) {
        boolean bl = fixed;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.booleanObject((boolean)bl));
        this.fixed = fixed;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public boolean isTimeOfUse() {
        return this.dailyBegin >= 0 || this.weeklyBegin >= 0;
    }

    public double getExpectedMean() {
        return this.expectedMean;
    }

    @StateChange
    public Rate withExpectedMean(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.expectedMean = value;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public TreeSet<HourlyCharge> getRateHistory() {
        return this.rateHistory;
    }

    public boolean applies() {
        return this.applies((AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(AbstractInstant when) {
        boolean appliesWeekly = false;
        boolean appliesDaily = false;
        DateTime time = new DateTime((Object)when, DateTimeZone.UTC);
        int day = time.getDayOfWeek();
        appliesWeekly = this.weeklyBegin == -1 || this.weeklyEnd == -1 ? true : (this.weeklyEnd >= this.weeklyBegin ? day >= this.weeklyBegin && day <= this.weeklyEnd : day >= this.weeklyBegin || day <= this.weeklyEnd);
        int hour = time.getHourOfDay();
        if (this.dailyBegin == -1 || this.dailyEnd == -1) {
            appliesDaily = true;
        } else if (this.dailyEnd > this.dailyBegin) {
            appliesDaily = hour >= this.dailyBegin && hour <= this.dailyEnd;
        } else {
            boolean bl = appliesDaily = hour >= this.dailyBegin || hour <= this.dailyEnd;
        }
        return appliesWeekly && appliesDaily;
    }

    public boolean applies(double usage) {
        return this.applies(usage, (AbstractInstant)this.getCurrentTime());
    }

    public boolean applies(double usage, AbstractInstant when) {
        if (usage >= this.tierThreshold) {
            return this.applies(when);
        }
        return false;
    }

    @StateChange
    public Rate withValue(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.minValue = value;
        Rate rate = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return rate;
    }

    public double getValue() {
        return this.getValue((AbstractInstant)this.getCurrentTime(), null);
    }

    public double getValue(AbstractInstant when) {
        return this.getValue(when, null);
    }

    public double getValue(AbstractInstant when, TariffEvaluationHelper helper) {
        if (this.fixed) {
            return this.minValue;
        }
        if (helper != null) {
            return helper.getWeightedValue(this);
        }
        if (this.rateHistory.size() == 0) {
            log.debug("no rate history, return default");
            return this.expectedMean;
        }
        if (this.probe == null) {
            this.probe = new ProbeCharge(new Instant(0L), 0.0);
        }
        Instant inst = new Instant((Object)when);
        this.probe.setAtTime(inst.plus(1000L));
        SortedSet<HourlyCharge> head = this.rateHistory.headSet(this.probe);
        if (head == null || head.size() == 0) {
            log.debug("No hourly charge found for " + when.getMillis() + ", returning default");
            return this.expectedMean;
        }
        HourlyCharge candidate = head.last();
        if (candidate.getAtTime().getMillis() == inst.getMillis()) {
            return candidate.getValue();
        }
        return this.expectedMean;
    }

    public boolean isValid(TariffSpecification spec) {
        return this.isValid(spec.getPowerType());
    }

    public boolean isValid(PowerType powerType) {
        double sgn;
        if (Double.isNaN(this.minValue) || Double.isNaN(this.maxValue) || Double.isNaN(this.expectedMean)) {
            log.log(this.BFAULT, "numeric insanity: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")");
            return false;
        }
        if (Double.isInfinite(this.minValue) || Double.isInfinite(this.maxValue) || Double.isInfinite(this.expectedMean)) {
            log.log(this.BFAULT, "Infinite value: (" + this.minValue + "," + this.maxValue + "," + this.expectedMean + ")");
            return false;
        }
        if (Double.isNaN(this.maxCurtailment) || this.maxCurtailment < 0.0 || this.maxCurtailment > 1.0) {
            log.log(this.BFAULT, "Curtailment ratio " + this.maxCurtailment + " out of range");
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || powerType.isConsumption() && this.tierThreshold < 0.0) {
            log.log(this.BFAULT, "Negative tier threshold for consumption rate");
            return false;
        }
        if (Double.isNaN(this.tierThreshold) || powerType.isProduction() && this.tierThreshold > 0.0) {
            log.log(this.BFAULT, "Positive tier threshold for production rate");
            return false;
        }
        if (this.dailyBegin != -1 && this.dailyBegin < 0 || this.dailyBegin > 23) {
            log.log(this.BFAULT, "dailyBegin out of range: {}", (Object)this.dailyBegin);
            return false;
        }
        if (this.dailyEnd != -1 && this.dailyEnd < 0 || this.dailyEnd > 23) {
            log.log(this.BFAULT, "dailyEnd out of range: {}", (Object)this.dailyEnd);
            return false;
        }
        if (this.weeklyBegin != -1 && this.weeklyBegin < 1 || this.weeklyBegin > 7) {
            log.log(this.BFAULT, "weeklyBegin out of range: {}", (Object)this.weeklyBegin);
            return false;
        }
        if (this.weeklyEnd != -1 && this.weeklyEnd < 1 || this.weeklyEnd > 7) {
            log.log(this.BFAULT, "weeklyEnd out of range: {}", (Object)this.weeklyEnd);
            return false;
        }
        if (this.dailyBegin != -1 && this.dailyEnd == -1 || this.dailyBegin == -1 && this.dailyEnd != -1) {
            log.log(this.BFAULT, "invalid daily begin/end values: {}, {}", (Object)this.dailyBegin, (Object)this.dailyEnd);
            return false;
        }
        if (this.weeklyBegin != -1 && this.weeklyEnd == -1 || this.weeklyBegin == -1 && this.weeklyEnd != -1) {
            log.log(this.BFAULT, "invalid weekly begin/end values: {}, {}", (Object)this.weeklyBegin, (Object)this.weeklyEnd);
            return false;
        }
        if (this.isFixed()) {
            return true;
        }
        double d = sgn = powerType.isConsumption() ? -1.0 : 1.0;
        if (sgn * this.maxValue < sgn * this.minValue) {
            log.warn("maxValue " + this.maxValue + " out of range");
            return false;
        }
        if (sgn * this.expectedMean < sgn * this.minValue || sgn * this.expectedMean > sgn * this.maxValue) {
            log.warn("expectedMean " + this.expectedMean + " out of range");
            return false;
        }
        if (this.noticeInterval < 0L) {
            log.log(this.BFAULT, "negative notice interval " + this.noticeInterval);
            return false;
        }
        return true;
    }

    public String toString() {
        String result = "Rate." + IdGenerator.getString(this.getId()) + ":";
        result = this.fixed ? String.valueOf(result) + " Fixed " + this.getMinValue() : String.valueOf(result) + " Variable";
        if (this.weeklyBegin >= 0) {
            result = String.valueOf(result) + ", " + (this.weeklyEnd >= 0 ? "starts " : "") + "day" + this.weeklyBegin;
            if (this.weeklyEnd >= 0) {
                result = String.valueOf(result) + " ends day " + this.weeklyEnd;
            }
        }
        if (this.dailyBegin >= 0) {
            result = String.valueOf(result) + ", " + this.dailyBegin + ":00 -- " + this.dailyEnd + ":00";
        }
        if (this.tierThreshold > 0.0) {
            result = String.valueOf(result) + ", usage > " + this.tierThreshold;
        }
        return result;
    }

    private Instant getCurrentTime() {
        if (this.timeService == null) {
            this.timeService = (TimeService)SpringApplicationContext.getBean("timeService");
        }
        return this.timeService.getCurrentTime();
    }

    void setTimeService(TimeService service) {
        this.timeService = service;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Rate.java", Rate.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.Rate", "", "", ""), 156);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWeeklyBegin", "org.powertac.common.Rate", "int", "begin", "", "org.powertac.common.Rate"), 198);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMaxCurtailment", "org.powertac.common.Rate", "double", "value", "", "org.powertac.common.Rate"), 515);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withFixed", "org.powertac.common.Rate", "boolean", "fixed", "", "org.powertac.common.Rate"), 530);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withExpectedMean", "org.powertac.common.Rate", "double", "value", "", "org.powertac.common.Rate"), 556);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withValue", "org.powertac.common.Rate", "double", "value", "", "org.powertac.common.Rate"), 647);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWeeklyEnd", "org.powertac.common.Rate", "int", "end", "", "org.powertac.common.Rate"), 246);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDailyBegin", "org.powertac.common.Rate", "int", "begin", "", "org.powertac.common.Rate"), 295);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDailyEnd", "org.powertac.common.Rate", "int", "end", "", "org.powertac.common.Rate"), 342);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withNoticeInterval", "org.powertac.common.Rate", "long", "hours", "", "org.powertac.common.Rate"), 373);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addHourlyCharge", "org.powertac.common.Rate", "org.powertac.common.HourlyCharge:boolean", "newCharge:publish", "", "boolean"), 402);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTierThreshold", "org.powertac.common.Rate", "double", "tierThreshold", "", "org.powertac.common.Rate"), 460);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinValue", "org.powertac.common.Rate", "double", "minValue", "", "org.powertac.common.Rate"), 477);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMaxValue", "org.powertac.common.Rate", "double", "maxValue", "", "org.powertac.common.Rate"), 494);
    }

    class ProbeCharge
    extends HourlyCharge {
        public ProbeCharge(Instant when, double charge) {
            super(when, charge);
        }

        void setAtTime(Instant when) {
            this.atTime = when;
        }
    }
}

