/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Orderbook;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.ManagedRepo;
import org.springframework.stereotype.Service;

@Service
public class OrderbookRepo
extends ManagedRepo {
    private static Logger log = LogManager.getLogger((String)OrderbookRepo.class.getName());
    private TreeMap<Timeslot, List<Orderbook>> orderbookIndex = new TreeMap();
    private TreeMap<Timeslot, Orderbook> timeslotIndex = new TreeMap();
    private TreeMap<Timeslot, Orderbook> spotIndex = new TreeMap();
    private Double[] minAskPrices;
    private Double[] maxAskPrices;
    private int lookback = 396;
    private int orderbookCount = 0;
    private int lastTimeslotSerial = 0;

    public Orderbook makeOrderbook(Timeslot timeslot, Double clearingPrice) {
        List<Orderbook> obList;
        this.setup();
        Orderbook result = new Orderbook(timeslot, clearingPrice, this.timeService.getCurrentTime());
        this.timeslotIndex.put(timeslot, result);
        if (clearingPrice != null) {
            this.spotIndex.put(timeslot, result);
        }
        if ((obList = this.orderbookIndex.get(timeslot)) == null) {
            obList = new ArrayList<Orderbook>();
            this.orderbookIndex.put(timeslot, obList);
        }
        obList.add(result);
        log.debug("Created new Orderbook ts=" + timeslot.getSerialNumber() + ", clearingPrice=" + clearingPrice);
        ++this.orderbookCount;
        if (timeslot.getSerialNumber() > this.lastTimeslotSerial) {
            this.lastTimeslotSerial = timeslot.getSerialNumber();
        }
        return result;
    }

    public Orderbook findByTimeslot(Timeslot timeslot) {
        return this.timeslotIndex.get(timeslot);
    }

    public Orderbook findSpotByTimeslot(Timeslot timeslot) {
        return this.spotIndex.get(timeslot);
    }

    public List<Orderbook> findAllByTimeslot(Timeslot timeslot) {
        return this.orderbookIndex.get(timeslot);
    }

    public void setMinAskPrices(Double[] values) {
        this.minAskPrices = values;
    }

    public void setMaxAskPrices(Double[] values) {
        this.maxAskPrices = values;
    }

    public Double[] getMinAskPrices() {
        return this.minAskPrices;
    }

    public Double[] getMaxAskPrices() {
        return this.maxAskPrices;
    }

    public int size() {
        return this.timeslotIndex.size();
    }

    @Override
    public void recycle() {
        this.orderbookIndex.clear();
        this.timeslotIndex.clear();
        this.spotIndex.clear();
        this.minAskPrices = null;
        this.maxAskPrices = null;
        this.orderbookCount = 0;
        super.recycle();
    }

    private void recordUsage() {
        log.debug("Orderbook count = {}", (Object)this.orderbookCount);
    }

    @Override
    protected void doCleanup() {
        if (this.orderbookIndex.size() > 0) {
            int oldest = this.lastTimeslotSerial - this.lookback;
            while (this.orderbookIndex.firstKey().getSerialNumber() < oldest) {
                Timeslot old = this.orderbookIndex.firstKey();
                List<Orderbook> books = this.orderbookIndex.remove(old);
                this.orderbookCount -= books.size();
                this.timeslotIndex.remove(old);
                this.spotIndex.remove(old);
            }
            this.recordUsage();
        }
    }

    int getOrderbookCount() {
        return this.orderbookCount;
    }
}

