/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;

@Domain
@XStreamAlias(value="cust-info")
public class CustomerInfo {
    private static Logger log;
    @XStreamAsAttribute
    private long id;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private int population;
    @XStreamAsAttribute
    private PowerType powerType;
    @XStreamAsAttribute
    private CustomerClass customerClass;
    @XStreamAsAttribute
    private double controllableKW;
    @XStreamAsAttribute
    private double upRegulationKW;
    @XStreamAsAttribute
    private double downRegulationKW;
    @XStreamAsAttribute
    private double storageCapacity;
    @XStreamAsAttribute
    private boolean multiContracting;
    @XStreamAsAttribute
    private boolean canNegotiate;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        CustomerInfo.ajc$preClinit();
        log = LogManager.getLogger((String)CustomerInfo.class.getName());
    }

    public CustomerInfo(String name, int population) {
        String string = name;
        int n = population;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        this.id = IdGenerator.createId();
        this.customerClass = CustomerClass.SMALL;
        this.controllableKW = 0.0;
        this.upRegulationKW = 0.0;
        this.downRegulationKW = 0.0;
        this.storageCapacity = 0.0;
        this.multiContracting = false;
        this.canNegotiate = false;
        this.powerType = PowerType.CONSUMPTION;
        this.name = name;
        this.population = population;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPopulation() {
        return this.population;
    }

    @StateChange
    public void setPopulation(Integer population) {
        Integer n = population;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)n);
        this.population = population;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public PowerType getPowerType() {
        return this.powerType;
    }

    @StateChange
    public CustomerInfo withPowerType(PowerType type) {
        PowerType powerType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)powerType);
        this.powerType = type;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public CustomerClass getCustomerClass() {
        return this.customerClass;
    }

    @StateChange
    public CustomerInfo withCustomerClass(CustomerClass cClass) {
        CustomerClass customerClass = cClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)customerClass));
        this.customerClass = cClass;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isMultiContracting() {
        return this.multiContracting;
    }

    @StateChange
    public CustomerInfo withMultiContracting(boolean value) {
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.multiContracting = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public boolean isCanNegotiate() {
        return this.canNegotiate;
    }

    @StateChange
    public CustomerInfo withCanNegotiate(boolean value) {
        boolean bl = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.canNegotiate = value;
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getControllableKW() {
        return this.controllableKW;
    }

    @Deprecated
    public double getControllableKWh() {
        return this.controllableKW;
    }

    @StateChange
    public CustomerInfo withControllableKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        if (value > 0.0) {
            log.error(String.valueOf(this.getName()) + ": controllableKW " + value + " must be non-positive");
        } else {
            this.controllableKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getUpRegulationKW() {
        return this.upRegulationKW;
    }

    @StateChange
    public CustomerInfo withUpRegulationKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        if (value > 0.0) {
            log.error(String.valueOf(this.getName()) + ": upRegulationKW " + value + " must be non-positive");
        } else {
            this.upRegulationKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getDownRegulationKW() {
        return this.downRegulationKW;
    }

    @StateChange
    public CustomerInfo withDownRegulationKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        if (value < 0.0) {
            log.error(String.valueOf(this.getName()) + ": downRegulationKW " + value + " must be non-negative");
        } else {
            this.downRegulationKW = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public double getStorageCapacity() {
        return this.storageCapacity;
    }

    @StateChange
    public CustomerInfo withStorageCapacity(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        if (value < 0.0) {
            log.error(String.valueOf(this.getName()) + ": storageCapacity " + value + " must be non-negative");
        } else {
            this.storageCapacity = value;
        }
        CustomerInfo customerInfo = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return customerInfo;
    }

    public String toString() {
        return "CustomerInfo(" + this.name + ")";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CustomerInfo.java", CustomerInfo.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.CustomerInfo", "java.lang.String:int", "name:population", ""), 92);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPopulation", "org.powertac.common.CustomerInfo", "java.lang.Integer", "population", "", "void"), 130);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withPowerType", "org.powertac.common.CustomerInfo", "org.powertac.common.enumerations.PowerType", "type", "", "org.powertac.common.CustomerInfo"), 149);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withCustomerClass", "org.powertac.common.CustomerInfo", "org.powertac.common.CustomerInfo$CustomerClass", "cClass", "", "org.powertac.common.CustomerInfo"), 169);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMultiContracting", "org.powertac.common.CustomerInfo", "boolean", "value", "", "org.powertac.common.CustomerInfo"), 190);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withCanNegotiate", "org.powertac.common.CustomerInfo", "boolean", "value", "", "org.powertac.common.CustomerInfo"), 210);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withControllableKW", "org.powertac.common.CustomerInfo", "double", "value", "", "org.powertac.common.CustomerInfo"), 243);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withUpRegulationKW", "org.powertac.common.CustomerInfo", "double", "value", "", "org.powertac.common.CustomerInfo"), 270);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withDownRegulationKW", "org.powertac.common.CustomerInfo", "double", "value", "", "org.powertac.common.CustomerInfo"), 297);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withStorageCapacity", "org.powertac.common.CustomerInfo", "double", "value", "", "org.powertac.common.CustomerInfo"), 322);
    }

    public static enum CustomerClass {
        SMALL,
        LARGE;

    }
}

