/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.msg;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.powertac.common.IdGenerator;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;
import org.powertac.common.xml.DoubleArrayConverter;

@Domain
@XStreamAlias(value="market-bootstrap-data")
public class MarketBootstrapData {
    private static Logger log;
    @XStreamAsAttribute
    private long id;
    @XStreamConverter(value=DoubleArrayConverter.class)
    private double[] mwh;
    @XStreamConverter(value=DoubleArrayConverter.class)
    private double[] marketPrice;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        MarketBootstrapData.ajc$preClinit();
        log = LogManager.getLogger((String)MarketBootstrapData.class.getName());
    }

    public MarketBootstrapData(double[] mwh, double[] price) {
        double[] dArray = mwh;
        double[] dArray2 = price;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)dArray, (Object)dArray2);
        this.id = IdGenerator.createId();
        this.mwh = mwh;
        this.marketPrice = price;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public long getId() {
        return this.id;
    }

    public double[] getMwh() {
        return this.mwh;
    }

    public double[] getMarketPrice() {
        return this.marketPrice;
    }

    public double getMeanMarketPrice() {
        if (this.mwh.length != this.marketPrice.length) {
            log.error("mwh array size {} != price array size {}", (Object)this.mwh.length, (Object)this.marketPrice.length);
            return 0.0;
        }
        double energy = 0.0;
        double cost = 0.0;
        int i = 0;
        while (i < this.mwh.length) {
            energy += this.mwh[i];
            cost += this.mwh[i] * this.marketPrice[i];
            ++i;
        }
        return cost / energy;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MarketBootstrapData.java", MarketBootstrapData.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.common.msg.MarketBootstrapData", "[D:[D", "mwh:price", ""), 50);
    }
}

