/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.util;

import java.util.AbstractList;
import java.util.List;

public class RingArray<T> {
    private Object[] data;
    private int size = 0;
    private int maxIndex = 0;

    public RingArray(int size) {
        this.size = size;
        this.data = new Object[size];
        this.clear();
    }

    public void clear() {
        int i = 0;
        while (i < this.size) {
            this.data[i] = null;
            ++i;
        }
        this.maxIndex = 0;
    }

    public void clean(int startIndex) {
        int i = this.maxIndex + 1;
        while (i < startIndex + this.size) {
            this.data[i % this.size] = null;
            ++i;
        }
    }

    public int getActiveLength(int startIndex) {
        return this.maxIndex - startIndex + 1;
    }

    public void set(int index, T element) {
        if (index > this.maxIndex - this.size) {
            this.data[index % this.size] = element;
            this.maxIndex = Math.max(this.maxIndex, index);
        }
    }

    public T get(int index) {
        if (index > this.maxIndex || index <= this.maxIndex - this.size) {
            return null;
        }
        return (T)this.data[index % this.size];
    }

    public T[] getActiveArray(int startIndex) {
        int len = this.getActiveLength(startIndex);
        if (len <= 0) {
            return null;
        }
        Object[] result = new Object[len];
        int i = 0;
        while (i < len) {
            result[i] = this.data[(startIndex + i) % this.size];
            ++i;
        }
        return result;
    }

    public List<T> asList(int start) {
        return new RaList(start);
    }

    class RaList<T>
    extends AbstractList<T> {
        private int start = 0;
        private RingArray<T> ring;

        RaList(int startIndex) {
            this.ring = RingArray.this;
            this.start = startIndex;
        }

        @Override
        public T get(int index) {
            return this.ring.get(index + this.start);
        }

        @Override
        public int size() {
            return this.ring.maxIndex - this.start + 1;
        }
    }
}

