/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer;

import java.util.List;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.WeatherReportRepo;

@ConfigurableInstance
public abstract class AbstractCustomer
implements CustomerModelAccessor {
    protected String name = "dummy";
    protected CustomerInfo customerInfo;
    protected WeatherReportRepo weatherReportRepo;
    protected RandomSeedRepo randomSeedRepo;
    protected TariffRepo tariffRepo;
    protected TariffSubscriptionRepo tariffSubscriptionRepo;

    public AbstractCustomer() {
    }

    public AbstractCustomer(String name) {
        this.name = name;
        this.customerInfo = new CustomerInfo(name, 1);
    }

    public void setServices(RandomSeedRepo randomSeedRepo, WeatherReportRepo weatherReportRepo, TariffRepo tariffRepo, TariffSubscriptionRepo tariffSubscriptionRepo) {
        this.randomSeedRepo = randomSeedRepo;
        this.weatherReportRepo = weatherReportRepo;
        this.tariffRepo = tariffRepo;
        this.tariffSubscriptionRepo = tariffSubscriptionRepo;
    }

    public void initialize() {
    }

    public abstract void step();

    public abstract void evaluateTariffs(List<Tariff> var1);

    public String getName() {
        return this.name;
    }

    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    @ConfigurableValue(valueType="String", description="instance name - required")
    public void setName(String name) {
        this.name = name;
    }

    public List<TariffSubscription> getCurrentSubscriptions() {
        return this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(this.getCustomerInfo());
    }
}

