/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.coldstorage;

import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.customer.AbstractCustomer;

@Domain
@ConfigurableInstance
public class ColdStorage
extends AbstractCustomer {
    private static Logger log = Logger.getLogger((String)ColdStorage.class.getName());
    static final double R_CONVERSION = 0.0031545;
    static final double TON_CONVERSION = 3.504;
    static final double CP_ICE = 0.564;
    static final double GROUND_TEMP = 3.0;
    private double minTemp = -35.0;
    private double maxTemp = -10.0;
    private double nominalTemp = -20.0;
    private double roofArea = 900.0;
    private double roofRValue = 40.0;
    private double wallArea = 1440.0;
    private double wallRValue = 22.0;
    private double floorRValue = 15.0;
    private double infiltrationRatio = 0.5;
    private double cop = 1.5;
    private double stockCapacity = 500.0;
    private double turnoverRatio = 0.1;
    private double turnoverSd = 0.015;
    private double newStockTemp = -5.0;
    private double nonCoolingUsage = 15.0;
    private double ncUsageVariability = 0.2;
    private double ncMeanReversion = 0.06;
    private double unitSize = 40.0;
    private double hysteresis = 0.04;
    private RandomSeed opSeed;
    private NormalDistribution normal01;
    private RandomSeed evalSeed;
    private double totalEnergyUsed = 0.0;
    private double currentNcUsage;
    private double coolingLossPerK = 0.0;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="current temperature")
    private Double currentTemp = null;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="current thermal mass")
    private double currentStock = 0.0;
    private TariffEvaluator tariffEvaluator;
    private int profileSize = 14;

    public ColdStorage() {
    }

    public ColdStorage(String name) {
        super(name);
    }

    @Override
    public void initialize() {
        log.info((Object)("Initialize " + this.name));
        this.getCustomerInfo().withPowerType(PowerType.THERMAL_STORAGE_CONSUMPTION).withControllableKW(-this.unitSize / this.cop).withStorageCapacity(this.stockCapacity * 0.564 * (this.maxTemp - this.minTemp)).withUpRegulationKW(-this.unitSize / this.cop).withDownRegulationKW(this.unitSize / this.cop);
        this.ensureSeeds();
        if (null == this.currentTemp) {
            this.setCurrentTemp(this.minTemp + (this.maxTemp - this.minTemp) * this.opSeed.nextDouble());
            this.currentStock = this.stockCapacity;
        }
        this.currentNcUsage = this.nonCoolingUsage;
        this.tariffEvaluator = new TariffEvaluator((CustomerModelAccessor)this);
        this.tariffEvaluator.withInertia(0.7).withPreferredContractDuration(14.0);
        this.tariffEvaluator.initializeInconvenienceFactors(0.0, 0.01, 0.0, 0.0);
        this.tariffEvaluator.initializeRegulationFactors(-this.unitSize * 3.504 * 0.05, 0.0, this.unitSize * 3.504 * 0.04);
    }

    private void ensureSeeds() {
        if (null == this.opSeed) {
            this.opSeed = this.randomSeedRepo.getRandomSeed(ColdStorage.class.getName() + "-" + this.name, 0L, "model");
            this.evalSeed = this.randomSeedRepo.getRandomSeed(ColdStorage.class.getName() + "-" + this.name, 0L, "eval");
            this.normal01 = new NormalDistribution(0.0, 1.0);
            this.normal01.reseedRandomGenerator(this.opSeed.nextLong());
        }
    }

    @Override
    public void step() {
        this.totalEnergyUsed = 0.0;
        double regulation = this.getSubscription().getRegulation();
        if (regulation != 0.0) {
            double tempChange = regulation * this.cop / this.currentStock / 0.564;
            log.info((Object)(this.getName() + ": regulation = " + regulation + ", tempChange = " + tempChange));
            this.currentTemp = this.currentTemp + tempChange;
        }
        this.currentTemp = this.currentTemp + this.turnoverRise();
        this.updateNcUsage();
        this.useEnergy(this.currentNcUsage);
        WeatherReport weather = this.weatherReportRepo.currentWeatherReport();
        double outsideTemp = weather.getTemperature();
        double energyNeeded = this.computeCoolingEnergy(outsideTemp, this.unitSize * 3.504);
        double availableUp = energyNeeded / this.cop;
        if (this.currentTemp >= this.maxTemp) {
            availableUp = 0.0;
        }
        double availableDown = -(this.unitSize * 3.504 - energyNeeded) / this.cop;
        if (this.currentTemp <= this.minTemp) {
            availableDown = 0.0;
        }
        RegulationCapacity capacity = new RegulationCapacity(availableUp, availableDown);
        this.getSubscription().setRegulationCapacity(capacity);
        log.info((Object)(this.getName() + ": regulation capacity (" + capacity.getUpRegulationCapacity() + ", " + capacity.getDownRegulationCapacity() + ")"));
        this.useEnergy(energyNeeded / this.cop);
        log.debug((Object)("total energy = " + this.totalEnergyUsed));
        this.getSubscription().usePower(this.totalEnergyUsed);
    }

    private TariffSubscription getSubscription() {
        List<TariffSubscription> subs = this.getCurrentSubscriptions();
        if (subs.size() > 1) {
            log.warn((Object)("Multiple subscriptions " + subs.size() + " for " + this.getName()));
        }
        return subs.get(0);
    }

    double computeCoolingEnergy(double outsideTemp, double maxAvail) {
        double coolingLoss = this.computeCoolingLoss(outsideTemp);
        double adjustmentCooling = 0.0;
        if (this.getCurrentTemp() < this.getNominalTemp() - this.hysteresis / 2.0) {
            double maxWarming = coolingLoss;
            double neededWarming = this.currentStock * 0.564 * (this.getNominalTemp() - this.getCurrentTemp());
            adjustmentCooling = -Math.min(maxWarming, neededWarming);
        } else if (this.getCurrentTemp() > this.getNominalTemp() + this.hysteresis / 2.0) {
            double maxCooling = maxAvail - coolingLoss;
            double neededCooling = this.currentStock * 0.564 * (this.getCurrentTemp() - this.getNominalTemp());
            adjustmentCooling = Math.min(neededCooling, maxCooling);
        }
        this.currentTemp = this.currentTemp - adjustmentCooling / (this.currentStock * 0.564);
        double energyNeeded = coolingLoss + adjustmentCooling;
        log.info((Object)(this.getName() + ": temp = " + this.currentTemp + ", adjustmentCooling = " + adjustmentCooling + ", total cooling energy = " + energyNeeded + ", temp change = " + -adjustmentCooling / (this.currentStock * 0.564)));
        return energyNeeded;
    }

    double turnoverRise() {
        double turnoverMean = this.turnoverRatio * this.stockCapacity / 24.0;
        double sd = this.turnoverSd * this.stockCapacity / 24.0;
        double outgoing = Math.max(0.0, this.normal01.sample() * sd + turnoverMean);
        double incoming = Math.max(0.0, this.normal01.sample() * sd + turnoverMean);
        this.currentStock -= outgoing;
        double newStock = incoming;
        double newTemp = (this.currentStock * this.currentTemp + newStock * this.newStockTemp) / (this.currentStock + newStock);
        log.info((Object)(this.getName() + ": remove " + outgoing + "T, add " + incoming + "T raises temp " + (newTemp - this.currentTemp) + "K"));
        this.currentStock += incoming;
        return newTemp - this.currentTemp;
    }

    void updateNcUsage() {
        if (this.ncUsageVariability == 0.0) {
            return;
        }
        this.currentNcUsage = this.currentNcUsage + this.nonCoolingUsage * (this.ncUsageVariability * (this.opSeed.nextDouble() * 2.0 - 1.0)) + this.ncMeanReversion * (this.nonCoolingUsage - this.currentNcUsage);
        this.currentNcUsage = Math.max(0.0, this.currentNcUsage);
        log.info((Object)(this.getName() + ": Non-cooling usage = " + this.currentNcUsage));
    }

    double computeCoolingLoss(double outsideTemp) {
        double upperLoss = this.getCoolingLossPerK() * (outsideTemp - this.currentTemp);
        double floorLoss = 0.0031545 / this.getFloorRValue() * this.getRoofArea() * (3.0 - this.currentTemp);
        log.info((Object)(this.getName() + ": heat loss walls & roof: " + upperLoss + ", floor: " + floorLoss + ", heat load: " + this.currentNcUsage));
        return upperLoss + floorLoss + this.currentNcUsage;
    }

    double getCoolingLossPerK() {
        if (0.0 == this.coolingLossPerK) {
            double roofLoss = 0.0031545 / this.getRoofRValue() * this.getRoofArea();
            double wallLoss = 0.0031545 / this.getWallRValue() * this.getWallArea();
            double infiltrationLoss = this.getInfiltrationRatio() * (roofLoss + wallLoss);
            log.debug((Object)(": Heat loss per K -- roof: " + roofLoss + ", walls: " + wallLoss + ", infiltration: " + infiltrationLoss));
            this.coolingLossPerK = roofLoss + wallLoss + infiltrationLoss;
        }
        return this.coolingLossPerK;
    }

    @Override
    public void evaluateTariffs(List<Tariff> tariffs) {
        log.info((Object)(this.getName() + ": evaluate tariffs"));
        this.tariffEvaluator.evaluateTariffs();
    }

    public double[] getCapacityProfile(Tariff tariff) {
        List weather = this.weatherReportRepo.allWeatherReports();
        int offset = weather.size() >= this.profileSize ? weather.size() - this.profileSize : 0;
        double[] result = new double[this.profileSize];
        for (int i = 0; i < this.profileSize; ++i) {
            int wi = i + offset;
            double temperature = weather.size() > wi ? ((WeatherReport)weather.get(wi)).getTemperature() : 18.0;
            double cooling = this.computeCoolingEnergy(temperature, this.unitSize * 3.504);
            result[i] = cooling / this.cop + this.nonCoolingUsage;
        }
        return result;
    }

    public double getBrokerSwitchFactor(boolean isSuperseding) {
        if (isSuperseding) {
            return 0.0;
        }
        return 0.02;
    }

    public double getTariffChoiceSample() {
        return this.evalSeed.nextDouble();
    }

    public double getInertiaSample() {
        return this.evalSeed.nextDouble();
    }

    public double getCurrentTemp() {
        return this.currentTemp;
    }

    void setCurrentTemp(double temp) {
        this.currentTemp = temp;
    }

    void useEnergy(double kWh) {
        this.totalEnergyUsed += kWh;
    }

    double getCurrentNcUsage() {
        return this.currentNcUsage;
    }

    public double getMinTemp() {
        return this.minTemp;
    }

    @ConfigurableValue(valueType="Double", description="minimum allowable temperature")
    @StateChange
    public ColdStorage withMinTemp(double temp) {
        this.minTemp = temp;
        return this;
    }

    public double getMaxTemp() {
        return this.maxTemp;
    }

    @ConfigurableValue(valueType="Double", description="maximum allowable temperature")
    @StateChange
    public ColdStorage withMaxTemp(double temp) {
        this.maxTemp = temp;
        return this;
    }

    public double getNominalTemp() {
        return this.nominalTemp;
    }

    @ConfigurableValue(valueType="Double", description="nominal internal temperature")
    @StateChange
    public ColdStorage withNominalTemp(double temp) {
        this.maxTemp = temp;
        return this;
    }

    public double getNewStockTemp() {
        return this.newStockTemp;
    }

    @ConfigurableValue(valueType="Double", description="Temperature of incoming stock")
    @StateChange
    public ColdStorage withNewStockTemp(double temp) {
        this.newStockTemp = temp;
        return this;
    }

    public double getStockCapacity() {
        return this.stockCapacity;
    }

    @ConfigurableValue(valueType="Double", description="Typical inventory in tonnes of H2O")
    @StateChange
    public ColdStorage withStockCapacity(double value) {
        if (value < 0.0) {
            log.error((Object)(this.getName() + ": Negative stock capacity " + value + " not allowed"));
        } else {
            this.stockCapacity = value;
        }
        return this;
    }

    public double getTurnoverRatio() {
        return this.turnoverRatio;
    }

    @ConfigurableValue(valueType="Double", description="Ratio of stock that gets replaced daily")
    @StateChange
    public ColdStorage withTurnoverRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            log.error((Object)(this.getName() + ": turnover ratio " + ratio + " out of range"));
        } else {
            this.turnoverRatio = ratio;
        }
        return this;
    }

    public double getRoofArea() {
        return this.roofArea;
    }

    @ConfigurableValue(valueType="Double", description="Area of roof")
    @StateChange
    public ColdStorage withRoofArea(double area) {
        this.roofArea = area;
        return this;
    }

    public double getRoofRValue() {
        return this.roofRValue;
    }

    @ConfigurableValue(valueType="Double", description="R-value of roof insulation")
    @StateChange
    public ColdStorage withRoofRValue(double value) {
        this.roofRValue = value;
        return this;
    }

    public double getWallArea() {
        return this.wallArea;
    }

    @ConfigurableValue(valueType="Double", description="Total area of outside walls")
    @StateChange
    public ColdStorage withWallArea(double area) {
        this.wallArea = area;
        return this;
    }

    public double getWallRValue() {
        return this.wallRValue;
    }

    @ConfigurableValue(valueType="Double", description="R-value of wall insulation")
    @StateChange
    public ColdStorage withWallRValue(double value) {
        this.wallRValue = value;
        return this;
    }

    public double getFloorRValue() {
        return this.floorRValue;
    }

    @ConfigurableValue(valueType="Double", description="R-value of floor insulation")
    @StateChange
    public ColdStorage withFloorRValue(double value) {
        this.floorRValue = value;
        return this;
    }

    public double getInfiltrationRatio() {
        return this.infiltrationRatio;
    }

    @ConfigurableValue(valueType="Double", description="Infiltration loss as proportion of wall + roof loss")
    @StateChange
    public ColdStorage withInfiltrationRatio(double value) {
        if (value < 0.0) {
            log.error((Object)(this.getName() + ": Infiltration ratio " + value + " cannot be negative"));
        } else {
            this.infiltrationRatio = value;
        }
        return this;
    }

    public double getUnitSize() {
        return this.unitSize;
    }

    @ConfigurableValue(valueType="Double", description="Thermal capacity in tons of cooling plant")
    @StateChange
    public ColdStorage withUnitSize(double cap) {
        if (cap < 0.0) {
            log.error((Object)(this.getName() + ": Cooling capacity " + cap + " cannot be negative"));
        } else {
            this.unitSize = cap;
        }
        return this;
    }

    public double getCop() {
        return this.cop;
    }

    @ConfigurableValue(valueType="Double", description="Coefficient of Performance of refrigeration unit")
    @StateChange
    public ColdStorage withCop(double value) {
        if (value < 0.0) {
            log.error((Object)(this.getName() + ": Coefficient of performance " + value + " cannot be negative"));
        } else {
            this.cop = value;
        }
        return this;
    }

    public double getHysteresis() {
        return this.hysteresis;
    }

    @ConfigurableValue(valueType="Double", description="Control range for refrigeration unit")
    @StateChange
    public ColdStorage withHysteresis(double value) {
        if (value < 0.0) {
            log.error((Object)(this.getName() + ": Hysteresis " + value + " cannot be negative"));
        } else {
            this.hysteresis = value;
        }
        return this;
    }

    public double getNonCoolingUsage() {
        return this.nonCoolingUsage;
    }

    @ConfigurableValue(valueType="Double", description="Mean hourly energy usage for non-cooling purposes")
    @StateChange
    public ColdStorage withNonCoolingUsage(double value) {
        if (value < 0.0) {
            log.error((Object)(this.getName() + ": Non-cooling usage " + value + " cannot be negative"));
        } else {
            this.nonCoolingUsage = value;
        }
        return this;
    }
}

