/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.spring.SpringApplicationContext;

public class ModelBuilder {
    private static Logger log = Logger.getLogger((String)ModelBuilder.class.getName());
    private static ModelBuilder instance = null;
    private ServerConfiguration serverConfiguration;
    @ConfigurableValue(valueType="List", description="classnames of bean types to be configured")
    private List<String> beanTypes;
    private Map<String, Collection<?>> beans;

    private ModelBuilder() {
    }

    public void configure() {
        if (this.serverConfiguration == null) {
            this.serverConfiguration = (ServerConfiguration)SpringApplicationContext.getBean("serverPropertiesService");
        }
        if (this.serverConfiguration == null) {
            log.warn((Object)"Cannot find serverPropertiesService");
        } else {
            this.serverConfiguration.configureMe((Object)this);
        }
    }

    public Map<String, Collection<?>> getBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        this.configure();
        this.beans = new HashMap();
        for (String classname : this.beanTypes) {
            try {
                Class<?> clazz = Class.forName("org.powertac.customer.model." + classname);
                Collection list = this.serverConfiguration.configureInstances(clazz);
                this.beans.put(classname, list);
                log.info((Object)("Loaded " + list.size() + " instances of " + classname));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)("Cannot find class " + classname));
            }
        }
        return this.beans;
    }

    public static synchronized ModelBuilder getInstance() {
        if (instance == null) {
            instance = new ModelBuilder();
            instance.configure();
        }
        return instance;
    }

    public static synchronized void recycle() {
        instance = null;
    }
}

