/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.coldstorage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Instant;
import org.powertac.common.CapacityProfile;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.customer.AbstractCustomer;

@Domain
@ConfigurableInstance
public class ColdStorage
extends AbstractCustomer
implements CustomerModelAccessor {
    private static Logger log;
    static final double R_CONVERSION = 0.0031545;
    static final double TON_CONVERSION = 3.504;
    static final double CP_ICE = 0.564;
    static final double GROUND_TEMP = 3.0;
    private double minTemp;
    private double maxTemp;
    private double nominalTemp;
    private double shiftSag;
    private double evalEnvTemp;
    private double roofArea;
    private double roofRValue;
    private double wallArea;
    private double wallRValue;
    private double floorRValue;
    private double infiltrationRatio;
    private double cop;
    private double stockCapacity;
    private double turnoverRatio;
    private double turnoverSd;
    private double newStockTemp;
    private double nonCoolingUsage;
    private double ncUsageVariability;
    private double ncMeanReversion;
    private double unitSize;
    private double hysteresis;
    private PowerType powerType;
    private RandomSeed opSeed;
    private NormalDistribution normal01;
    private RandomSeed evalSeed;
    private double totalEnergyUsed;
    private double currentNcUsage;
    private double coolingLossPerK;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="current temperature")
    private Double currentTemp;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="current thermal mass")
    private double currentStock;
    private TariffEvaluator tariffEvaluator;
    private int profileSize;
    private Map<Tariff, TariffInfo> TariffProfiles;
    double nominalHourlyConsumption;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    static {
        Factory factory = new Factory("ColdStorage.java", Class.forName("org.powertac.customer.coldstorage.ColdStorage"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.coldstorage.ColdStorage", "", "", ""), 122);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.coldstorage.ColdStorage", "java.lang.String:", "name:", ""), 130);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTurnoverRatio", "org.powertac.customer.coldstorage.ColdStorage", "double:", "ratio:", "", "org.powertac.customer.coldstorage.ColdStorage"), 639);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withRoofArea", "org.powertac.customer.coldstorage.ColdStorage", "double:", "area:", "", "org.powertac.customer.coldstorage.ColdStorage"), 656);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withRoofRValue", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 670);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWallArea", "org.powertac.customer.coldstorage.ColdStorage", "double:", "area:", "", "org.powertac.customer.coldstorage.ColdStorage"), 684);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withWallRValue", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 698);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withFloorRValue", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 712);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withInfiltrationRatio", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 726);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withUnitSize", "org.powertac.customer.coldstorage.ColdStorage", "double:", "cap:", "", "org.powertac.customer.coldstorage.ColdStorage"), 744);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withCop", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 762);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withHysteresis", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 780);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "setCurrentTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "void"), 514);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withNonCoolingUsage", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 798);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMinTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "org.powertac.customer.coldstorage.ColdStorage"), 539);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withMaxTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "org.powertac.customer.coldstorage.ColdStorage"), 553);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setShiftSag", "org.powertac.customer.coldstorage.ColdStorage", "double:", "deltaT:", "", "void"), 567);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEvalEnvTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "void"), 580);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withNominalTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "org.powertac.customer.coldstorage.ColdStorage"), 593);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withNewStockTemp", "org.powertac.customer.coldstorage.ColdStorage", "double:", "temp:", "", "org.powertac.customer.coldstorage.ColdStorage"), 607);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withStockCapacity", "org.powertac.customer.coldstorage.ColdStorage", "double:", "value:", "", "org.powertac.customer.coldstorage.ColdStorage"), 621);
        log = Logger.getLogger((String)ColdStorage.class.getName());
    }

    public ColdStorage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.minTemp = -35.0;
        this.maxTemp = -10.0;
        this.nominalTemp = -20.0;
        this.shiftSag = 4.0;
        this.evalEnvTemp = 20.0;
        this.roofArea = 900.0;
        this.roofRValue = 40.0;
        this.wallArea = 1440.0;
        this.wallRValue = 22.0;
        this.floorRValue = 15.0;
        this.infiltrationRatio = 0.5;
        this.cop = 1.5;
        this.stockCapacity = 500.0;
        this.turnoverRatio = 0.1;
        this.turnoverSd = 0.015;
        this.newStockTemp = -5.0;
        this.nonCoolingUsage = 15.0;
        this.ncUsageVariability = 0.2;
        this.ncMeanReversion = 0.06;
        this.unitSize = 40.0;
        this.hysteresis = 0.04;
        this.totalEnergyUsed = 0.0;
        this.coolingLossPerK = 0.0;
        this.currentTemp = null;
        this.currentStock = 0.0;
        this.profileSize = 168;
        this.TariffProfiles = null;
        this.nominalHourlyConsumption = 0.0;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public ColdStorage(String name) {
        super(name);
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        this.minTemp = -35.0;
        this.maxTemp = -10.0;
        this.nominalTemp = -20.0;
        this.shiftSag = 4.0;
        this.evalEnvTemp = 20.0;
        this.roofArea = 900.0;
        this.roofRValue = 40.0;
        this.wallArea = 1440.0;
        this.wallRValue = 22.0;
        this.floorRValue = 15.0;
        this.infiltrationRatio = 0.5;
        this.cop = 1.5;
        this.stockCapacity = 500.0;
        this.turnoverRatio = 0.1;
        this.turnoverSd = 0.015;
        this.newStockTemp = -5.0;
        this.nonCoolingUsage = 15.0;
        this.ncUsageVariability = 0.2;
        this.ncMeanReversion = 0.06;
        this.unitSize = 40.0;
        this.hysteresis = 0.04;
        this.totalEnergyUsed = 0.0;
        this.coolingLossPerK = 0.0;
        this.currentTemp = null;
        this.currentStock = 0.0;
        this.profileSize = 168;
        this.TariffProfiles = null;
        this.nominalHourlyConsumption = 0.0;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public void initialize() {
        super.initialize();
        log.info((Object)("Initialize " + this.name));
        this.powerType = PowerType.THERMAL_STORAGE_CONSUMPTION;
        CustomerInfo info = new CustomerInfo(this.name, 1);
        info.withPowerType(this.powerType).withControllableKW(-this.unitSize / this.cop).withStorageCapacity(this.stockCapacity * 0.564 * (this.maxTemp - this.minTemp)).withUpRegulationKW(-this.unitSize / this.cop).withDownRegulationKW(this.unitSize / this.cop);
        this.addCustomerInfo(info);
        this.ensureSeeds();
        if (this.currentTemp == null) {
            this.setCurrentTemp(this.minTemp + (this.maxTemp - this.minTemp) * this.opSeed.nextDouble());
            this.currentStock = this.stockCapacity;
        }
        this.currentNcUsage = this.nonCoolingUsage;
        this.tariffEvaluator = new TariffEvaluator((CustomerModelAccessor)this);
        this.tariffEvaluator.withInertia(0.7).withPreferredContractDuration(14.0);
        this.tariffEvaluator.initializeInconvenienceFactors(0.0, 0.01, 0.0, 0.0);
        this.tariffEvaluator.initializeRegulationFactors(-this.getMaxCooling() * 0.05, 0.0, this.getMaxCooling() * 0.04);
    }

    private void ensureSeeds() {
        if (this.opSeed == null) {
            this.opSeed = this.service.getRandomSeedRepo().getRandomSeed(String.valueOf(ColdStorage.class.getName()) + "-" + this.name, 0L, "model");
            this.evalSeed = this.service.getRandomSeedRepo().getRandomSeed(String.valueOf(ColdStorage.class.getName()) + "-" + this.name, 0L, "eval");
            this.normal01 = new NormalDistribution(0.0, 1.0);
            this.normal01.reseedRandomGenerator(this.opSeed.nextLong());
        }
    }

    public CustomerInfo getCustomerInfo() {
        return this.getCustomerInfo(this.powerType);
    }

    public void step() {
        this.totalEnergyUsed = 0.0;
        double regulation = this.getSubscription().getRegulation();
        if (regulation != 0.0) {
            double tempChange = regulation * this.cop / this.currentStock / 0.564;
            log.info((Object)(String.valueOf(this.getName()) + ": regulation = " + regulation + ", tempChange = " + tempChange));
            this.setCurrentTemp(this.currentTemp + tempChange);
        }
        this.setCurrentTemp(this.currentTemp + this.turnoverRise());
        this.updateNcUsage();
        this.useEnergy(this.currentNcUsage);
        WeatherReport weather = this.service.getWeatherReportRepo().currentWeatherReport();
        double outsideTemp = weather.getTemperature();
        EnergyInfo info = this.computeCoolingEnergy(this.getCurrentTemp(), this.getNominalTemp(), outsideTemp);
        this.setCurrentTemp(this.currentTemp + info.getDeltaTemp());
        double availableUp = info.getEnergy() / this.cop;
        if (this.currentTemp >= this.maxTemp) {
            availableUp = 0.0;
        }
        double availableDown = -(this.getMaxCooling() - info.getEnergy()) / this.cop;
        if (this.currentTemp <= this.minTemp) {
            availableDown = 0.0;
        }
        RegulationCapacity capacity = new RegulationCapacity(this.getSubscription(), availableUp, availableDown);
        this.getSubscription().setRegulationCapacity(capacity);
        log.info((Object)(String.valueOf(this.getName()) + ": regulation capacity (" + capacity.getUpRegulationCapacity() + ", " + capacity.getDownRegulationCapacity() + ")"));
        this.useEnergy(info.getEnergy() / this.cop);
        log.debug((Object)("total energy = " + this.totalEnergyUsed));
        this.getSubscription().usePower(this.totalEnergyUsed);
    }

    private TariffSubscription getSubscription() {
        List subs = this.getCurrentSubscriptions(this.powerType);
        if (subs.size() > 1) {
            log.warn((Object)("Multiple subscriptions " + subs.size() + " for " + this.getName()));
        }
        return (TariffSubscription)subs.get(0);
    }

    EnergyInfo computeCoolingEnergy(double currentTemp, double targetTemp, double outsideTemp) {
        EnergyInfo result = new EnergyInfo();
        double coolingLoss = this.computeCoolingLoss(outsideTemp);
        double adjustmentCooling = 0.0;
        if (currentTemp < targetTemp - this.hysteresis / 2.0) {
            double maxWarming = coolingLoss;
            double neededWarming = this.currentStock * 0.564 * (targetTemp - currentTemp);
            adjustmentCooling = -Math.min(maxWarming, neededWarming);
        } else if (currentTemp > targetTemp + this.hysteresis / 2.0) {
            double maxCooling = this.getMaxCooling() - coolingLoss;
            double neededCooling = this.currentStock * 0.564 * (currentTemp - targetTemp);
            adjustmentCooling = Math.min(neededCooling, maxCooling);
        }
        result.setDeltaTemp(-adjustmentCooling / (this.currentStock * 0.564));
        result.setEnergy(coolingLoss + adjustmentCooling);
        log.info((Object)(String.valueOf(this.getName()) + ": temp = " + currentTemp + ", adjustmentCooling = " + adjustmentCooling + ", total cooling energy = " + result.getEnergy() + ", temp change = " + -adjustmentCooling / (this.currentStock * 0.564)));
        return result;
    }

    double turnoverRise() {
        double turnoverMean = this.turnoverRatio * this.stockCapacity / 24.0;
        double sd = this.turnoverSd * this.stockCapacity / 24.0;
        double outgoing = Math.max(0.0, this.normal01.sample() * sd + turnoverMean);
        double incoming = Math.max(0.0, this.normal01.sample() * sd + turnoverMean);
        this.currentStock -= outgoing;
        double newStock = incoming;
        double newTemp = (this.currentStock * this.currentTemp + newStock * this.newStockTemp) / (this.currentStock + newStock);
        log.info((Object)(String.valueOf(this.getName()) + ": remove " + outgoing + "T, add " + incoming + "T raises temp " + (newTemp - this.currentTemp) + "K"));
        this.currentStock += incoming;
        return newTemp - this.currentTemp;
    }

    void updateNcUsage() {
        if (this.ncUsageVariability == 0.0) {
            return;
        }
        this.currentNcUsage = this.currentNcUsage + this.nonCoolingUsage * (this.ncUsageVariability * (this.opSeed.nextDouble() * 2.0 - 1.0)) + this.ncMeanReversion * (this.nonCoolingUsage - this.currentNcUsage);
        this.currentNcUsage = Math.max(0.0, this.currentNcUsage);
        log.info((Object)(String.valueOf(this.getName()) + ": Non-cooling usage = " + this.currentNcUsage));
    }

    double computeCoolingLoss(double outsideTemp) {
        double upperLoss = this.getCoolingLossPerK() * (outsideTemp - this.currentTemp);
        double floorLoss = 0.0031545 / this.getFloorRValue() * this.getRoofArea() * (3.0 - this.currentTemp);
        log.info((Object)(String.valueOf(this.getName()) + ": heat loss walls & roof: " + upperLoss + ", floor: " + floorLoss + ", heat load: " + this.currentNcUsage));
        return upperLoss + floorLoss + this.currentNcUsage;
    }

    double getCoolingLossPerK() {
        if (0.0 == this.coolingLossPerK) {
            double roofLoss = 0.0031545 / this.getRoofRValue() * this.getRoofArea();
            double wallLoss = 0.0031545 / this.getWallRValue() * this.getWallArea();
            double infiltrationLoss = this.getInfiltrationRatio() * (roofLoss + wallLoss);
            log.debug((Object)(": Heat loss per K -- roof: " + roofLoss + ", walls: " + wallLoss + ", infiltration: " + infiltrationLoss));
            this.coolingLossPerK = roofLoss + wallLoss + infiltrationLoss;
        }
        return this.coolingLossPerK;
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        log.info((Object)(String.valueOf(this.getName()) + ": evaluate tariffs"));
        this.tariffEvaluator.evaluateTariffs();
    }

    public CapacityProfile getCapacityProfile(Tariff tariff) {
        TariffInfo info;
        if (this.TariffProfiles == null) {
            this.TariffProfiles = new HashMap<Tariff, TariffInfo>();
        }
        if ((info = this.TariffProfiles.get(tariff)) != null) {
            return info.getCapacityProfile();
        }
        info = this.makeTariffInfo(tariff);
        if (tariff.isTimeOfUse()) {
            this.heuristicTouProfile(info);
        } else {
            double[] pr = new double[this.profileSize];
            Arrays.fill(pr, this.getNominalHourlyConsumption());
            info.setCapacityProfile(new CapacityProfile(pr, this.lastSunday()));
        }
        log.debug((Object)(String.valueOf(this.getName()) + " capacityProfile " + Arrays.toString(info.getCapacityProfile().getProfile())));
        this.TariffProfiles.put(tariff, info);
        return info.getCapacityProfile();
    }

    private TariffInfo getTariffInfo(Tariff tariff) {
        if (this.TariffProfiles == null) {
            return null;
        }
        return this.TariffProfiles.get(tariff);
    }

    private TariffInfo getTariffInfo() {
        if (this.TariffProfiles == null) {
            return null;
        }
        TariffSubscription sub = this.getSubscription();
        return this.TariffProfiles.get(sub.getTariff());
    }

    TariffInfo makeTariffInfo(Tariff tariff) {
        return new TariffInfo(tariff);
    }

    private double getNominalHourlyConsumption() {
        if (0.0 == this.nominalHourlyConsumption) {
            double turnoverUsage = this.stockCapacity * (this.turnoverRatio / 24.0) * 0.564 * (this.newStockTemp - this.getNominalTemp()) / this.cop;
            double maintenanceUsage = this.getCoolingLossPerK() * (this.getEvalEnvTemp() - this.getNominalTemp()) / this.cop;
            this.nominalHourlyConsumption = this.nonCoolingUsage + turnoverUsage + maintenanceUsage;
            log.info((Object)(String.valueOf(this.getName()) + " turnoverUsage " + turnoverUsage + ", maintenanceUsage " + maintenanceUsage + ", nominalHourlyConsumption " + this.nominalHourlyConsumption));
        }
        return this.nominalHourlyConsumption;
    }

    void heuristicTouProfile(TariffInfo tariffInfo) {
        double nhc = this.getNominalHourlyConsumption();
        double mean = tariffInfo.getMeanPrice();
        double nominalCooling = nhc - this.nonCoolingUsage;
        double maxCooling = this.getMaxCooling() / this.getCop();
        double kwhRange = Math.min(nominalCooling, maxCooling - nominalCooling);
        double priceRange = Math.max(tariffInfo.getMaxPrice() - mean, mean - tariffInfo.getMinPrice());
        double scaleFactor = kwhRange / priceRange;
        log.debug((Object)(String.valueOf(this.getName()) + " mean " + mean + ", max " + tariffInfo.getMaxPrice() + ", min " + tariffInfo.getMinPrice() + ", scaleFactor " + scaleFactor));
        Instant start = this.lastSunday();
        double evalTemp = this.getNominalTemp();
        double[] result = new double[this.profileSize];
        EnergyInfo info = this.computeCoolingEnergy(evalTemp + this.turnoverRise(), this.getNominalTemp(), this.getEvalEnvTemp());
        double coolingKwh = info.getEnergy() / this.getCop();
        log.debug((Object)(String.valueOf(this.getName()) + " coolingEnergy " + coolingKwh + ", max cooling " + maxCooling + ", nominal cooling " + nominalCooling));
        double[] prices = tariffInfo.getPrices();
        int i = 0;
        while (i < this.profileSize) {
            double actual = nominalCooling + (mean - prices[i]) * scaleFactor;
            result[i] = actual + this.nonCoolingUsage;
            ++i;
        }
        tariffInfo.setCapacityProfile(new CapacityProfile(result, start));
    }

    public double getBrokerSwitchFactor(boolean isSuperseding) {
        if (isSuperseding) {
            return 0.0;
        }
        return 0.02;
    }

    public double getTariffChoiceSample() {
        return this.evalSeed.nextDouble();
    }

    public double getInertiaSample() {
        return this.evalSeed.nextDouble();
    }

    public double getCurrentTemp() {
        return this.currentTemp;
    }

    double getMaxCooling() {
        return this.unitSize * 3.504;
    }

    /*
     * WARNING - void declaration
     */
    @StateChange
    void setCurrentTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.currentTemp = (double)temp;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    void useEnergy(double kWh) {
        this.totalEnergyUsed += kWh;
    }

    double getCurrentNcUsage() {
        return this.currentNcUsage;
    }

    public double getMinTemp() {
        return this.minTemp;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="minimum allowable temperature")
    @StateChange
    public ColdStorage withMinTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.minTemp = temp;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getMaxTemp() {
        return this.maxTemp;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="maximum allowable temperature")
    @StateChange
    public ColdStorage withMaxTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.maxTemp = temp;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getNominalTemp() {
        return this.nominalTemp;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="allowable temperature change to save money on TOU tariffs")
    @StateChange
    public void setShiftSag(double d) {
        void deltaT;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.shiftSag = deltaT;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getShiftSag() {
        return this.shiftSag;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="assumed outdoor temp for tariff evaluation")
    @StateChange
    public void setEvalEnvTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.evalEnvTemp = temp;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getEvalEnvTemp() {
        return this.evalEnvTemp;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="nominal internal temperature")
    @StateChange
    public ColdStorage withNominalTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.maxTemp = temp;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getNewStockTemp() {
        return this.newStockTemp;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Temperature of incoming stock")
    @StateChange
    public ColdStorage withNewStockTemp(double d) {
        void temp;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.newStockTemp = temp;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getStockCapacity() {
        return this.stockCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Typical inventory in tonnes of H2O")
    @StateChange
    public ColdStorage withStockCapacity(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (value < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Negative stock capacity " + (double)value + " not allowed"));
        } else {
            this.stockCapacity = value;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getTurnoverRatio() {
        return this.turnoverRatio;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Ratio of stock that gets replaced daily")
    @StateChange
    public ColdStorage withTurnoverRatio(double d) {
        void ratio;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (ratio < 0.0 || ratio > 1.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": turnover ratio " + (double)ratio + " out of range"));
        } else {
            this.turnoverRatio = ratio;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getRoofArea() {
        return this.roofArea;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Area of roof")
    @StateChange
    public ColdStorage withRoofArea(double d) {
        void area;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.roofArea = area;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getRoofRValue() {
        return this.roofRValue;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="R-value of roof insulation")
    @StateChange
    public ColdStorage withRoofRValue(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.roofRValue = value;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getWallArea() {
        return this.wallArea;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Total area of outside walls")
    @StateChange
    public ColdStorage withWallArea(double d) {
        void area;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.wallArea = area;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getWallRValue() {
        return this.wallRValue;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="R-value of wall insulation")
    @StateChange
    public ColdStorage withWallRValue(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.wallRValue = value;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getFloorRValue() {
        return this.floorRValue;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="R-value of floor insulation")
    @StateChange
    public ColdStorage withFloorRValue(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        this.floorRValue = value;
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getInfiltrationRatio() {
        return this.infiltrationRatio;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Infiltration loss as proportion of wall + roof loss")
    @StateChange
    public ColdStorage withInfiltrationRatio(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (value < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Infiltration ratio " + (double)value + " cannot be negative"));
        } else {
            this.infiltrationRatio = value;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getUnitSize() {
        return this.unitSize;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Thermal capacity in tons of cooling plant")
    @StateChange
    public ColdStorage withUnitSize(double d) {
        void cap;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (cap < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Cooling capacity " + (double)cap + " cannot be negative"));
        } else {
            this.unitSize = cap;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getCop() {
        return this.cop;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Coefficient of Performance of refrigeration unit")
    @StateChange
    public ColdStorage withCop(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (value < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Coefficient of performance " + (double)value + " cannot be negative"));
        } else {
            this.cop = value;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getHysteresis() {
        return this.hysteresis;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Control range for refrigeration unit")
    @StateChange
    public ColdStorage withHysteresis(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (value < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Hysteresis " + (double)value + " cannot be negative"));
        } else {
            this.hysteresis = value;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getNonCoolingUsage() {
        return this.nonCoolingUsage;
    }

    /*
     * WARNING - void declaration
     */
    @ConfigurableValue(valueType="Double", description="Mean hourly energy usage for non-cooling purposes")
    @StateChange
    public ColdStorage withNonCoolingUsage(double d) {
        void value;
        double d2 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d2));
        if (value < 0.0) {
            log.error((Object)(String.valueOf(this.getName()) + ": Non-cooling usage " + (double)value + " cannot be negative"));
        } else {
            this.nonCoolingUsage = value;
        }
        ColdStorage coldStorage = this;
        StateLogging.aspectOf().setstate(joinPoint);
        return coldStorage;
    }

    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    class EnergyInfo {
        private double energy;
        private double deltaTemp;

        EnergyInfo() {
        }

        void setEnergy(double kWh) {
            this.energy = kWh;
        }

        double getEnergy() {
            return this.energy;
        }

        void setDeltaTemp(double dt) {
            this.deltaTemp = dt;
        }

        double getDeltaTemp() {
            return this.deltaTemp;
        }
    }

    class TariffInfo {
        private Tariff tariff;
        double[] prices;
        CapacityProfile capacityProfile;
        private DescriptiveStatistics stats;

        TariffInfo(Tariff tariff) {
            this.tariff = tariff;
        }

        Tariff getTariff() {
            return this.tariff;
        }

        boolean isTOU() {
            return this.tariff.isTimeOfUse();
        }

        double[] getPrices() {
            if (this.prices != null) {
                return this.prices;
            }
            double nhc = ColdStorage.this.getNominalHourlyConsumption();
            this.prices = new double[ColdStorage.this.profileSize];
            double cumulativeUsage = 0.0;
            Instant start = ColdStorage.this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
            int i = 0;
            while (i < ColdStorage.this.profileSize) {
                Instant when = start.plus((long)i * 3600000L);
                if (when.get(DateTimeFieldType.hourOfDay()) == 0) {
                    cumulativeUsage = 0.0;
                }
                this.prices[i] = this.tariff.getUsageCharge(when, nhc, cumulativeUsage) / nhc;
                cumulativeUsage += nhc;
                ++i;
            }
            return this.prices;
        }

        void setPrices(double[] prices) {
            this.prices = prices;
        }

        CapacityProfile getCapacityProfile() {
            return this.capacityProfile;
        }

        void setCapacityProfile(CapacityProfile profile) {
            this.capacityProfile = profile;
        }

        double getMeanPrice() {
            this.ensureStats();
            return this.stats.getMean();
        }

        double getMaxPrice() {
            this.ensureStats();
            return this.stats.getMax();
        }

        double getMinPrice() {
            this.ensureStats();
            return this.stats.getMin();
        }

        private void ensureStats() {
            if (this.stats == null) {
                this.stats = new DescriptiveStatistics(this.getPrices());
            }
        }
    }
}

