/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.model;

import com.joptimizer.optimizers.LPOptimizationRequest;
import com.joptimizer.optimizers.LPPrimalDualMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.powertac.common.CapacityProfile;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.customer.AbstractCustomer;

@Domain
@ConfigurableInstance
public class LiftTruck
extends AbstractCustomer
implements CustomerModelAccessor {
    private static Logger log;
    static final int HOURS_DAY = 24;
    static final int DAYS_WEEK = 7;
    private double truckKW;
    private double truckStd;
    private double batteryCapacity;
    private int nBatteries;
    private int nChargers;
    private double maxChargeKW;
    private double chargeEfficiency;
    private int planningHorizon;
    private int minPlanningHorizon;
    private List<String> shiftData;
    private List<String> defaultShiftData;
    private Shift[] shiftSchedule;
    private Shift currentShift;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="Battery capacity currently being used in trucks")
    private double capacityInUse;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="Offline battery energy, currently in the trucks")
    private double energyInUse;
    @ConfigurableValue(valueType="Double", bootstrapState=true, description="Online battery energy, currently being charged")
    private double energyCharging;
    private PowerType powerType;
    private CapacityPlan plan;
    private RandomSeed opSeed;
    private RandomSeed evalSeed;
    private NormalDistribution normal;
    private TariffEvaluator tariffEvaluator;
    private Map<Tariff, CapacityPlan> profiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        LiftTruck.ajc$preClinit();
        log = LogManager.getLogger((String)LiftTruck.class.getName());
    }

    public LiftTruck() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.truckKW = 4.0;
        this.truckStd = 0.8;
        this.batteryCapacity = 50.0;
        this.nBatteries = 15;
        this.nChargers = 8;
        this.maxChargeKW = 6.0;
        this.chargeEfficiency = 0.9;
        this.planningHorizon = 60;
        this.minPlanningHorizon = 24;
        this.defaultShiftData = Arrays.asList("block", "1", "2", "3", "4", "5", "shift", "8", "8", "8", "shift", "16", "8", "6", "shift", "0", "8", "3");
        this.shiftSchedule = new Shift[168];
        this.currentShift = null;
        this.capacityInUse = 0.0;
        this.energyInUse = 0.0;
        this.energyCharging = 0.0;
        this.opSeed = null;
        this.evalSeed = null;
        this.profiles = null;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public LiftTruck(String name) {
        super(name);
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        this.truckKW = 4.0;
        this.truckStd = 0.8;
        this.batteryCapacity = 50.0;
        this.nBatteries = 15;
        this.nChargers = 8;
        this.maxChargeKW = 6.0;
        this.chargeEfficiency = 0.9;
        this.planningHorizon = 60;
        this.minPlanningHorizon = 24;
        this.defaultShiftData = Arrays.asList("block", "1", "2", "3", "4", "5", "shift", "8", "8", "8", "shift", "16", "8", "6", "shift", "0", "8", "3");
        this.shiftSchedule = new Shift[168];
        this.currentShift = null;
        this.capacityInUse = 0.0;
        this.energyInUse = 0.0;
        this.energyCharging = 0.0;
        this.opSeed = null;
        this.evalSeed = null;
        this.profiles = null;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public void initialize() {
        super.initialize();
        log.info("Initialize " + this.name);
        this.powerType = PowerType.THERMAL_STORAGE_CONSUMPTION;
        CustomerInfo info = new CustomerInfo(this.name, 1);
        double interruptible = Math.min((double)this.nChargers * this.maxChargeKW, (double)this.nBatteries * this.maxChargeKW / 3.0);
        info.withPowerType(this.powerType).withCustomerClass(CustomerInfo.CustomerClass.LARGE).withControllableKW(-interruptible).withStorageCapacity((double)this.nBatteries * this.maxChargeKW / 3.0).withUpRegulationKW((double)(-this.nChargers) * this.maxChargeKW).withDownRegulationKW((double)this.nChargers * this.maxChargeKW);
        this.addCustomerInfo(info);
        this.ensureSeeds();
        this.ensureShifts();
        this.validateBatteries();
        this.validateChargers();
        this.tariffEvaluator = new TariffEvaluator((CustomerModelAccessor)this);
        this.tariffEvaluator.withInertia(0.7).withPreferredContractDuration(14.0);
        this.tariffEvaluator.initializeInconvenienceFactors(0.0, 0.01, 0.0, 0.0);
        this.tariffEvaluator.initializeRegulationFactors((double)(-this.nChargers) * this.maxChargeKW * 0.05, 0.0, (double)this.nChargers * this.maxChargeKW * 0.04);
    }

    private void ensureSeeds() {
        if (this.opSeed == null) {
            this.opSeed = this.service.getRandomSeedRepo().getRandomSeed(String.valueOf(LiftTruck.class.getName()) + "-" + this.name, 0L, "model");
            this.evalSeed = this.service.getRandomSeedRepo().getRandomSeed(String.valueOf(LiftTruck.class.getName()) + "-" + this.name, 0L, "eval");
            this.normal = new NormalDistribution(0.0, 1.0);
            this.normal.reseedRandomGenerator(this.opSeed.nextLong());
        }
    }

    void ensureShifts() {
        Shift[] shiftArray = this.shiftSchedule;
        int n = this.shiftSchedule.length;
        int n2 = 0;
        while (n2 < n) {
            Shift s = shiftArray[n2];
            if (s != null) {
                return;
            }
            ++n2;
        }
        this.setShiftData(this.defaultShiftData);
    }

    void validateBatteries() {
        int minBatteries = 0;
        Shift s1 = null;
        Shift s2 = null;
        int i = 0;
        while (i < this.shiftSchedule.length) {
            Shift s = this.shiftSchedule[i];
            if (s == null) {
                s1 = s2;
            } else if (s2 != s) {
                s1 = s2;
                s2 = s;
                if (s1 != null) {
                    int n1 = s1.getTrucks();
                    int d1 = s1.getDuration();
                    int n2 = s2.getTrucks();
                    int d2 = s2.getDuration();
                    double neededBatteries = (double)(n1 * d1 + n2 * d2) * this.truckKW / this.getBatteryCapacity();
                    minBatteries = Math.max(minBatteries, n1 + n2);
                    minBatteries = (int)Math.max((double)minBatteries, Math.ceil(neededBatteries));
                }
            }
            ++i;
        }
        int neededBatteries = minBatteries - this.nBatteries;
        if (neededBatteries > 0) {
            log.error("Not enough batteries (" + this.nBatteries + ") for " + this.getName());
            log.warn("Adding " + neededBatteries + " batteries for " + this.getName());
            this.setNBatteries(this.getNBatteries() + neededBatteries);
        }
    }

    void validateChargers() {
        double maxNeeded = 0.0;
        int offset = 0;
        while (this.shiftSchedule[offset] == null) {
            ++offset;
        }
        Shift currentShift = this.shiftSchedule[offset];
        int remainingDuration = 0;
        int hoursInShift = (24 - currentShift.getStart()) % 24;
        remainingDuration = currentShift.getDuration() - hoursInShift;
        int i = offset;
        while (i < this.shiftSchedule.length - 24) {
            double totalEnergy = 0.0;
            Shift thisShift = this.shiftSchedule[i];
            if (thisShift != currentShift && (currentShift = thisShift) != null) {
                remainingDuration = currentShift.getDuration();
            }
            if (currentShift != null) {
                totalEnergy += (double)(currentShift.getTrucks() * remainingDuration) * this.truckKW;
            }
            Shift current = currentShift;
            int j = i + 1;
            while (j < i + 24) {
                Shift newShift = this.shiftSchedule[j];
                if (newShift != null && current != newShift) {
                    int durationInWindow = Math.min(i + 24 - j, newShift.getDuration());
                    totalEnergy += (double)(newShift.getTrucks() * durationInWindow) * this.truckKW;
                    current = newShift;
                }
                ++j;
            }
            maxNeeded = Math.max(maxNeeded, totalEnergy);
            --remainingDuration;
            ++i;
        }
        double chargeEnergy = (double)this.nChargers * this.maxChargeKW * 24.0;
        if (maxNeeded > chargeEnergy) {
            double need = (maxNeeded - chargeEnergy) / (this.maxChargeKW * 24.0);
            int add = (int)Math.ceil(need);
            log.error("Insufficient charging capacity for " + this.getName() + ": have " + chargeEnergy + ", need " + maxNeeded + ". Adding " + add + " availableChargers.");
            this.setNChargers(this.getNChargers() + add);
        }
    }

    public CustomerInfo getCustomerInfo() {
        return this.getCustomerInfo(this.powerType);
    }

    public void step() {
        Shift newShift = this.shiftSchedule[this.indexOfShift(this.getNowInstant())];
        if (newShift != this.currentShift) {
            log.info(String.valueOf(this.getName()) + " start of shift");
            double totalEnergy = this.getEnergyCharging() + this.getEnergyInUse();
            this.setEnergyCharging(this.getEnergyCharging() + this.getEnergyInUse());
            this.setCapacityInUse(0.0);
            this.setEnergyInUse(0.0);
            if (newShift != null) {
                this.setCapacityInUse((double)newShift.getTrucks() * this.batteryCapacity);
                this.setEnergyInUse(Math.min(this.getCapacityInUse(), totalEnergy));
                this.setEnergyCharging(totalEnergy - this.getEnergyInUse());
            }
            log.info(String.valueOf(this.getName()) + ": new shift cInUse " + this.capacityInUse + ", eInUse " + this.energyInUse + ", eCharging " + this.energyCharging);
            this.currentShift = newShift;
        }
        if (this.currentShift != null) {
            double usage = Math.max(0.0, this.normal.sample() * this.truckStd + this.truckKW * (double)this.currentShift.getTrucks());
            double deficit = usage - this.getEnergyInUse();
            log.debug(String.valueOf(this.getName()) + ": trucks use " + usage + " kWh");
            if (deficit > 0.0) {
                log.warn(String.valueOf(this.getName()) + ": trucks use more energy than available by " + deficit + " kWh");
                this.addEnergyInUse(deficit);
                this.addEnergyCharging(-deficit);
            }
            this.addEnergyInUse(-usage);
        }
        double regulation = this.getSubscription().getRegulation();
        log.info(String.valueOf(this.getName()) + ": regulation " + regulation);
        double energyUsed = this.useEnergy(regulation);
        this.getSubscription().usePower(energyUsed);
        log.info(String.valueOf(this.getName()) + " cInUse " + this.capacityInUse + ", eInUse " + this.energyInUse + ", eCharging " + this.energyCharging);
    }

    double useEnergy(double regulation) {
        TariffSubscription subscription = this.getSubscription();
        Tariff tariff = subscription.getTariff();
        this.ensureCapacityPlan(tariff);
        this.addEnergyCharging(-regulation * this.chargeEfficiency);
        ShiftEnergy need = this.plan.getCurrentNeed(this.getNowInstant());
        if (need.getDuration() <= 0) {
            log.error(String.valueOf(this.getName()) + " negative need duration " + need.getDuration());
        }
        need.addEnergy(-regulation);
        double max = (double)this.nChargers * this.maxChargeKW * (double)need.getDuration();
        double avail = (double)this.nBatteries * this.batteryCapacity - this.getCapacityInUse() - this.getEnergyCharging();
        double maxUsable = Math.min(max, avail) / this.chargeEfficiency;
        double needed = need.getEnergyNeeded();
        double used = 0.0;
        RegulationCapacity regCapacity = null;
        if (needed >= maxUsable) {
            log.info(String.valueOf(this.getName()) + ": no slack - need " + needed + ", max " + max + ", avail " + avail + ", dur " + need.getDuration());
            used = Math.min(maxUsable, needed / (double)need.getDuration());
            regCapacity = new RegulationCapacity(subscription, 0.0, 0.0);
        } else if (tariff.isTimeOfUse() || tariff.isVariableRate()) {
            used = need.getRecommendedUsage()[need.getUsageIndex()];
            regCapacity = new RegulationCapacity(subscription, 0.0, 0.0);
        } else {
            double slack = (maxUsable - needed) / (double)need.getDuration() / 2.0;
            log.info(String.valueOf(this.getName()) + " needed " + needed + ", maxUsable " + maxUsable + ", duration " + need.getDuration());
            used = needed / (double)need.getDuration() + slack;
            regCapacity = new RegulationCapacity(subscription, slack, -slack);
        }
        this.addEnergyCharging(used * this.chargeEfficiency);
        this.getSubscription().setRegulationCapacity(regCapacity);
        log.info(String.valueOf(this.getName()) + " uses " + used + "kWh, reg cap (" + regCapacity.getUpRegulationCapacity() + ", " + regCapacity.getDownRegulationCapacity() + ")");
        need.tick();
        need.addEnergy(used);
        return used;
    }

    void ensureCapacityPlan(Tariff tariff) {
        if (this.plan == null || !this.plan.isValid(this.getNowInstant(), tariff)) {
            this.plan = this.getCapacityPlan(tariff, this.getNowInstant(), this.getPlanningHorizon());
            this.plan.createPlan(this.getEnergyCharging());
        }
    }

    ShiftEnergy[] getFutureEnergyNeeds(Instant start, int horizon, double initialCharging) {
        Instant seStart = start;
        int index = this.indexOfShift(start);
        Shift currentShift = this.shiftSchedule[index];
        int duration = 0;
        while (this.shiftSchedule[index] == currentShift) {
            ++duration;
            index = this.nextShiftIndex(index);
        }
        Shift nextShift = this.shiftSchedule[index];
        ArrayList<ShiftEnergy> data = new ArrayList<ShiftEnergy>();
        data.add(new ShiftEnergy(seStart, index, duration));
        seStart = seStart.plus((long)duration * 3600000L);
        int elapsed = duration;
        while (elapsed < horizon) {
            duration = 0;
            while (nextShift == this.shiftSchedule[index]) {
                index = this.nextShiftIndex(index);
                ++duration;
            }
            nextShift = this.shiftSchedule[index];
            data.add(new ShiftEnergy(seStart, index, duration));
            elapsed += duration;
            seStart = seStart.plus((long)duration * 3600000L);
        }
        ShiftEnergy[] result = data.toArray(new ShiftEnergy[data.size()]);
        double shortage = 0.0;
        int i = result.length - 1;
        while (i >= 0) {
            int endx = result[i].endIndex;
            int prev = this.previousShiftIndex(endx);
            currentShift = this.shiftSchedule[prev];
            Shift end = this.shiftSchedule[endx];
            double needed = 0.0;
            if (end != null) {
                needed = (double)(end.getTrucks() * end.getDuration()) * this.getTruckKW() / this.getChargeEfficiency();
            }
            int chargers = this.getNChargers();
            int availableBatteries = this.nBatteries;
            if (currentShift != null) {
                availableBatteries -= currentShift.getTrucks();
            }
            chargers = Math.min(chargers, availableBatteries);
            double available = this.getMaxChargeKW() * (double)result[i].getDuration() * (double)chargers / this.getChargeEfficiency();
            double surplus = available - needed - shortage;
            shortage = Math.max(0.0, -(available - needed - shortage));
            result[i].setEnergyNeeded(needed);
            result[i].setMaxSurplus(surplus);
            --i;
        }
        double finalSurplus = result[0].getMaxSurplus();
        if (finalSurplus > 0.0) {
            result[0].setMaxSurplus(finalSurplus + initialCharging);
        } else if (shortage > 0.0) {
            result[0].setMaxSurplus(initialCharging - shortage);
        }
        return result;
    }

    CapacityPlan getCapacityPlan(Tariff tariff, Instant start, int size) {
        CapacityPlan result = new CapacityPlan(tariff, start, size);
        return result;
    }

    int indexOfShift(Instant time) {
        int hour = time.get(DateTimeFieldType.hourOfDay());
        int day = time.get(DateTimeFieldType.dayOfWeek());
        return hour + (day - 1) * 24;
    }

    int nextShiftIndex(int index) {
        return (index + 1) % this.shiftSchedule.length;
    }

    int previousShiftIndex(int index) {
        if (index == 0) {
            return this.shiftSchedule.length - 1;
        }
        return (index - 1) % this.shiftSchedule.length;
    }

    Instant indexToInstant(int index) {
        Instant now = this.getNowInstant();
        int probe = index;
        while (probe < 0) {
            probe += this.shiftSchedule.length;
        }
        while (probe > this.shiftSchedule.length) {
            probe -= this.shiftSchedule.length;
        }
        int nowIndex = this.indexOfShift(now);
        if (nowIndex <= index) {
            return now.plus(3600000L * (long)(index - nowIndex));
        }
        return now.plus(3600000L * (long)(this.shiftSchedule.length + index - nowIndex));
    }

    private Instant getNowInstant() {
        return this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
    }

    private Instant getNextSunday() {
        Instant result = this.getNowInstant();
        int hour = result.get(DateTimeFieldType.hourOfDay());
        if (hour > 0) {
            result = result.plus((long)(24 - hour) * 3600000L);
        }
        int day = result.get(DateTimeFieldType.dayOfWeek());
        result = result.plus((long)(7 - day) * 86400000L);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ConfigurableValue(valueType="Double", description="mean power usage when truck is in use")
    @StateChange
    public void setTruckKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.truckKW = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getTruckKW() {
        return this.truckKW;
    }

    @ConfigurableValue(valueType="Double", description="Std dev of truck power usage")
    @StateChange
    public void setTruckStd(double stdDev) {
        double d = stdDev;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.truckStd = stdDev;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getTruckStd() {
        return this.truckStd;
    }

    @ConfigurableValue(valueType="List", description="shift spec [block, shift, ..., block, shift, ...]")
    public void setShiftData(List<String> data) {
        boolean shf;
        boolean blk = false;
        boolean state = shf = true;
        LinkedList<String> tokens = new LinkedList<String>(data);
        ArrayList<Integer> blockData = new ArrayList<Integer>();
        ArrayList<Integer> shiftData = new ArrayList<Integer>();
        while (!tokens.isEmpty()) {
            String token = tokens.remove();
            if (token.equals("block")) {
                if (!shiftData.isEmpty()) {
                    this.finishShift(blockData, shiftData);
                    shiftData.clear();
                }
                blockData.clear();
                state = blk;
                continue;
            }
            if (token.equals("shift")) {
                if (!shiftData.isEmpty()) {
                    this.finishShift(blockData, shiftData);
                    shiftData.clear();
                }
                state = shf;
                continue;
            }
            try {
                if (state == shf) {
                    shiftData.add(Integer.parseInt(token));
                    continue;
                }
                if (state != blk) continue;
                blockData.add(Integer.parseInt(token));
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Config error for " + this.getName() + ": bad numeric token " + token);
            }
        }
        if (!shiftData.isEmpty()) {
            this.finishShift(blockData, shiftData);
        }
    }

    private void finishShift(ArrayList<Integer> blockData, ArrayList<Integer> shiftData) {
        if (blockData.isEmpty()) {
            log.error("Config error for " + this.getName() + ": empty block for shift " + shiftData.toString());
        } else {
            this.addShift(shiftData, blockData);
        }
    }

    void addShift(List<Integer> shiftData, List<Integer> blockData) {
        if (shiftData.size() < 3) {
            log.error("Bad shift spec for " + this.getName() + ": " + shiftData.toString());
            return;
        }
        if (!this.validBlock(blockData)) {
            log.error("Bad block data for " + this.getName() + ": " + blockData.toString());
            return;
        }
        int start = shiftData.get(0);
        if (start < 0 || start > 23) {
            log.error("Bad shift start time " + start + " for " + this.getName());
            return;
        }
        int duration = shiftData.get(1);
        if (duration < 1 || duration > 24) {
            log.error("Bad shift duration " + duration + " for " + this.getName());
            return;
        }
        int trucks = shiftData.get(2);
        if (trucks < 0) {
            log.error("Negative shift truck count " + trucks + " for " + this.getName());
            return;
        }
        Shift shift = new Shift(start, duration, trucks);
        for (int day : blockData) {
            int hour = shift.getStart();
            while (hour < shift.getStart() + shift.getDuration()) {
                int index = (hour + (day - 1) * 24) % this.shiftSchedule.length;
                this.shiftSchedule[index] = shift;
                ++hour;
            }
        }
    }

    boolean validBlock(List<Integer> data) {
        if (data.isEmpty()) {
            return false;
        }
        for (Integer datum : data) {
            if (datum >= 1 && datum <= 7) continue;
            return false;
        }
        return true;
    }

    public List<String> getShiftData() {
        return this.shiftData;
    }

    Shift[] getShiftSchedule() {
        return this.shiftSchedule;
    }

    @ConfigurableValue(valueType="Double", description="size of battery pack in kWh")
    @StateChange
    public void setBatteryCapacity(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.batteryCapacity = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getBatteryCapacity() {
        return this.batteryCapacity;
    }

    @ConfigurableValue(valueType="Integer", description="total number of battery packs")
    @StateChange
    public void setNBatteries(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        this.nBatteries = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public int getNBatteries() {
        return this.nBatteries;
    }

    @ConfigurableValue(valueType="Integer", description="number of battery chargers")
    @StateChange
    public void setNChargers(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        this.nChargers = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public int getNChargers() {
        return this.nChargers;
    }

    @ConfigurableValue(valueType="Double", description="maximum charge rate of one truck's battery pack")
    @StateChange
    public void setMaxChargeKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.maxChargeKW = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getMaxChargeKW() {
        return this.maxChargeKW;
    }

    @ConfigurableValue(valueType="Double", description="ratio of charge energy to battery energy")
    @StateChange
    public void setChargeEfficiency(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.chargeEfficiency = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getChargeEfficiency() {
        return this.chargeEfficiency;
    }

    @ConfigurableValue(valueType="Integer", description="planning horizon in timeslots - should be at least 48")
    @StateChange
    public void setPlanningHorizon(int horizon) {
        int n = horizon;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        this.planningHorizon = horizon;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public int getPlanningHorizon() {
        return this.planningHorizon;
    }

    @ConfigurableValue(valueType="Integer", description="minimum useful horizon of existing plan")
    @StateChange
    public void setMinPlanningHorizon(int horizon) {
        int n = horizon;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        this.minPlanningHorizon = horizon;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public int getMinPlanningHorizon() {
        return this.minPlanningHorizon;
    }

    @StateChange
    public void setEnergyCharging(double kwh) {
        double d = kwh;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.energyCharging = kwh;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getEnergyCharging() {
        return this.energyCharging;
    }

    public void addEnergyCharging(double kwh) {
        this.setEnergyCharging(this.getEnergyCharging() + kwh);
    }

    @StateChange
    public void setEnergyInUse(double kwh) {
        double d = kwh;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.energyInUse = kwh;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getEnergyInUse() {
        return this.energyInUse;
    }

    public void addEnergyInUse(double kwh) {
        this.setEnergyInUse(this.getEnergyInUse() + kwh);
    }

    @StateChange
    public void setCapacityInUse(double kwh) {
        double d = kwh;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.capacityInUse = kwh;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getCapacityInUse() {
        return this.capacityInUse;
    }

    private TariffSubscription getSubscription() {
        List subs = this.getCurrentSubscriptions(this.powerType);
        if (subs.size() > 1) {
            log.warn("Multiple subscriptions " + subs.size() + " for " + this.getName());
        }
        return (TariffSubscription)subs.get(0);
    }

    public CapacityProfile getCapacityProfile(Tariff tariff) {
        CapacityPlan plan;
        if (this.profiles == null) {
            this.profiles = new HashMap<Tariff, CapacityPlan>();
        }
        if ((plan = this.profiles.get(tariff)) != null) {
            return plan.getCapacityProfile();
        }
        plan = this.getCapacityPlan(tariff, this.getNextSunday(), this.getPlanningHorizon());
        this.profiles.put(tariff, plan);
        plan.createPlan(tariff, 0.0);
        return plan.getCapacityProfile();
    }

    public double getBrokerSwitchFactor(boolean isSuperseding) {
        if (isSuperseding) {
            return 0.0;
        }
        return 0.02;
    }

    public double getTariffChoiceSample() {
        return this.evalSeed.nextDouble();
    }

    public double getInertiaSample() {
        return this.evalSeed.nextDouble();
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        log.info(String.valueOf(this.getName()) + ": evaluate tariffs");
        this.tariffEvaluator.evaluateTariffs();
    }

    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LiftTruck.java", LiftTruck.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.model.LiftTruck", "", "", ""), 153);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.model.LiftTruck", "java.lang.String", "name", ""), 161);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMinPlanningHorizon", "org.powertac.customer.model.LiftTruck", "int", "horizon", "", "void"), 877);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEnergyCharging", "org.powertac.customer.model.LiftTruck", "double", "kwh", "", "void"), 891);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEnergyInUse", "org.powertac.customer.model.LiftTruck", "double", "kwh", "", "void"), 910);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCapacityInUse", "org.powertac.customer.model.LiftTruck", "double", "kwh", "", "void"), 929);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTruckKW", "org.powertac.customer.model.LiftTruck", "double", "value", "", "void"), 639);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTruckStd", "org.powertac.customer.model.LiftTruck", "double", "stdDev", "", "void"), 652);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setBatteryCapacity", "org.powertac.customer.model.LiftTruck", "double", "value", "", "void"), 799);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNBatteries", "org.powertac.customer.model.LiftTruck", "int", "value", "", "void"), 812);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNChargers", "org.powertac.customer.model.LiftTruck", "int", "value", "", "void"), 825);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxChargeKW", "org.powertac.customer.model.LiftTruck", "double", "value", "", "void"), 838);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setChargeEfficiency", "org.powertac.customer.model.LiftTruck", "double", "value", "", "void"), 851);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlanningHorizon", "org.powertac.customer.model.LiftTruck", "int", "horizon", "", "void"), 864);
    }

    class CapacityPlan {
        private double[] usage;
        private double[] slack;
        private ShiftEnergy[] needs;
        private Instant start;
        private int size;
        private Tariff tariff;

        CapacityPlan(Tariff tariff, Instant start) {
            this(tariff, start, liftTruck.getPlanningHorizon());
        }

        CapacityPlan(Tariff tariff, Instant start, int size) {
            this.tariff = tariff;
            this.start = start;
            this.size = size;
        }

        public boolean isValid(Instant now, Tariff tariff) {
            if (tariff != this.tariff) {
                return false;
            }
            int remaining = (int)((long)this.size - (now.getMillis() - this.start.getMillis()) / 3600000L);
            return remaining >= LiftTruck.this.getMinPlanningHorizon();
        }

        CapacityProfile getCapacityProfile() {
            return new CapacityProfile(this.usage, this.start);
        }

        ShiftEnergy getCurrentNeed(Instant when) {
            if (this.needs == null) {
                return null;
            }
            int i = 0;
            while (i < this.needs.length) {
                if (i == this.needs.length - 1 || this.needs[i + 1].getStart().isAfter((ReadableInstant)when)) {
                    return this.needs[i];
                }
                ++i;
            }
            log.error(String.valueOf(LiftTruck.this.getName()) + " at " + when.toString() + " ran off end of plan length " + this.size + " starting " + this.start.toString());
            return null;
        }

        void createPlan(double initialCharging) {
            this.createPlan(this.tariff, initialCharging);
        }

        void createPlan(Tariff tariff, double initialCharging) {
            this.needs = LiftTruck.this.getFutureEnergyNeeds(this.start, this.size, initialCharging);
            int newSize = 0;
            ShiftEnergy[] shiftEnergyArray = this.needs;
            int n = this.needs.length;
            int n2 = 0;
            while (n2 < n) {
                ShiftEnergy need = shiftEnergyArray[n2];
                newSize += need.getDuration();
                ++n2;
            }
            this.size = newSize;
            LpPlan plan = new LpPlan(tariff, this.needs, this.size);
            this.usage = plan.getSolution();
            this.slack = plan.getSlack();
            this.updateNeeds();
        }

        ShiftEnergy[] updateNeeds() {
            if (this.needs == null) {
                return null;
            }
            int usageIndex = 0;
            int i = 0;
            while (i < this.needs.length) {
                ShiftEnergy se = this.needs[i];
                se.setRecommendedUsage(Arrays.copyOfRange(this.usage, usageIndex, usageIndex + se.getDuration()));
                usageIndex += se.getDuration();
                se.setSlack(this.slack[i]);
                ++i;
            }
            return this.needs;
        }
    }

    class LpPlan {
        double[] solution;
        double[] slack;
        boolean solved = false;
        Tariff tariff;
        ShiftEnergy[] needs;
        int size;
        int blockCount = 0;

        LpPlan(Tariff tariff, ShiftEnergy[] needs, int size) {
            this.tariff = tariff;
            this.needs = needs;
            this.size = size;
        }

        /*
         * Unable to fully structure code
         */
        private void solve() {
            if (this.solved) {
                return;
            }
            start = new Date();
            shifts = this.needs.length;
            blocks = this.makeBlocks(shifts);
            columns = blocks.length;
            blockIndex = -1;
            obj = new double[columns + shifts];
            a = new double[shifts][columns + shifts];
            b = new double[shifts];
            lb = new double[columns + shifts];
            ub = new double[columns + shifts];
            column = 0;
            cumulativeMin = 0.0;
            i = 0;
            ** GOTO lbl37
            {
                obj[column] = blocks[++blockIndex].getCost();
                lb[column] = 0.0;
                ub[column] = (this.needs[i].getEnergyNeeded() + this.needs[i].getMaxSurplus()) * (double)blocks[blockIndex].getDuration() / (double)this.needs[i].getDuration();
                ++column;
                do {
                    if (blockIndex < blocks.length - 1 && blocks[blockIndex + 1].getShiftEnergy() == this.needs[i]) continue block2;
                    j = 0;
                    while (j < column) {
                        a[i][j] = -1.0;
                        ++j;
                    }
                    need = this.needs[i].getEnergyNeeded();
                    if (this.needs[i].getMaxSurplus() < 0.0) {
                        need += this.needs[i].getMaxSurplus();
                    }
                    b[i] = -(cumulativeMin += need);
                    obj[columns + i] = 0.0;
                    a[i][columns + i] = 1.0;
                    lb[columns + i] = 0.0;
                    ub[columns + i] = this.needs[i].getEnergyNeeded() + this.needs[i].getMaxSurplus();
                    ++i;
lbl37:
                    // 2 sources

                } while (i < shifts);
            }
            or = new LPOptimizationRequest();
            LiftTruck.access$1().debug("Obj: " + Arrays.toString(obj));
            or.setC(obj);
            LiftTruck.access$1().debug("a:");
            i = 0;
            while (i < a.length) {
                LiftTruck.access$1().debug(Arrays.toString(a[i]));
                ++i;
            }
            or.setA(a);
            LiftTruck.access$1().debug("b: " + Arrays.toString(b));
            or.setB(b);
            or.setLb(lb);
            LiftTruck.access$1().debug("ub: " + Arrays.toString(ub));
            or.setUb(ub);
            or.setTolerance(0.01);
            opt = new LPPrimalDualMethod();
            opt.setLPOptimizationRequest(or);
            try {
                returnCode = opt.optimize();
                if (returnCode != 0) {
                    LiftTruck.access$1().error(String.valueOf(LiftTruck.this.getName()) + "bad optimization return code " + returnCode);
                }
                sol = opt.getOptimizationResponse().getSolution();
                end = new Date();
                LiftTruck.access$1().info("Solution time: " + (end.getTime() - start.getTime()));
                LiftTruck.access$1().debug("Solution = " + Arrays.toString(sol));
                this.recordSolution(sol, blocks);
            }
            catch (Exception e) {
                LiftTruck.access$1().error(e.toString());
            }
            this.solved = true;
        }

        ShiftBlock[] makeBlocks(int shifts) {
            ArrayList<ShiftBlock> blocks = new ArrayList<ShiftBlock>();
            double epsilon = 0.001;
            Instant time = LiftTruck.this.indexToInstant(this.needs[0].getStartIndex());
            int i = 0;
            while (i < shifts) {
                double kwh = this.needs[i].getEnergyNeeded() + this.needs[i].getMaxSurplus();
                ShiftBlock currentBlock = null;
                double blockCost = 0.0;
                int j = 0;
                while (j < this.needs[i].getDuration()) {
                    double kwhPerTs = kwh / (double)this.needs[i].getDuration();
                    double cost = this.tariff.getUsageCharge(time, kwhPerTs, kwh) / kwhPerTs;
                    if (currentBlock == null) {
                        blockCost = cost;
                        currentBlock = new ShiftBlock(this.needs[i], j);
                        currentBlock.setCost(blockCost);
                        blocks.add(currentBlock);
                    } else if (Math.abs(cost - blockCost) > epsilon) {
                        currentBlock = new ShiftBlock(this.needs[i], j);
                        currentBlock.setCost(cost);
                        blocks.add(currentBlock);
                    }
                    currentBlock.incrementDuration();
                    ++j;
                }
                ++i;
            }
            ShiftBlock[] result = new ShiftBlock[blocks.size()];
            return blocks.toArray(result);
        }

        void recordSolution(double[] lpResult, ShiftBlock[] blocks) {
            double[] blockSolution = Arrays.copyOfRange(lpResult, 0, blocks.length);
            log.debug("Block soln: " + Arrays.toString(blockSolution));
            this.solution = new double[this.size];
            int solutionIndex = 0;
            int lpIndex = 0;
            ShiftBlock[] shiftBlockArray = blocks;
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                ShiftBlock block = shiftBlockArray[n2];
                double blockValue = blockSolution[lpIndex++] / (double)block.getDuration();
                int i = 0;
                while (i < block.getDuration()) {
                    this.solution[solutionIndex++] = blockValue;
                    ++i;
                }
                ++n2;
            }
            log.debug("Usage: " + Arrays.toString(this.solution));
            this.slack = Arrays.copyOfRange(lpResult, blocks.length, lpResult.length);
            log.debug("Slack: " + Arrays.toString(this.slack));
        }

        double[] getSolution() {
            this.solve();
            return this.solution;
        }

        double[] getSlack() {
            this.solve();
            return this.slack;
        }
    }

    class Shift
    implements Comparable<Shift> {
        private int start;
        private int duration;
        private int trucks = 0;

        Shift(int start, int duration, int trucks) {
            this.start = start;
            this.duration = duration;
            this.trucks = trucks;
        }

        int getStart() {
            return this.start;
        }

        int getDuration() {
            return this.duration;
        }

        int getTrucks() {
            return this.trucks;
        }

        void setTrucks(int count) {
            this.trucks = count;
        }

        @Override
        public int compareTo(Shift s) {
            return this.start - s.start;
        }

        public String toString() {
            return "Shift(" + this.start + "," + this.duration + "," + this.trucks + ")";
        }
    }

    class ShiftBlock {
        ShiftEnergy shiftEnergy;
        int startOffset;
        int duration = 0;
        double cost = 0.0;

        ShiftBlock(ShiftEnergy shiftEnergy, int startOffset) {
            this.shiftEnergy = shiftEnergy;
            this.startOffset = startOffset;
        }

        int getDuration() {
            return this.duration;
        }

        void incrementDuration() {
            ++this.duration;
        }

        double getCost() {
            return this.cost;
        }

        void setCost(double cost) {
            this.cost = cost;
        }

        ShiftEnergy getShiftEnergy() {
            return this.shiftEnergy;
        }

        int getStartOffset() {
            return this.startOffset;
        }
    }

    class ShiftEnergy {
        private Instant start;
        private int endIndex;
        private int duration;
        private double energyNeeded = 0.0;
        private double maxSurplus = 0.0;
        private double[] recommendedUsage;
        private double slack;
        private int usageIndex = 0;

        ShiftEnergy(Instant start, int end, int duration) {
            this.start = start;
            this.endIndex = end;
            Shift next = LiftTruck.this.shiftSchedule[end];
            if (next != null) {
                this.energyNeeded = (double)(next.getTrucks() * next.getDuration()) * LiftTruck.this.getTruckKW();
            }
            this.duration = duration;
        }

        Instant getStart() {
            return this.start;
        }

        int getStartIndex() {
            return LiftTruck.this.previousShiftIndex(this.endIndex);
        }

        Shift getThisShift() {
            return LiftTruck.this.shiftSchedule[this.getStartIndex()];
        }

        int getEndIndex() {
            return this.endIndex;
        }

        Shift getNextShift() {
            if (this.endIndex >= LiftTruck.this.shiftSchedule.length) {
                return null;
            }
            return LiftTruck.this.shiftSchedule[this.endIndex];
        }

        int getDuration() {
            return this.duration;
        }

        void tick() {
            --this.duration;
            if (this.duration < 0) {
                log.error(String.valueOf(LiftTruck.this.getName()) + "SE start at " + this.start.toString() + " ticked past duration " + this.duration);
            }
            ++this.usageIndex;
        }

        double getEnergyNeeded() {
            return this.energyNeeded;
        }

        void setEnergyNeeded(double energyNeeded) {
            this.energyNeeded = energyNeeded;
        }

        void addEnergy(double energy) {
            this.energyNeeded = Math.max(0.0, this.energyNeeded - energy);
        }

        double getMaxSurplus() {
            return this.maxSurplus;
        }

        void setMaxSurplus(double maxSurplus) {
            this.maxSurplus = maxSurplus;
        }

        void addSurplus(double surplus) {
            this.maxSurplus += surplus;
        }

        double[] getRecommendedUsage() {
            return this.recommendedUsage;
        }

        double getCurrentRecommendedUsage() {
            return this.recommendedUsage[this.usageIndex];
        }

        int getUsageIndex() {
            return this.usageIndex;
        }

        double getSlack() {
            return this.slack;
        }

        void setRecommendedUsage(double[] usagePlan) {
            if (usagePlan.length != this.duration) {
                log.error("usagePlan length " + usagePlan.length + " > duration " + this.duration);
            }
            this.recommendedUsage = usagePlan;
        }

        void setSlack(double slack) {
            this.slack = slack;
        }
    }
}

