/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.common.repo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Orderbook;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.DomainRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderbookRepo
implements DomainRepo {
    private static Logger log = LogManager.getLogger((String)OrderbookRepo.class.getName());
    @Autowired
    private TimeService timeService;
    private HashMap<Timeslot, List<Orderbook>> orderbookIndex = new HashMap();
    private HashMap<Timeslot, Orderbook> timeslotIndex = new HashMap();
    private HashMap<Timeslot, Orderbook> spotIndex = new HashMap();
    private Double[] minAskPrices;
    private Double[] maxAskPrices;

    public Orderbook makeOrderbook(Timeslot timeslot, Double clearingPrice) {
        List<Orderbook> obList;
        Orderbook result = new Orderbook(timeslot, clearingPrice, this.timeService.getCurrentTime());
        this.timeslotIndex.put(timeslot, result);
        if (clearingPrice != null) {
            this.spotIndex.put(timeslot, result);
        }
        if ((obList = this.orderbookIndex.get(timeslot)) == null) {
            obList = new ArrayList<Orderbook>();
            this.orderbookIndex.put(timeslot, obList);
        }
        obList.add(result);
        log.debug("Created new Orderbook ts=" + timeslot.getSerialNumber() + ", clearingPrice=" + clearingPrice);
        return result;
    }

    public Orderbook findByTimeslot(Timeslot timeslot) {
        return this.timeslotIndex.get(timeslot);
    }

    public Orderbook findSpotByTimeslot(Timeslot timeslot) {
        return this.spotIndex.get(timeslot);
    }

    public List<Orderbook> findAllByTimeslot(Timeslot timeslot) {
        return this.orderbookIndex.get(timeslot);
    }

    public void setMinAskPrices(Double[] values) {
        this.minAskPrices = values;
    }

    public void setMaxAskPrices(Double[] values) {
        this.maxAskPrices = values;
    }

    public Double[] getMinAskPrices() {
        return this.minAskPrices;
    }

    public Double[] getMaxAskPrices() {
        return this.maxAskPrices;
    }

    public int size() {
        return this.timeslotIndex.size();
    }

    @Override
    public void recycle() {
        this.orderbookIndex.clear();
        this.timeslotIndex.clear();
        this.spotIndex.clear();
        this.minAskPrices = null;
        this.maxAskPrices = null;
    }
}

