/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.model;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.Instant;
import org.powertac.common.CapacityProfile;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.common.state.StateLogging;
import org.powertac.customer.AbstractCustomer;

@Domain
@ConfigurableInstance
public class Battery
extends AbstractCustomer
implements CustomerModelAccessor {
    private static Logger log;
    private double capacityKWh;
    private double maxChargeKW;
    private double maxDischargeKW;
    private double chargeEfficiency;
    private double selfDischargeRate;
    @ConfigurableValue(valueType="Double", dump=false, bootstrapState=true, description="State of charge")
    private double stateOfCharge;
    private PowerType powerType;
    private RandomSeed evalSeed;
    private TariffEvaluator tariffEvaluator;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Battery.ajc$preClinit();
        log = LogManager.getLogger((String)Battery.class.getName());
    }

    public Battery() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.capacityKWh = 50.0;
        this.maxChargeKW = 20.0;
        this.maxDischargeKW = -20.0;
        this.chargeEfficiency = 0.95;
        this.selfDischargeRate = 5.0E-4;
        this.stateOfCharge = 0.0;
        this.powerType = PowerType.BATTERY_STORAGE;
        this.evalSeed = null;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public Battery(String name) {
        super(name);
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        this.capacityKWh = 50.0;
        this.maxChargeKW = 20.0;
        this.maxDischargeKW = -20.0;
        this.chargeEfficiency = 0.95;
        this.selfDischargeRate = 5.0E-4;
        this.stateOfCharge = 0.0;
        this.powerType = PowerType.BATTERY_STORAGE;
        this.evalSeed = null;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public void initialize() {
        super.initialize();
        log.info("Initialize " + this.name);
        CustomerInfo info = new CustomerInfo(this.name, 1);
        double interruptible = this.maxChargeKW;
        info.withPowerType(this.powerType).withControllableKW(-interruptible).withStorageCapacity(this.capacityKWh).withUpRegulationKW(this.maxDischargeKW).withDownRegulationKW(this.maxChargeKW);
        this.addCustomerInfo(info);
        this.ensureSeeds();
        if (this.capacityKWh <= 0.0) {
            log.error("{}: bad capacity value {}", (Object)this.name, (Object)this.capacityKWh);
            this.capacityKWh = 1.0;
        }
        if (this.maxChargeKW <= 0.0) {
            log.error("{}: bad value {} for maxChargeKW", (Object)this.name, (Object)this.maxChargeKW);
            this.maxChargeKW = 1.0;
        }
        if (this.maxDischargeKW >= 0.0) {
            log.error("{}: bad value {} for maxDischargeKW", (Object)this.name, (Object)this.maxDischargeKW);
            this.maxDischargeKW = -1.0;
        }
        if (this.selfDischargeRate < 0.0 || this.selfDischargeRate > 1.0) {
            log.error("{}: selfDischargeRate {} invalid", (Object)this.name, (Object)this.selfDischargeRate);
            this.selfDischargeRate = 0.0;
        }
        if (this.chargeEfficiency < 0.0 || this.chargeEfficiency > 1.0) {
            log.error("{}: chargeEfficiency {} invalid", (Object)this.name, (Object)this.chargeEfficiency);
            this.chargeEfficiency = 1.0;
        }
        this.tariffEvaluator = new TariffEvaluator((CustomerModelAccessor)this);
        this.tariffEvaluator.withInertia(0.7).withRationality(0.99).withPreferredContractDuration(14.0);
        this.tariffEvaluator.initializeInconvenienceFactors(0.0, 0.01, 0.0, 0.0);
        this.tariffEvaluator.initializeRegulationFactors(0.0, this.maxDischargeKW * 0.2 * this.chargeEfficiency, this.maxChargeKW * 0.2);
    }

    private void ensureSeeds() {
        if (this.evalSeed == null) {
            this.evalSeed = this.service.getRandomSeedRepo().getRandomSeed(String.valueOf(Battery.class.getName()) + "-" + this.name, 0L, "eval");
        }
    }

    public CustomerInfo getCustomerInfo() {
        return this.getCustomerInfo(this.powerType);
    }

    public void step() {
        TariffSubscription subscription = this.getSubscription();
        double regulation = subscription.getRegulation();
        log.info(String.valueOf(this.getName()) + ": regulation " + regulation);
        this.stateOfCharge = regulation > 0.0 ? (this.stateOfCharge -= regulation) : (this.stateOfCharge -= regulation * this.chargeEfficiency);
        double timeslotLength = (double)Competition.currentCompetition().getTimeslotDuration() / 3600000.0;
        this.stateOfCharge = Math.max(0.0, this.stateOfCharge - this.selfDischargeRate * this.capacityKWh * timeslotLength);
        double up = Math.min(this.stateOfCharge, -this.maxDischargeKW * timeslotLength);
        double down = -Math.min((this.capacityKWh - this.stateOfCharge) / this.chargeEfficiency, this.maxChargeKW * timeslotLength);
        subscription.setRegulationCapacity(new RegulationCapacity(subscription, up, down));
        subscription.usePower(0.0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="size of battery in kWh")
    @StateChange
    public void setCapacityKWh(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.capacityKWh = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getCapacityKWh() {
        return this.capacityKWh;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="maximum charge rate")
    @StateChange
    public void setMaxChargeKW(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.maxChargeKW = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getMaxChargeKW() {
        return this.maxChargeKW;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="Maximum discharge rate")
    public void setMaxDischargeKW(double value) {
        this.maxDischargeKW = value;
    }

    public double getMaxDischargeKW() {
        return this.maxDischargeKW;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="ratio of charge energy to battery energy")
    @StateChange
    public void setChargeEfficiency(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        this.chargeEfficiency = value;
        StateLogging.aspectOf().setstate(joinPoint);
    }

    public double getChargeEfficiency() {
        return this.chargeEfficiency;
    }

    @ConfigurableValue(valueType="Double", dump=false, description="hourly charge lost as proportion of capacity")
    public void setSelfDischargeRate(double value) {
        this.selfDischargeRate = value;
    }

    public double getSelfDischargeRate() {
        return this.selfDischargeRate;
    }

    double getStateOfCharge() {
        return this.stateOfCharge;
    }

    void setStateOfCharge(double value) {
        this.stateOfCharge = value;
    }

    private TariffSubscription getSubscription() {
        List subs = this.getCurrentSubscriptions(this.powerType);
        if (subs.size() > 1) {
            log.warn("Multiple subscriptions " + subs.size() + " for " + this.getName());
        }
        return (TariffSubscription)subs.get(0);
    }

    public double getBrokerSwitchFactor(boolean isSuperseding) {
        if (isSuperseding) {
            return 0.0;
        }
        return 0.02;
    }

    public double getTariffChoiceSample() {
        return this.evalSeed.nextDouble();
    }

    public double getInertiaSample() {
        return this.evalSeed.nextDouble();
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        log.info(String.valueOf(this.getName()) + ": evaluate tariffs");
        this.tariffEvaluator.evaluateTariffs();
    }

    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    public CapacityProfile getCapacityProfile(Tariff tariff) {
        Instant start = this.service.getTimeslotRepo().currentTimeslot().getStartInstant();
        double drain = this.capacityKWh * (1.0 - this.chargeEfficiency) / 2.0;
        double[] profile = new double[24];
        Arrays.fill(profile, drain);
        return new CapacityProfile(profile, start);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Battery.java", Battery.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.model.Battery", "", "", ""), 84);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.model.Battery", "java.lang.String", "name", ""), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCapacityKWh", "org.powertac.customer.model.Battery", "double", "value", "", "void"), 230);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMaxChargeKW", "org.powertac.customer.model.Battery", "double", "value", "", "void"), 244);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setChargeEfficiency", "org.powertac.customer.model.Battery", "double", "value", "", "void"), 271);
    }
}

