/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

class DemandElement
implements Serializable {
    private static final long serialVersionUID = -4634719604251761446L;
    private int horizon = 0;
    private double nVehicles = 0.0;
    private double[] distribution = new double[]{0.0};

    DemandElement(int horizon, double nVehicles, double[] distribution) {
        this.horizon = horizon;
        this.nVehicles = nVehicles;
        double dsum = Arrays.stream(distribution).sum();
        if (distribution.length == horizon + 1 && (Math.abs(dsum - 1.0) < 1.0E-6 || nVehicles == 0.0 && dsum == 0.0)) {
            this.distribution = distribution;
        } else {
            this.distribution = new double[horizon + 1];
            int index = 0;
            while (index < horizon + 1 - distribution.length) {
                this.distribution[index++] = 0.0;
            }
            int offset = index;
            while (index < horizon + 1) {
                double dval;
                this.distribution[index] = dval = 0.0 == nVehicles ? 0.0 : distribution[index - offset] / nVehicles;
                ++index;
            }
        }
    }

    DemandElement(DemandElement de, double scale) {
        this.horizon = de.horizon;
        this.nVehicles = de.nVehicles * scale;
        this.distribution = Arrays.copyOf(de.distribution, de.distribution.length);
    }

    DemandElement(int horizon, double nVehicles, double energy, double[] distribution) {
        this(horizon, nVehicles, distribution);
    }

    int getHorizon() {
        return this.horizon;
    }

    double getNVehicles() {
        return this.nVehicles;
    }

    void setNVehicles(double newValue) {
        this.nVehicles = newValue;
    }

    double[] getdistribution() {
        return this.distribution;
    }

    void setDistribution(double[] distribution) {
        this.distribution = distribution;
    }

    void makeCannonical() {
        if (1.0 == this.getNVehicles() && this.distribution.length == this.getHorizon() + 1) {
            return;
        }
        double[] newDist = new double[this.getHorizon() + 1];
        int index = 0;
        while (index < this.getHorizon() + 1 - this.distribution.length) {
            newDist[index++] = 0.0;
        }
        while (index < this.getHorizon() + 1) {
            newDist[index] = this.distribution[index++] / this.getNVehicles();
        }
        this.distribution = newDist;
    }

    public String toString() {
        return String.format("(h%d, n%.7f, e%s)", this.horizon, this.nVehicles, Arrays.toString(this.distribution));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.distribution);
        result = 31 * result + Objects.hash(this.horizon, this.nVehicles);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DemandElement other = (DemandElement)obj;
        return Arrays.equals(this.distribution, other.distribution) && this.horizon == other.horizon && Double.doubleToLongBits(this.nVehicles) == Double.doubleToLongBits(other.nVehicles);
    }
}

