/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.math3.distribution.MixtureMultivariateNormalDistribution;
import org.apache.commons.math3.distribution.MultivariateNormalDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.config.Configurator;
import org.powertac.customer.evcharger.DemandElement;

class DemandSampler {
    private static final Logger log = LogManager.getLogger((String)DemandSampler.class.getSimpleName());
    private MixtureMultivariateNormalDistribution pluginProbability;
    private HashMap<String, MixtureMultivariateNormalDistribution> condHorizonDemandProbabilities = new HashMap();
    private Long currentSeed;
    private RandomDataGenerator randomSeedGenerator;
    private XMLConfiguration config;
    private boolean enabled = true;

    DemandSampler() {
    }

    void initialize(String model, RandomSeed randomSeed) {
        this.initialize(model);
        this.randomSeedGenerator = new RandomDataGenerator();
        this.randomSeedGenerator.reSeed(randomSeed.getValue());
    }

    void initialize(String model) {
        String path = "config/" + model;
        try {
            this.config = Configurator.readXML((String)path);
        }
        catch (ConfigurationException e) {
            log.error("Problem loading configuration. Disabling sampler: " + (Object)((Object)e));
            this.enabled = false;
        }
        catch (Exception e) {
            log.error("Error loading configuration. Disabling sampler: " + e);
            this.enabled = false;
        }
        this.setupPluginProbability();
        this.setupDemandHorizonProbabilities();
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void setCurrentSeed(long seedValue) {
        this.currentSeed = seedValue;
    }

    private void setupPluginProbability() {
        if (!this.isEnabled()) {
            return;
        }
        double[] means = (double[])this.config.get(double[].class, "pluginProbability.means.mean");
        double[] variances = (double[])this.config.get(double[].class, "pluginProbability.covs.cov");
        Array2DRowRealMatrix covariances = new Array2DRowRealMatrix(variances);
        double[] weights = (double[])this.config.get(double[].class, "pluginProbability.weights");
        LinkedList<Pair> mvns = new LinkedList<Pair>();
        int i = 0;
        while (i < means.length) {
            mvns.add(Pair.create((Object)weights[i], (Object)new MultivariateNormalDistribution(null, new double[]{means[i]}, (double[][])new double[][]{covariances.getRow(i)})));
            ++i;
        }
        this.pluginProbability = new MixtureMultivariateNormalDistribution(null, mvns);
    }

    private void setupDemandHorizonProbabilities() {
        String[] instances;
        if (!this.isEnabled()) {
            return;
        }
        String[] stringArray = instances = this.config.getStringArray("instances");
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            String instance = stringArray[n2];
            double[] flatMeans = (double[])this.config.get(double[].class, String.format("%s.means.mean", instance));
            double[] flatCovs = (double[])this.config.get(double[].class, String.format("%s.covs.cov", instance));
            double[] weights = (double[])this.config.get(double[].class, String.format("%s.weights", instance));
            double[][] meanVectors = new double[weights.length][2];
            int i = 0;
            while (i < flatMeans.length / 2) {
                meanVectors[i] = Arrays.copyOfRange(flatMeans, 2 * i, 2 * i + 2);
                ++i;
            }
            double[][][] covarianceMatrices = new double[weights.length][2][2];
            int i2 = 0;
            while (i2 < flatCovs.length / 2 / 2) {
                double[] row1 = Arrays.copyOfRange(flatCovs, 4 * i2, 4 * i2 + 2);
                double[] row2 = Arrays.copyOfRange(flatCovs, 4 * i2 + 2, 4 * i2 + 4);
                covarianceMatrices[i2] = new double[][]{row1, row2};
                ++i2;
            }
            this.condHorizonDemandProbabilities.put(instance, new MixtureMultivariateNormalDistribution(weights, meanVectors, covarianceMatrices));
            ++n2;
        }
    }

    List<DemandElement> sample(int hod, int popSize, double chargerCapacity) {
        if (!this.isEnabled()) {
            return new ArrayList<DemandElement>();
        }
        if (this.randomSeedGenerator != null) {
            this.setCurrentSeed(this.randomSeedGenerator.nextLong(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        int nVehicles = (int)this.sampleNewPlugins(hod, popSize);
        double[][] horizonEnergyTuples = this.sampleHorizonEnergyTuples(nVehicles, hod);
        HashMap<Integer, TreeMap> cohortChargerHoursHistogram = new HashMap<Integer, TreeMap>();
        HashMap<Integer, Integer> cohortVehicleSum = new HashMap<Integer, Integer>();
        int maxHorizon = Arrays.stream(horizonEnergyTuples).mapToInt(horizonEnergyTuple -> (int)horizonEnergyTuple[0]).max().getAsInt();
        double maxEnergy = Arrays.stream(horizonEnergyTuples).mapToDouble(horizonEnergyTuple -> horizonEnergyTuple[1]).max().getAsDouble();
        int maxChargerHours = (int)(maxEnergy / chargerCapacity);
        int i = 0;
        while (i <= maxHorizon) {
            cohortChargerHoursHistogram.put(i, new TreeMap(Comparator.naturalOrder()));
            int j = 0;
            while (j <= maxChargerHours) {
                ((TreeMap)cohortChargerHoursHistogram.get(i)).put(j, 0);
                ++j;
            }
            cohortVehicleSum.put(i, 0);
            ++i;
        }
        double[][] dArray = horizonEnergyTuples;
        int n = horizonEnergyTuples.length;
        int n2 = 0;
        while (n2 < n) {
            double[] horizonEnergyTuple2 = dArray[n2];
            int horizon2 = (int)horizonEnergyTuple2[0];
            double energy = horizonEnergyTuple2[1];
            int chargerHours = (int)(energy / chargerCapacity);
            TreeMap histogram = (TreeMap)cohortChargerHoursHistogram.get(horizon2);
            histogram.merge(Math.min(chargerHours, horizon2), 1, Integer::sum);
            cohortChargerHoursHistogram.put(horizon2, histogram);
            cohortVehicleSum.merge(horizon2, 1, Integer::sum);
            ++n2;
        }
        return cohortVehicleSum.keySet().stream().map(horizon -> new DemandElement((int)horizon, ((Integer)cohortVehicleSum.get(horizon)).intValue(), ((TreeMap)cohortChargerHoursHistogram.get(horizon)).values().stream().mapToDouble(Integer::doubleValue).toArray())).collect(Collectors.toList());
    }

    double sampleNewPlugins(int hod, int popSize) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        double result = this.pluginProbability.density(new double[]{hod}) * (double)popSize;
        NormalDistribution gaussianNoise = new NormalDistribution(0.0, result * 0.1);
        if (this.currentSeed != null) {
            gaussianNoise.reseedRandomGenerator(this.currentSeed.longValue());
        }
        return Math.max(0.0, result += gaussianNoise.sample());
    }

    double[][] sampleHorizonEnergyTuples(int n, int hod) {
        if (!this.isEnabled()) {
            return new double[0][];
        }
        MixtureMultivariateNormalDistribution condDist = this.condHorizonDemandProbabilities.get("hod" + hod);
        if (condDist == null) {
            throw new IllegalArgumentException(String.format("Cannot find distribution for provided hour of day %d.", hod));
        }
        if (this.currentSeed != null) {
            condDist.reseedRandomGenerator(this.currentSeed.longValue());
        }
        double[][] horizonEnergyTuples = condDist.sample(n);
        int i = 0;
        while (i < horizonEnergyTuples.length) {
            horizonEnergyTuples[i][0] = Math.max(horizonEnergyTuples[i][0], 0.0);
            horizonEnergyTuples[i][1] = Math.max(horizonEnergyTuples[i][1], 0.0);
            ++i;
        }
        return horizonEnergyTuples;
    }
}

